/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.bo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.corelayer.proxy.ISQLDesignerProxy;
import com.kingdee.bos.corelayer.proxy.ProxyFactory;
import com.kingdee.bos.datawizard.edd.ctrlreport.app.CtrlDBUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoExisitException;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetRejectException;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataCenterAppPermException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataCenterNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.EntityNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.EntityNoSupportQingException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.EntityParseErrorException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.SuperQueryNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.cosmic.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.data.modal.query.IQuery;
import com.kingdee.cosmic.ctrl.data.modal.query.QueryType;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ExtReportOutDBBO {
    private static final Logger log = LogUtil.getPackageLogger(ExtReportOutDBBO.class);

    private ExtReportOutDBBO() {
    }

    public static List<Map<String, String>> getDBList(Object ctx) throws Exception {
        return ProxyFactory.createSQLDesignerProxy(ctx).getOutDBList();
    }

    public static List<String> getSuperQuerySchemas(Object ctx) throws Exception {
        return ProxyFactory.createSQLDesignerProxy(ctx).getSuperQuerySchemas();
    }

    public static Map<String, String> getDBByDBName(Object ctx, String dbname) throws Exception {
        return ProxyFactory.createSQLDesignerProxy(ctx).getOutDBByDBName(dbname);
    }

    public static int checkDataSourceTouchable(Object ctx, String userId, String dbName) {
        try {
            return ProxyFactory.createSQLDesignerProxy(ctx).checkDataSourceTouchable(userId, dbName);
        }
        catch (Exception e) {
            log.warn((Object)"checkDataSourceisDeletedOrNoPermissionByDBNameErrMsg:", (Throwable)e);
            return 0;
        }
    }

    public static String loadDataSetCreatorIdById(Object ctx, String dataSetId) {
        try {
            return ProxyFactory.createSQLDesignerProxy(ctx).loadDataSetCreatorIdById(dataSetId);
        }
        catch (Exception e) {
            log.warn((Object)"loadDataSetCreaterIdByIdErrMsg:", (Throwable)e);
            return null;
        }
    }

    public static String loadCreatorNameById(Object ctx, String creatorId) {
        try {
            return ProxyFactory.createSQLDesignerProxy(ctx).loadCreatorNameById(creatorId);
        }
        catch (Exception e) {
            log.warn((Object)"loadCreaterNameByIdErrMsg:", (Throwable)e);
            return null;
        }
    }

    public static void checkDataSetByDataSetIdAndModel(Object ctx, CtrlDesignQueryModel model, String dbSetId) throws ExtDataSetNoExisitException, ExtDataSetNoPermissionException, DataCenterNoPermissionException, SuperQueryNoPermissionException, EntityNoPermissionException, DataCenterAppPermException, EntityParseErrorException, EntityNoSupportQingException, ExtDataSetRejectException {
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        IQuery query = null;
        if (commonQuery.getQuery() != null) {
            query = commonQuery.getQuery();
            String outDB = ((CtrlDesignKsqlQuery)query).getOutDB();
            String createrId = ExtReportOutDBBO.loadDataSetCreatorIdById(ctx, dbSetId);
            String createrName = ExtReportOutDBBO.loadCreatorNameById(ctx, createrId);
            ISQLDesignerProxy sqlDesignerProxy = ProxyFactory.createSQLDesignerProxy(ctx);
            if (sqlDesignerProxy.checkDataSetIsPreset(dbSetId)) {
                return;
            }
            if (!sqlDesignerProxy.checkDataSetExecutableById(dbSetId)) {
                throw ExtDataSetRejectException.newInstance();
            }
            if (QueryType.SQL_CUSTOM.equals(query.getQueryType()) && !CtrlDBUtil.isDataCenterName(outDB) && !CtrlDBUtil.isSysSuperQuerySource(outDB)) {
                int result = ExtReportOutDBBO.checkDataSourceTouchable(ctx, createrId, CtrlDBUtil.getDisUserSuperQueryName(outDB));
                if (result == 8099002) {
                    throw ExtDataSetNoExisitException.extDataSetNoExisitException(CtrlDBUtil.getDisUserSuperQueryName(outDB));
                }
                if (result == 8099007) {
                    throw ExtDataSetNoPermissionException.extDataSetNoPermissionException(CtrlDBUtil.getDisUserSuperQueryName(outDB), createrName);
                }
            } else if (QueryType.SQL_CUSTOM.equals(query.getQueryType()) && CtrlDBUtil.isDataCenterName(outDB)) {
                if (!sqlDesignerProxy.checkDBCenterPermissionByUserId(createrId)) {
                    throw new DataCenterNoPermissionException();
                }
                String message = sqlDesignerProxy.checkDBCenterAppPerm(CtrlDBUtil.getAppNumber(outDB));
                if (StringUtils.isNotEmpty((CharSequence)message)) {
                    throw new DataCenterAppPermException(message);
                }
            } else if (StringUtils.isNotEmpty((CharSequence)commonQuery.getOqlModel().getContent())) {
                String entityName = ExtReportOutDBBO.parseEntityName(commonQuery.getOqlModel().getContent());
                int code = sqlDesignerProxy.checkEntityPermissionByUserId(createrId, entityName);
                if (code == 1) {
                    throw new EntityNoPermissionException(entityName);
                }
                if (code == 3) {
                    throw new EntityNoSupportQingException(entityName);
                }
                if (code == 2) {
                    throw new EntityParseErrorException();
                }
            }
            ExtReportOutDBBO.markOwnerForSuperQuery(ctx, (CtrlDesignKsqlQuery)query, dbSetId);
        }
    }

    private static String parseEntityName(String sContent) {
        String sEntityName = "";
        if (StringUtils.isEmpty((CharSequence)sContent)) {
            return sEntityName;
        }
        String sql = sContent.replaceAll("--.*", "").replaceAll("(?m)\\s#.*$", "").replaceAll("//.*", "").replaceAll("/\\*[\\s\\S]*\\*/", "").trim().toLowerCase();
        Pattern pattern = Pattern.compile("\\bfrom\\b", 2);
        Matcher matcher = pattern.matcher(sql);
        if (!matcher.find()) {
            return sEntityName;
        }
        int fromIndex = matcher.start();
        String tableSubStr = sql.substring(fromIndex + 4).trim();
        int commaIndex = tableSubStr.indexOf(44);
        int blankIndex = tableSubStr.indexOf(" ");
        int endLineIndex = tableSubStr.indexOf(10);
        int returnIndex = tableSubStr.indexOf(13);
        int splitIndex = tableSubStr.indexOf(";");
        if (commaIndex == -1 && blankIndex == -1 && endLineIndex == -1 && returnIndex == -1 && splitIndex == -1) {
            sEntityName = tableSubStr;
        } else {
            int endIndex = tableSubStr.length();
            if (commaIndex != -1) {
                endIndex = commaIndex;
            }
            if (blankIndex != -1 && blankIndex < endIndex) {
                endIndex = blankIndex;
            }
            if (endLineIndex != -1 && endLineIndex < endIndex) {
                endIndex = endLineIndex;
            }
            if (returnIndex != -1 && returnIndex < endIndex) {
                endIndex = returnIndex;
            }
            if (splitIndex != -1 && splitIndex < endIndex) {
                endIndex = splitIndex;
            }
            sEntityName = tableSubStr.substring(0, endIndex);
        }
        return sEntityName.trim();
    }

    public static void markOwnerForSuperQuery(Object ctx, CtrlDesignKsqlQuery query, String dataSetId) {
        String outDB = query.getOutDB();
        if (CtrlDBUtil.isSuperQuerySource(outDB)) {
            String creatorId = null;
            if (!CtrlDBUtil.isSysSuperQuerySource(outDB)) {
                try {
                    Map<String, String> dbProp = ExtReportOutDBBO.getDBByDBName(ctx, CtrlDBUtil.getDisUserSuperQueryName(outDB));
                    creatorId = dbProp.get("ownerId");
                }
                catch (Exception e) {
                    log.error((Object)"getDBByDBName error:", (Throwable)e);
                }
            } else {
                creatorId = ExtReportOutDBBO.loadDataSetCreatorIdById(ctx, dataSetId);
            }
            query.setProperty("ownerId", creatorId);
        }
    }

    public static DataCenterInfo getDataCenterFromCache(Object ctx, String outDB) throws Exception {
        Map<String, String> map = ExtReportOutDBBO.getDBByDBName(ctx, outDB);
        if (map == null) {
            throw new OutDbNotFoundException("Not found the datacenter :" + outDB + ", please setup it first");
        }
        DataCenterInfo vo = new DataCenterInfo();
        vo.setDbCenterName(CtrlReportUtil.getObjectString(map.get("dbcentername")));
        vo.setDbType(Integer.parseInt(CtrlReportUtil.getObjectString(map.get("dbtype"))));
        vo.setOwnerId(CtrlReportUtil.getObjectString(map.get("ownerId")));
        return vo;
    }

    public static class OutDbNotFoundException
    extends BOSException {
        private static final long serialVersionUID = -65536L;

        public OutDbNotFoundException(String message) {
            super(message);
        }
    }
}

