/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.bo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.boslayer.bos.util.BOSUuid;
import com.kingdee.bos.boslayer.eas.framework.report.util.RptParams;
import com.kingdee.bos.corelayer.proxy.ISQLDesignerProxy;
import com.kingdee.bos.corelayer.proxy.ProxyFactory;
import com.kingdee.bos.datawizard.edd.ctrlreport.ReportFacadeFactory;
import com.kingdee.bos.datawizard.edd.ctrlreport.datasetfactory.IExtendReport;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.KSQLReportInfo;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CycleException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataSetContentNotExistsException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataSetNotPresetPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignInputStream;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DataSetDefineModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DefDbsourceModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.SqlDSModelDrill;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.bos.extreport.utils.XMLUtil;
import com.kingdee.bos.framework.core.util.Messages;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.ThreadLocalUtil;
import com.kingdee.cosmic.ctrl.data.modal.DefObj;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class KSQLReportBO {
    private static final Logger log = LogUtil.getPackageLogger(KSQLReportBO.class);
    private static final Map EMPTY_MAP = new HashMap(0);
    private static final String presetUserId = "100000";

    public static CtrlDesignQueryModel initModel(Object ctx, DataSetDefineModel sqlDataSetDefineModel) throws CycleException, CtrlReportException {
        if (sqlDataSetDefineModel == null) {
            return null;
        }
        String dbsourceid = sqlDataSetDefineModel.getId();
        String dbsourcename = sqlDataSetDefineModel.getName();
        String isolateTag = sqlDataSetDefineModel.getIsolateTag();
        ISQLDesignerProxy sqlDesignerProxy = ProxyFactory.createSQLDesignerProxy(ctx);
        if (presetUserId.equals(isolateTag) && !sqlDesignerProxy.checkPresetManagePermission()) {
            throw new DataSetNotPresetPermissionException(Messages.getMLS("noPermissionForPresetDatasetPleaseContactAdminForAuthorization", "\u60a8\u6ca1\u6709\u8be5\u9884\u7f6e\u6570\u636e\u96c6\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u201c\u7ba1\u7406\u5458\u201d\u8fdb\u884c\u6388\u6743\u3002"));
        }
        String groupId = sqlDataSetDefineModel.getGroupID();
        String groupName = sqlDataSetDefineModel.getGroupName();
        return KSQLReportBO.initModel(ctx, groupId, groupName, dbsourceid, dbsourcename, isolateTag, null);
    }

    public static CtrlDesignQueryModel initModel(Object ctx, ExtDataSet ds, Set<String> circularDependencySet) throws CycleException, CtrlReportException {
        String define = ds.getDefine();
        DataSetDefineModel sqlDataSetDefineModel = DataSetDefineModel.parseDefine(define);
        if (sqlDataSetDefineModel == null) {
            return null;
        }
        String dbsourceid = sqlDataSetDefineModel.getId();
        String dbsourcename = sqlDataSetDefineModel.getName();
        String isolateTag = sqlDataSetDefineModel.getIsolateTag();
        ISQLDesignerProxy sqlDesignerProxy = ProxyFactory.createSQLDesignerProxy(ctx);
        Boolean isPresetPublish = (Boolean)ThreadLocalUtil.get((String)"isPresetPublish");
        if (!Boolean.TRUE.equals(isPresetPublish) && presetUserId.equals(isolateTag) && !sqlDesignerProxy.checkPresetManagePermission()) {
            throw new DataSetNotPresetPermissionException(Messages.getMLS("noPermissionForPresetDatasetPleaseContactAdminForAuthorization", "\u60a8\u6ca1\u6709\u8be5\u9884\u7f6e\u6570\u636e\u96c6\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u201c\u7ba1\u7406\u5458\u201d\u8fdb\u884c\u6388\u6743\u3002"));
        }
        String groupId = sqlDataSetDefineModel.getGroupID();
        String groupName = sqlDataSetDefineModel.getGroupName();
        String innerLink = sqlDataSetDefineModel.getInnerLink();
        CtrlDesignQueryModel model = null;
        if (!StringUtils.isEmpty(innerLink)) {
            String innerLinkXmlString = ds.getMeta();
            innerLinkXmlString = SqlDSModelDrill.split2(innerLinkXmlString);
            model = KSQLReportBO.initModelFromXml(ctx, innerLinkXmlString, circularDependencySet);
        } else {
            model = KSQLReportBO.initModel(ctx, groupId, groupName, dbsourceid, dbsourcename, isolateTag, circularDependencySet);
        }
        return model;
    }

    public static CtrlDesignQueryModel initModel(Object easCtx, DefObj defDBsource, Set<String> circularDependencySet) throws CtrlReportException, CycleException {
        DefDbsourceModel defDbsourceModel = new DefDbsourceModel(defDBsource);
        String datasetID = defDbsourceModel.getID();
        String groupId = defDbsourceModel.getGroupID();
        String groupName = defDbsourceModel.getGroupName();
        String innerLinkXmlString = (String)defDBsource.getProperty("ExtReportInnerDSContent");
        CtrlDesignQueryModel model = null;
        if (!StringUtils.isEmpty(innerLinkXmlString)) {
            model = KSQLReportBO.initModelFromXml(easCtx, innerLinkXmlString, circularDependencySet);
        } else {
            String isolateTag = defDbsourceModel.getIsolateTag();
            ISQLDesignerProxy sqlDesignerProxy = ProxyFactory.createSQLDesignerProxy(easCtx);
            if (presetUserId.equals(isolateTag) && !sqlDesignerProxy.checkPresetManagePermission()) {
                throw new DataSetNotPresetPermissionException(Messages.getMLS("noPermissionForPresetDatasetPleaseContactAdminForAuthorization", "\u60a8\u6ca1\u6709\u8be5\u9884\u7f6e\u6570\u636e\u96c6\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u201c\u7ba1\u7406\u5458\u201d\u8fdb\u884c\u6388\u6743\u3002"));
            }
            String dbsourcename = defDbsourceModel.getName();
            model = KSQLReportBO.initModel(easCtx, groupId, groupName, datasetID, dbsourcename, isolateTag, circularDependencySet);
        }
        return model;
    }

    public static CtrlDesignQueryModel initModel(Object ctx, String datasetID, Set<String> circularDependencySet) throws CtrlReportException, CycleException {
        return KSQLReportBO.initModel(ctx, null, null, datasetID, null, null, circularDependencySet);
    }

    public static CtrlDesignQueryModel initModelFromXml(Object ctx, String xmlContent, Set<String> circularDependencySet) throws CtrlReportException, CycleException {
        return KSQLReportBO.initModel(ctx, null, null, null, null, null, xmlContent, null, circularDependencySet);
    }

    public static CtrlDesignQueryModel initModel(Object ctx, String groupId, String groupName, String datasetID, String dbsourcename, String isolateTag, Set<String> circularDependencySet) throws CtrlReportException, CycleException {
        return KSQLReportBO.initModel(ctx, groupId, groupName, datasetID, dbsourcename, isolateTag, "", EMPTY_MAP, circularDependencySet);
    }

    private static CtrlDesignQueryModel initModel(Object ctx, String groupId, String groupName, String datasetID, String dbsourcename, String isolateTag, String innerLinkXmlString, Map mapNoFoundQuery, Set<String> circularDependencySet) throws CtrlReportException, CycleException {
        CtrlDesignInputStream inputStream = null;
        IXmlElement root = null;
        if (StringUtils.isNotEmpty(innerLinkXmlString)) {
            try {
                innerLinkXmlString = innerLinkXmlString.replaceAll("\\\\\"", "\"");
                innerLinkXmlString = innerLinkXmlString.replaceAll("\\\\t", " ");
                innerLinkXmlString = innerLinkXmlString.replaceAll("\\\\n", "\n");
                innerLinkXmlString = innerLinkXmlString.replaceAll("\\\\r", " ");
                innerLinkXmlString = innerLinkXmlString.replaceAll("  ", " ");
                ByteArrayInputStream in = new ByteArrayInputStream(innerLinkXmlString.getBytes(StandardCharsets.UTF_8));
                root = XMLUtil.loadRootElement(in);
            }
            catch (Exception e) {
                throw CtrlReportException.makeException(Messages.getMLS("parseEmbeddedDataSourceError", "\u89e3\u6790\u5185\u5d4c\u6570\u636e\u6e90\u9519\u8bef"), e);
            }
        } else {
            if (circularDependencySet != null && StringUtils.isNotEmpty(datasetID)) {
                if (circularDependencySet.contains(datasetID)) {
                    throw new CycleException(Messages.getMLS("circularDependencyBetweenDatasets", "\u6570\u636e\u96c6\u95f4\u5b58\u5728\u5faa\u73af\u4f9d\u8d56"));
                }
                circularDependencySet.add(datasetID);
            }
            if (!(inputStream = new CtrlDesignInputStream(ctx, groupId, groupName, datasetID, dbsourcename, isolateTag)).isFound()) {
                log.warn((Object)(Messages.getMLS("dataSourceNotFound", "\u627e\u4e0d\u5230\u6570\u636e\u6e90") + "groupId = " + groupId + ", groupName = " + groupName + ", datasetID = " + datasetID + ", dbsourcename = " + dbsourcename + ", isolateTag = " + isolateTag));
                throw new DataSetContentNotExistsException(Messages.getMLS("undefinedDatasetContent", "\u672a\u5b9a\u4e49\u6570\u636e\u96c6\u5185\u5bb9"));
            }
        }
        CtrlDesignQueryModel model = new CtrlDesignQueryModel();
        if (root != null) {
            CtrlDesignUtil.toObject(ctx, model, root, circularDependencySet);
        } else if (inputStream != null) {
            inputStream.getInputObject(model, circularDependencySet);
        }
        return model;
    }

    public static KSQLReportInfo getKSQLReportInfo(Object ctx, String datasetID) throws Exception {
        ISQLDesignerProxy sqlDesignerProxy = ProxyFactory.createSQLDesignerProxy(ctx);
        return sqlDesignerProxy.findDataSource(datasetID);
    }

    public static KSQLReportInfo getKSQLReportInfo(Object ctx, String groupId, String groupName, String datasetID, String dbsourcename, String isolateTag) throws Exception {
        ISQLDesignerProxy sqlDesignerProxy = ProxyFactory.createSQLDesignerProxy(ctx);
        return sqlDesignerProxy.findDataSource(groupId, groupName, datasetID, dbsourcename, isolateTag);
    }

    public static String getGroupFullPathById(Object ctx, String groupId) throws Exception {
        ISQLDesignerProxy sqlDesignerProxy = ProxyFactory.createSQLDesignerProxy(ctx);
        return sqlDesignerProxy.loadExtReportGroupFullPathById(groupId);
    }

    public static final String saveKSQL(Object ctx, byte[] data, String fid, Map mapName, String groupID, int customType) throws Exception {
        KSQLReportInfo info = new KSQLReportInfo();
        info.setBOSUuid("fid", new BOSUuid(fid));
        info.setContent(data);
        info.setName((String)mapName.get(new Locale("l2", "").toString()));
        info.setSystemID(groupID);
        info.setString("customtype", String.valueOf(customType));
        ISQLDesignerProxy sqlDesignerProxy = ProxyFactory.createSQLDesignerProxy(ctx);
        fid = sqlDesignerProxy.saveOrUpdate(info);
        return fid;
    }

    public static final boolean isExitsName(Object ctx, String userId, String fSystemID, String strId, String fname) throws BOSException {
        RptParams pr = new RptParams();
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuilder sbSQL = new StringBuilder();
        if (StringUtil.isEmptyString((String)strId)) {
            sbSQL.append("SELECT FID FROM T_QING_DATASET_INFO WHERE FGROUPID = ?  AND FCREATORID = ? ");
            sbSQL.append("AND FNAME").append(" = ?");
            queryValue.add(fSystemID);
            queryValue.add(userId);
            queryValue.add(fname);
        } else {
            sbSQL.append("SELECT FID FROM T_QING_DATASET_INFO WHERE FID <> ? AND FGROUPID = ? AND FCREATORID = ? ");
            sbSQL.append("AND FNAME").append(" = ?");
            queryValue.add(strId);
            queryValue.add(fSystemID);
            queryValue.add(userId);
            queryValue.add(fname);
        }
        pr.setString("sql", sbSQL.toString());
        pr.setObject("lstValue", queryValue);
        pr.setString("MethodName", "exitsRecordBySQL");
        RptParams psR = ReportFacadeFactory.getRemoteInstance().commonExecute(ctx, pr);
        return psR.getBoolean("flag");
    }

    public static final boolean isExitsProce(Object ctx, String outDB, String proceName, int dbType) throws BOSException {
        RptParams ps_r;
        HashMap mapReturn;
        RptParams pr = new RptParams();
        String strSQL = null;
        if (dbType == 3) {
            strSQL = "/*dialect*/select su.name as owner ,sb.name as procedurename from sysobjects sb, sysusers su where sb.uid = su.uid and sb.type = 'p' and sb.name = '" + proceName.toUpperCase() + "'";
        } else if (dbType == 2) {
            if (proceName.indexOf(".") != -1) {
                String[] arr = proceName.split("\\.");
                String object_name = arr[0];
                String procedure_name = arr[1];
                strSQL = "/*dialect*/select t.owner, t.object_name as procedurename from all_procedures t where t.object_name = '" + object_name.toUpperCase() + "' and t.procedure_name = '" + procedure_name.toUpperCase() + "'";
            } else {
                strSQL = "/*dialect*/select t.owner, t.object_name as procedurename from all_procedures t where t.object_name = '" + proceName.toUpperCase() + "' and t.procedure_name is null";
            }
        } else if (dbType == 1) {
            strSQL = "/*dialect*/select procschema as owner, procname as procedurename from syscat.procedures where procname= '" + proceName.toUpperCase() + "'";
        } else if (dbType == 5) {
            strSQL = "/*dialect*/select p.proowner as owner, p.proname as procedurename from pg_proc p where p.proname = '" + proceName.toLowerCase() + "'";
        } else if (dbType == 6) {
            strSQL = "/*dialect*/select * from `information_schema`.`ROUTINES` where SPECIFIC_NAME='" + proceName.toUpperCase() + "'";
        }
        pr.setString("MethodName", "getInfoMapBySQL");
        pr.setString("sql", strSQL);
        if (!StringUtils.isEmpty(outDB)) {
            pr.setObject("outDB", outDB);
        }
        return !(mapReturn = (HashMap)(ps_r = FacadeFactory.commonExecute(ctx, pr)).getObject("object")).isEmpty();
    }

    public static final ArrayList getUserProceList(String outDB, int dbType) throws BOSException {
        RptParams pr = new RptParams();
        String strSQL = null;
        if (dbType == 3) {
            strSQL = "/*dialect*/select su.name as owner ,sb.name as procedurename from sysobjects sb, sysusers su where sb.uid = su.uid and sb.type = 'p' and OBJECTPROPERTY(id, 'IsMSShipped')=0";
        } else if (dbType == 2) {
            strSQL = "/*dialect*/select t.owner, t.object_name as procedurename from all_procedures t, user_procedures u, user_objects o where t.object_name = u.object_name and t.object_name = o.object_name and o.object_type = 'PROCEDURE'";
        } else if (dbType == 1) {
            strSQL = "/*dialect*/select procschema as owner, procname as procedurename from syscat.procedures where definer <> 'SYSIBM'";
        }
        pr.setString("MethodName", "getInfoListBySQL");
        pr.setString("sql", strSQL);
        if (!StringUtils.isEmpty(outDB)) {
            pr.setObject("outDB", outDB);
        }
        RptParams ps_r = FacadeFactory.commonExecute(null, pr);
        ArrayList lstReturn = (ArrayList)ps_r.getObject("object");
        return lstReturn;
    }

    public static IExtendReport getExtendReport(Object context, String define) throws Exception {
        DataSetDefineModel sqlDataSetDefineModel = DataSetDefineModel.parseDefine(define);
        if (sqlDataSetDefineModel == null) {
            return null;
        }
        String dataSetType = sqlDataSetDefineModel.getType();
        String dbType = KSQLReportBO.getDBType(dataSetType);
        String dbsourceid = sqlDataSetDefineModel.getId();
        return CtrlReportQuery.getIReportInstance(context, dbType, dbsourceid);
    }

    private static String getDBType(String dataSetType) {
        if (dataSetType.equals("sql_ksql")) {
            return "2";
        }
        if (dataSetType.equals("sql_enum")) {
            return "6";
        }
        if (dataSetType.equals("sql_bosquery")) {
            return "3";
        }
        if (dataSetType.equals("sql_fix")) {
            return "4";
        }
        if (dataSetType.equals("sql_oql")) {
            return "9";
        }
        return "";
    }
}

