/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.datasetfactory;

import com.kingdee.bos.datawizard.edd.ctrlreport.bo.BlobBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.KSQLReportBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.datasetfactory.IExtendReport;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.ExtBizData;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InOutputParamVO;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DataSetDefineModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.framework.core.util.Messages;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.DataConvert;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IExtDataSetFactory;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.jdbc.rowset.impl.SerialBlob;
import com.kingdee.util.StringUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataSetBaseFactory
implements IExtDataSetFactory {
    private static final Logger log = Logger.getLogger(DataSetBaseFactory.class);
    public static final String db_type = "type";
    public static final String db_dbsourceid = "dbsourceid";
    public static final String db_model = "model";
    protected ExtDataSetType dsType = null;

    public ExtDataSet getDataSet(Book book, String name, String define) {
        if (StringUtils.isEmpty((String)define)) {
            return null;
        }
        ExtDataSetType oldType = ExtDataSetType.getExtDataSetType((String)define);
        if (oldType == null) {
            oldType = this.dsType;
        }
        return new ExtDataSet(book, name, oldType.trimPrefix(define), this.dsType);
    }

    public static ExtBizData createExtBizData(ExtDataSet ds, ExecutionContext execCtx) throws Exception {
        String define = ds.getDefine();
        ExtBizData ebd = new ExtBizData();
        boolean isExistInnerParam = false;
        Map mapParameterImpl = execCtx.getDataSetParameters();
        Map<String, DesignParameter> mapDesignParam = RunReportParam.extParam2DesignParma(mapParameterImpl);
        for (String name : mapDesignParam.keySet()) {
            if (name.indexOf("ExtRptCurrent") == -1) continue;
            isExistInnerParam = true;
            break;
        }
        Object bictx = null;
        if (execCtx.getDataSetCacheObject((Object)"Context") != null) {
            bictx = execCtx.getDataSetCacheObject((Object)"Context");
        }
        if (!isExistInnerParam) {
            RunReportParam.putDefalutListParamsMap(bictx, mapDesignParam);
        }
        ebd.setParams(mapDesignParam);
        ArrayList<Map<String, Object>> reportDBModel = (ArrayList<Map<String, Object>>)execCtx.getDataSetCacheObject((Object)"CurrentReportDBModel");
        if (reportDBModel == null) {
            reportDBModel = new ArrayList<Map<String, Object>>();
        }
        DataSetDefineModel sqlDataSetDefineModel = DataSetDefineModel.parseDefine(define);
        boolean isFindCurrentDBSource = false;
        String dbsourceID = null;
        if (sqlDataSetDefineModel != null) {
            dbsourceID = sqlDataSetDefineModel.getId();
            for (HashMap hashMap : reportDBModel) {
                CtrlDesignQueryModel model = (CtrlDesignQueryModel)hashMap.get(db_model);
                Boolean isHyperlink = (Boolean)execCtx.getDataSetCacheObject((Object)"isHyperLink");
                if (null != model && Boolean.TRUE.equals(isHyperlink)) {
                    model.setSql(null);
                }
                String type = (String)hashMap.get(db_type);
                String id = (String)hashMap.get(db_dbsourceid);
                if (!type.equals("sql_ksql") && !type.equals("sql_oql") || !id.equals(dbsourceID)) continue;
                isFindCurrentDBSource = true;
                break;
            }
        }
        if (!isFindCurrentDBSource && sqlDataSetDefineModel != null) {
            CtrlDesignQueryModel model = KSQLReportBO.initModel(bictx, ds, null);
            if (model == null) {
                String string = sqlDataSetDefineModel.getInnerLink();
                if (!StringUtils.isEmpty((String)string)) {
                    log.error((Object)Messages.getMLS("embeddedDataSourceModelNotFound", "\u627e\u4e0d\u5230\u5185\u5d4c\u6570\u636e\u6e90\u6a21\u578b"));
                    MiscUtil.log((int)1, (String)Messages.getMLS("embeddedDataSourceModelNotFound", "\u627e\u4e0d\u5230\u5185\u5d4c\u6570\u636e\u6e90\u6a21\u578b"));
                } else {
                    log.error((Object)Messages.getMLS("dataSourceModel1Error2_3", "\u6570\u636e\u6e90\u6a21\u578b#1\u9519\u8bef#2#3").replace("#1", "initModel").replace("#2", ", define = ").replace("#3", define));
                    MiscUtil.log((int)1, (String)Messages.getMLS("dataSourceModel1Error2_3", "\u6570\u636e\u6e90\u6a21\u578b#1\u9519\u8bef#2#3").replace("#1", "initModel").replace("#2", ", define = ").replace("#3", define));
                }
                return null;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(db_type, ExtDataSetType.getExtDataSetType((String)define).getType());
            hashMap.put(db_dbsourceid, dbsourceID);
            hashMap.put(db_model, model);
            reportDBModel.add(hashMap);
        }
        DataSetBaseFactory.setDynamicField(reportDBModel, ds, dbsourceID);
        ebd.setReportDBModel(reportDBModel);
        return ebd;
    }

    public boolean updateDataSet(ExtDataSet ds, ExecutionContext execCtx) {
        long start = System.currentTimeMillis();
        if (MiscUtil.shouldLog()) {
            MiscUtil.log((int)0, (String)Messages.getMLS("startDataFetching", "--\u6570\u636e\u96c6\u53d6\u6570\u5f00\u59cb--"));
        } else {
            log.info((Object)Messages.getMLS("startDataFetching", "--\u6570\u636e\u96c6\u53d6\u6570\u5f00\u59cb--"));
        }
        try {
            ExtBizData ebd = DataSetBaseFactory.createExtBizData(ds, execCtx);
            if (ebd == null) {
                return false;
            }
            String define = ds.getDefine();
            int length = -1;
            boolean isLimitRecord = Boolean.parseBoolean(CtrlReportUtil.getObjectString(execCtx.getDataSetCacheObject((Object)"isLimitRecord")));
            boolean isLimitComplete = Boolean.parseBoolean(CtrlReportUtil.getObjectString(execCtx.getDataSetCacheObject((Object)"isLimitComplete")));
            if (isLimitComplete) {
                length = 1000;
            }
            if (isLimitRecord) {
                length = 100;
            }
            if (execCtx.isUserInterrupted()) {
                return false;
            }
            Object context = execCtx.getDataSetCacheObject((Object)"Context");
            IExtendReport extendReport = KSQLReportBO.getExtendReport(context, define);
            assert (extendReport != null);
            ebd.execute(extendReport, 0, length);
            if (execCtx.isUserInterrupted()) {
                return false;
            }
            if (ebd.isCancel()) {
                return false;
            }
            this.putRsToDataSet(ebd.getRs(), ds, execCtx);
            if (execCtx.isUserInterrupted()) {
                ds.clear();
                ds.clearData();
                ds.clearQSInfo();
                return false;
            }
            DataSetBaseFactory.attachOutput2Context(execCtx, ebd);
        }
        catch (Exception e) {
            log.error((Object)"DataSetBaseFactory.updateDataSet", (Throwable)e);
            MiscUtil.log((Throwable)e);
            return false;
        }
        if (MiscUtil.shouldLog()) {
            MiscUtil.log((int)0, (String)Messages.getMLS("datasetFetchSuccessReturnTimeConsumed1", "\u6570\u636e\u96c6\u53d6\u6570\u6210\u529f\u8fd4\u56de\uff1a\u6d88\u8017\u65f6\u95f4\u3010#1\u3011").replace("#1", String.valueOf(System.currentTimeMillis() - start)));
        } else {
            log.info((Object)Messages.getMLS("datasetFetchSuccessReturnTimeConsumed1", "\u6570\u636e\u96c6\u53d6\u6570\u6210\u529f\u8fd4\u56de\uff1a\u6d88\u8017\u65f6\u95f4\u3010#1\u3011").replace("#1", String.valueOf(System.currentTimeMillis() - start)));
        }
        return true;
    }

    private static void attachOutput2Context(ExecutionContext execCtx, ExtBizData ebd) {
        HashMap<String, ParameterImpl> outputParameterImpl = new HashMap<String, ParameterImpl>(8);
        HashMap outputParamMap = ebd.getOutputParamMap();
        for (Map.Entry next : outputParamMap.entrySet()) {
            InOutputParamVO iov = (InOutputParamVO)next.getValue();
            ParameterImpl p = new ParameterImpl();
            p.setName(iov.getName());
            p.setValue(RunReportParam.getOutputParamVariant(iov.getValue(), iov.getDataType()));
            int iovType = iov.getDataType();
            if (iovType == 0) {
                iovType = 0;
            } else if (iovType == 1 || iovType == 2) {
                iovType = 1;
            }
            p.setDataType(iovType);
            outputParameterImpl.put(p.getName(), p);
        }
        execCtx.attachDataSetOutputParameters(outputParameterImpl);
    }

    private static void setDynamicField(List<Map<String, Object>> reportDBModel, ExtDataSet ds, String dbsourceid) {
        if (reportDBModel != null) {
            for (Map<String, Object> dbModel : reportDBModel) {
                String type = (String)dbModel.get(db_type);
                String id = (String)dbModel.get(db_dbsourceid);
                if (!type.equals("sql_ksql") && !type.equals("sql_oql") || !id.equals(dbsourceid)) continue;
                CtrlDesignQueryModel model = (CtrlDesignQueryModel)dbModel.get(db_model);
                String isDynamicField = CtrlReportUtil.getObjectString(model.getCommonQuery().getProperty(CtrlDesignUtil.isDynamicField));
                if (StringUtils.isEmpty((String)isDynamicField)) {
                    isDynamicField = "false";
                }
                ds.setDynamicFields(Boolean.parseBoolean(isDynamicField));
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void putRsToDataSet(ResultSet rs, ExtDataSet ds, ExecutionContext execCtx) {
        if (null == rs) {
            MiscUtil.log((int)4, (String)(Messages.getMLS("resultSet1", "\u7ed3\u679c\u96c6\uff1a") + "null"));
            return;
        }
        try {
            StringBuilder sbRsmd = new StringBuilder();
            int columnCount = 0;
            ResultSetMetaData rsmd = null;
            DataConvert.IDataConvert[] convert = null;
            rsmd = rs.getMetaData();
            columnCount = rsmd.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                String columnName = rsmd.getColumnName(i + 1);
                int columnType = rsmd.getColumnType(i + 1);
                sbRsmd.append("columnName: ").append(columnName).append(", columnType: ").append(columnType).append("\r\n");
                ds.addColumn(new ExtColumn(ds, columnName, i, columnType));
            }
            convert = DataConvert.getConvertArray((ExtDataSet)ds);
            boolean useQS = false;
            rs.last();
            int row = rs.getRow();
            int qsRows = 0;
            if (row * columnCount >= ExtConst.QS_MAX_CELLS) {
                useQS = true;
                qsRows = ExtConst.QS_MAX_CELLS / columnCount;
                ds.setQsRows(qsRows);
                ds.setDataRows(row);
            }
            rs.beforeFirst();
            if (!useQS) {
                ObjectArray al = new ObjectArray(row);
                int rsSize = 0;
                while (rs.next() && !execCtx.isUserInterrupted()) {
                    int i;
                    Variant[] rowData = new Variant[convert.length];
                    int size = Math.min(columnCount, convert.length);
                    for (i = 0; i < size; ++i) {
                        Object data = rs.getObject(i + 1);
                        if (data != null && (data.getClass().getName().equals("oracle.sql.TIMESTAMP") || data.getClass().getName().equals("oracle.sql.DATE"))) {
                            data = RunReportParam.getOracleDateValue(data);
                        } else if (data instanceof SerialBlob) {
                            SerialBlob sb = (SerialBlob)rs.getObject(i + 1);
                            data = BlobBO.readBlob(sb);
                        }
                        rowData[i] = convert[i].convertObject(data);
                    }
                    while (i < rowData.length) {
                        rowData[i] = Variant.nullVariant;
                        ++i;
                    }
                    al.append((Object)rowData);
                    ++rsSize;
                }
                MiscUtil.log((int)4, (String)(Messages.getMLS("recordCount", "\u8bb0\u5f55\u6570\uff1a") + rsSize));
                MiscUtil.log((int)4, (String)(Messages.getMLS("fieldInfo", "\u5b57\u6bb5\u4fe1\u606f\uff1a") + sbRsmd));
                al.trimToSize();
                ds.setData(al);
            } else {
                ds.setResultSetStub(rs);
                ds.setCurrentGroup();
            }
        }
        catch (Exception e) {
            log.error((Object)"DataSetBaseFactory.putRsToDataSet", (Throwable)e);
        }
        finally {
            DataSetBaseFactory.rsClose(rs);
        }
    }

    private static final void rsClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception ex) {
                log.error((Object)"DataSetBaseFactory.rsClose", (Throwable)ex);
            }
        }
    }
}

