/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.datasetfactory;

import com.kingdee.bos.boslayer.eas.framework.report.util.RptParams;
import com.kingdee.bos.corelayer.proxy.ISQLDesignerProxy;
import com.kingdee.bos.corelayer.proxy.ProxyFactory;
import com.kingdee.bos.datawizard.edd.ctrlreport.ReportFacadeFactory;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.ExtReportOutDBBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.KSQLReportBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.datasetfactory.IExtendReport;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CycleException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataSetContentNotExistsException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.SuperQueryNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.framework.core.util.Messages;
import com.kingdee.cosmic.ctrl.common.DataType;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.data.modal.Outputs;
import com.kingdee.cosmic.ctrl.data.modal.types.rows.OutputColumn;
import com.kingdee.cosmic.ctrl.data.modal.types.rows.OutputColumns;
import java.awt.Window;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SQLReportImpl
implements IExtendReport {
    private static final Logger log = LogUtil.getPackageLogger(SQLReportImpl.class);
    private CtrlDesignQueryModel model;
    private List reportDBModel;
    private Window datasetParent;
    protected Object ctx;
    protected String dbsourceid;
    protected String solutionID;
    protected String parameterXmlString;
    protected int shareType;
    protected Map mapParam = new HashMap();

    public SQLReportImpl(Object ctx, String dbsourceid) {
        this.ctx = ctx;
        this.dbsourceid = dbsourceid;
    }

    @Override
    public String getDBSourceId() {
        return this.dbsourceid;
    }

    protected CtrlDesignQueryModel getKSQLModel() throws CtrlReportException, SuperQueryNoPermissionException {
        if (this.model == null) {
            if (this.reportDBModel != null) {
                for (HashMap dbModel : this.reportDBModel) {
                    String type = (String)dbModel.get("type");
                    String id = (String)dbModel.get("dbsourceid");
                    if (!type.equals("sql_ksql") && !type.equals("sql_oql") || !id.equals(this.dbsourceid)) continue;
                    this.model = (CtrlDesignQueryModel)dbModel.get("model");
                }
            } else {
                try {
                    this.model = KSQLReportBO.initModel(this.ctx, this.dbsourceid, null);
                }
                catch (CycleException e) {
                    throw CtrlReportException.makeException(e);
                }
            }
            if (this.model != null && this.model.getCommonQuery() != null) {
                ExtReportOutDBBO.checkDataSetByDataSetIdAndModel(this.ctx, this.model, this.dbsourceid);
            }
        }
        return this.model;
    }

    @Override
    public Object getDbSourceDataList(int start, int rows) throws Exception {
        this.getKSQLModel();
        if (null == this.model) {
            log.error((Object)("model is null, dbsourceid = " + this.dbsourceid));
        }
        if (this.mapParam == null) {
            log.error((Object)"mapParam is null");
        }
        return CtrlDesignDataExecutor.execute(this.ctx, this.model, this.mapParam, null, start, rows, true, this.datasetParent);
    }

    @Override
    public List<Map<String, String>> getDbSourceFieldList() throws Exception {
        this.getKSQLModel();
        return SQLReportImpl.getSqlReportDbSrcFieldList(this.model);
    }

    public static List<Map<String, String>> getSqlReportDbSrcFieldList(CtrlDesignQueryModel model) throws CtrlReportException {
        ArrayList<Map<String, String>> lstRet = new ArrayList<Map<String, String>>();
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)model.getQuery();
        if (ksqlQuery.getGoodOutput().equals("false")) {
            throw new CtrlReportException();
        }
        Outputs outputs = model.getCommonQuery().getOutputs();
        if (outputs == null) {
            throw new DataSetContentNotExistsException(Messages.getMLS("undefinedDatasetContent", "\u672a\u5b9a\u4e49\u6570\u636e\u96c6\u5185\u5bb9"));
        }
        OutputColumns ocs = (OutputColumns)outputs.get(0);
        for (int m = 0; m < ocs.size(); ++m) {
            OutputColumn column = (OutputColumn)ocs.get(m);
            String fcaption = CtrlReportUtil.getObjectString(column.getAlias());
            String ffieldname = CtrlReportUtil.getObjectString(column.getName());
            DataType dataType = column.getDataType();
            String type = String.valueOf(CtrlReportUtil.toExtColumnType(dataType));
            HashMap<String, String> mapRet = new HashMap<String, String>();
            mapRet.put("FCaption", fcaption);
            mapRet.put("FFieldName", ffieldname);
            mapRet.put("FFieldType", type);
            lstRet.add(mapRet);
        }
        return lstRet;
    }

    @Override
    public ResultSet getDbSourceListBySystemID(String systemID) throws Exception {
        RptParams params = new RptParams();
        ArrayList<String> queryValue = new ArrayList<String>();
        ISQLDesignerProxy sqlDesignerProxy = ProxyFactory.createSQLDesignerProxy(this.ctx);
        String strSQL = "SELECT D.FID, D.FGROUPID, G.FNAME AS FGROUPNAME, D.FTYPE, D.FNAME AS FNAME,  D.FCREATORID, D.FMODIFYDATE FROM T_QING_DATASET_INFO D LEFT JOIN T_QING_EXTRPT_GROUP G ON G.FID = D.FGROUPID WHERE D.FGROUPID = ? AND (D.FCREATORID = ? OR D.FCREATORID = ?) ORDER BY D.FMODIFYDATE DESC";
        queryValue.add(systemID);
        queryValue.add(sqlDesignerProxy.getContext().getUserID());
        queryValue.add("100000");
        params.setString("MethodName", "getDBInfoBySQL");
        params.setString("sql", strSQL);
        params.setObject("lstValue", queryValue);
        RptParams psR = ReportFacadeFactory.getRemoteInstance().commonExecute(this.ctx, params);
        return (ResultSet)psR.getObject("object");
    }

    @Override
    public void setReportDBModel(List list) {
        this.reportDBModel = list;
    }

    @Override
    public Map getParamInfo() throws Exception {
        return this.mapParam;
    }

    @Override
    public void setParamInfo(Map paramMap) throws Exception {
        this.mapParam = paramMap;
    }

    public void setDatasetParent(Window datasetParent) {
        this.datasetParent = datasetParent;
    }
}

