/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.model;

import com.kingdee.bos.datawizard.edd.ctrlreport.bo.KSQLReportBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.datasetfactory.IExtendReport;
import com.kingdee.bos.datawizard.edd.ctrlreport.datasetfactory.SQLReportImpl;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CycleException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.bos.extreport.common.strategy.ExtReportCustomStrategyRegistrar;
import com.kingdee.bos.extreport.common.strategy.ISQLExtendReportStrategy;
import com.kingdee.bos.extreport.utils.CloseUtil;
import com.kingdee.bos.framework.core.util.Messages;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CtrlReportQuery {
    private CtrlReportQuery() {
    }

    private static final ArrayList<Map<String, String>> toLowerCase(List<Map<String, String>> lst) {
        ArrayList<Map<String, String>> lstNew = new ArrayList<Map<String, String>>();
        if (lst != null) {
            for (Map<String, String> map : lst) {
                HashMap<String, String> mapNew = new HashMap<String, String>();
                Set<Map.Entry<String, String>> entrySet = map.entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    mapNew.put(entry.getKey().toLowerCase(), entry.getValue());
                }
                lstNew.add(mapNew);
            }
        }
        return lstNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDbSourceListBySystemID(Object ctx, String strFlag, String groupID) throws Exception {
        IExtendReport report = CtrlReportQuery.getIReportInstance(ctx, strFlag, groupID);
        ResultSet rs = report.getDbSourceListBySystemID(groupID);
        try {
            List<Map<String, Object>> list = ExtDBUtil.setDataToList(rs);
            return list;
        }
        finally {
            CloseUtil.close(rs);
        }
    }

    public static List<Map<String, String>> getDbSourceFieldList(Object ctx, String strFlag, String dbsourceid) throws Exception {
        return CtrlReportQuery.getDbSourceFieldList(ctx, strFlag, dbsourceid, null);
    }

    public static List<Map<String, String>> getDbSourceFieldList(Object ctx, String strFlag, String dbsourceid, String innerXmlContent) throws Exception {
        List<Map<String, String>> lst = null;
        if (innerXmlContent != null) {
            lst = CtrlReportQuery.getDbSrcFieldListFromXml(ctx, innerXmlContent);
        } else {
            IExtendReport report = CtrlReportQuery.getIReportInstance(ctx, strFlag, dbsourceid);
            lst = report.getDbSourceFieldList();
        }
        return CtrlReportQuery.toLowerCase(lst);
    }

    private static List<Map<String, String>> getDbSrcFieldListFromXml(Object ctx, String innerXmlContent) throws CtrlReportException {
        CtrlDesignQueryModel model = null;
        try {
            model = KSQLReportBO.initModelFromXml(ctx, innerXmlContent, null);
        }
        catch (CycleException e) {
            model = new CtrlDesignQueryModel();
        }
        return SQLReportImpl.getSqlReportDbSrcFieldList(model);
    }

    public static IExtendReport getIReportInstance(Object ctx, String strFlag, String dbsourceid) throws Exception {
        IExtendReport report = null;
        if (strFlag.equals("2") || strFlag.equals("9")) {
            ISQLExtendReportStrategy sqlExtendReportStrategy = ExtReportCustomStrategyRegistrar.getStrategy(ISQLExtendReportStrategy.class);
            report = sqlExtendReportStrategy != null ? sqlExtendReportStrategy.createSQLExtendReport(ctx, dbsourceid) : new SQLReportImpl(ctx, dbsourceid);
        } else {
            throw new RuntimeException("TODO " + Messages.getMLS("UnsupportedDataSetType", "\u672a\u652f\u6301\u8be5\u7c7b\u578b\u7684\u6570\u636e\u96c6"));
        }
        return report;
    }
}

