/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.model;

import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.DateTransUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DateUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;

public class DateSettingModel
implements Serializable {
    private String version = "2";
    private DateGranEnum dateGran;
    private DateTypeEnum dateType;
    private String value;

    public DateGranEnum getDateGran() {
        return this.dateGran;
    }

    public void setDateGran(DateGranEnum dateGran) {
        this.dateGran = dateGran;
    }

    public DateTypeEnum getDateType() {
        return this.dateType;
    }

    public void setDateType(DateTypeEnum dateType) {
        this.dateType = dateType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static enum TimeTypeEnum {
        SYS,
        PERM;

    }

    public static enum DateOffsetDayEnum {
        FIRST_DAY,
        LAST_DAY;

    }

    public static enum DateUnitEnum {
        DAY,
        WEEK,
        MONTH,
        SEASON,
        YEAR;

    }

    public static enum DateOffsetPathEnum {
        FRONT,
        BEHIND;

    }

    public static enum DateTypeEnum {
        PERM,
        EXPR,
        RELATIVE;

    }

    public static enum DateGranEnum implements IDateGranResolve
    {
        Y_M_D{

            @Override
            public String resolvePerDate(String value) {
                return value;
            }

            @Override
            public String resolveExprDate(Date exprDate) {
                return CtrlReportUtil.formatDate(exprDate);
            }

            @Override
            public String resolveRelativeDate(String value, Date now) {
                return DateTransUtil.analysisRelDate(value, now);
            }

            @Override
            public String getDatePattern() {
                return "yyyy-MM-dd";
            }
        }
        ,
        Y_M{

            @Override
            public String resolvePerDate(String value) {
                try {
                    Date date = CtrlReportUtil.sdf_yyyy_MM_dd.get().parse(value);
                    return DateUtil.getMonthLastDay(date);
                }
                catch (ParseException e) {
                    return "";
                }
            }

            @Override
            public String resolveExprDate(Date exprDate) {
                return DateUtil.getMonthLastDay(exprDate);
            }

            @Override
            public String resolveRelativeDate(String value, Date now) {
                return DateTransUtil.analysisRelDate(value, now);
            }

            @Override
            public String getDatePattern() {
                return "yyyy-MM";
            }
        }
        ,
        Y_S{

            @Override
            public String resolvePerDate(String value) {
                try {
                    Date date = CtrlReportUtil.sdf_yyyy_MM_dd.get().parse(value);
                    return DateUtil.tuneDateOfQuarter(date, 0, false);
                }
                catch (ParseException e) {
                    return "";
                }
            }

            @Override
            public String resolveExprDate(Date exprDate) {
                return DateUtil.tuneDateOfQuarter(exprDate, 0, false);
            }

            @Override
            public String resolveRelativeDate(String value, Date now) {
                return DateTransUtil.analysisRelDate(value, now);
            }

            @Override
            public String getDatePattern() {
                return "yyyy-'Q'q";
            }
        }
        ,
        Y{

            @Override
            public String resolvePerDate(String value) {
                try {
                    Date date = CtrlReportUtil.sdf_yyyy_MM_dd.get().parse(value);
                    return DateUtil.tuneDateOfyear(date, 0, false);
                }
                catch (ParseException e) {
                    return "";
                }
            }

            @Override
            public String resolveExprDate(Date exprDate) {
                return DateUtil.tuneDateOfyear(exprDate, 0, false);
            }

            @Override
            public String resolveRelativeDate(String value, Date now) {
                return DateTransUtil.analysisRelDate(value, now);
            }

            @Override
            public String getDatePattern() {
                return "yyyy";
            }
        };


        public static DateGranEnum fromPattern(String pattern) {
            if ("yyyy-MM".equals(pattern)) {
                return Y_M;
            }
            if ("yyyy-'Q'q".equals(pattern)) {
                return Y_S;
            }
            if ("yyyy".equals(pattern)) {
                return Y;
            }
            return Y_M_D;
        }
    }

    public static interface IDateGranResolve {
        public String resolvePerDate(String var1);

        public String resolveExprDate(Date var1);

        public String resolveRelativeDate(String var1, Date var2);

        public String getDatePattern();
    }
}

