/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.model;

import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.DateSettingModel;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.ExtStringUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DateUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.extreport.utils.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import java.util.Date;

public class DateTransUtil {
    public static final String DEFAULT_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String Y_M_PATTERN = "yyyy-MM";
    public static final String Y_Q_PATTERN = "yyyy-'Q'q";
    public static final String Y_PATTERN = "yyyy";
    public static final String SEPARATOR = "!@#ORANGE#@!";
    public static final String VER2_PRE = "{\"version\":\"2\"";

    public static DateSettingModel instanceFrom(String value) {
        String originValue = value;
        DateSettingModel model = new DateSettingModel();
        model.setDateGran(DateSettingModel.DateGranEnum.Y_M_D);
        if (value != null && (value.startsWith("getSystemTime()") || value.startsWith("dayBegin") || value.startsWith("dayEnd") || value.startsWith("dateAdd + ") || value.startsWith("dateSub - "))) {
            int length;
            model.setDateType(DateSettingModel.DateTypeEnum.RELATIVE);
            StringBuilder sb = new StringBuilder();
            if (value.startsWith("getSystemTime()")) {
                sb.append((Object)DateSettingModel.DateOffsetPathEnum.FRONT).append(SEPARATOR);
                sb.append("0").append(SEPARATOR);
                sb.append((Object)DateSettingModel.DateUnitEnum.DAY);
            } else if (value.startsWith("dayBegin")) {
                sb.append((Object)DateSettingModel.DateOffsetPathEnum.FRONT).append(SEPARATOR);
                sb.append("0").append(SEPARATOR);
                sb.append((Object)DateSettingModel.DateUnitEnum.MONTH).append(SEPARATOR);
                sb.append((Object)DateSettingModel.DateOffsetDayEnum.FIRST_DAY);
            } else if (value.startsWith("dayEnd")) {
                sb.append((Object)DateSettingModel.DateOffsetPathEnum.FRONT).append(SEPARATOR);
                sb.append("0").append(SEPARATOR);
                sb.append((Object)DateSettingModel.DateUnitEnum.MONTH).append(SEPARATOR);
                sb.append((Object)DateSettingModel.DateOffsetDayEnum.LAST_DAY);
            } else if (value.startsWith("dateAdd + ")) {
                sb.append((Object)DateSettingModel.DateOffsetPathEnum.BEHIND).append(SEPARATOR);
                value = ExtStringUtil.replace(value, "dateAdd + ", "");
                length = value.length();
                sb.append(value, 0, length - 1).append(SEPARATOR);
                sb.append((Object)DateSettingModel.DateUnitEnum.DAY);
            } else if (value.startsWith("dateSub - ")) {
                sb.append((Object)DateSettingModel.DateOffsetPathEnum.FRONT).append(SEPARATOR);
                value = ExtStringUtil.replace(value, "dateSub - ", "");
                length = value.length();
                sb.append(value, 0, length - 1).append(SEPARATOR);
                sb.append((Object)DateSettingModel.DateUnitEnum.DAY);
            }
            String[] valueArr = StringUtils.split((String)originValue, (char)'|');
            if (valueArr.length == 2) {
                sb.append(SEPARATOR).append(valueArr[1]);
            }
            value = sb.toString();
        } else if (value != null && value.startsWith("=")) {
            model.setDateType(DateSettingModel.DateTypeEnum.EXPR);
        } else {
            model.setDateType(DateSettingModel.DateTypeEnum.PERM);
        }
        model.setValue(value);
        return model;
    }

    public static String[] splitValue(String value) {
        if (StringUtil.isEmptyString((String)value)) {
            return new String[0];
        }
        return value.split(SEPARATOR);
    }

    public static String transDate2Str(String json, Object ctx) {
        String ret = "";
        if (DateTransUtil.isVer2(json)) {
            DateSettingModel model = JsonUtil.decodeFromString(json, DateSettingModel.class);
            ret = DateTransUtil.transDate2Str(model, ctx);
        }
        return ret;
    }

    public static DateSettingModel.DateGranEnum getDateGranFromModel(String json) {
        if (DateTransUtil.isVer2(json)) {
            DateSettingModel model = JsonUtil.decodeFromString(json, DateSettingModel.class);
            return model.getDateGran();
        }
        return DateSettingModel.DateGranEnum.Y_M_D;
    }

    public static String transDate2Str(DateSettingModel model, Object ctx) {
        String ret = "";
        DateSettingModel.DateGranEnum dateGran = model.getDateGran();
        String defaultValue = model.getValue();
        switch (model.getDateType()) {
            case PERM: {
                ret = dateGran.resolvePerDate(defaultValue);
                break;
            }
            case EXPR: {
                Date exprDate = RunReportParam.getServerExprDate(ctx, defaultValue);
                if (exprDate == null) break;
                ret = dateGran.resolveExprDate(exprDate);
                break;
            }
            case RELATIVE: {
                Date now = RunReportParam.getServerDate(ctx);
                ret = dateGran.resolveRelativeDate(defaultValue, now);
                break;
            }
        }
        return ret;
    }

    public static String analysisRelDate(String relValue, Date now) {
        String dateValue;
        String timeValue = null;
        String[] splitValue = DateTransUtil.splitValue(relValue);
        if (splitValue.length < 3) {
            throw new IllegalArgumentException("error relative value,please reset it.your value:" + relValue);
        }
        int offset = Integer.parseInt(splitValue[1]);
        DateSettingModel.DateOffsetPathEnum pathEnum = DateSettingModel.DateOffsetPathEnum.valueOf(splitValue[0]);
        if (pathEnum == DateSettingModel.DateOffsetPathEnum.FRONT) {
            offset = -offset;
        }
        boolean hasDayUnit = false;
        boolean isFirst = false;
        if (splitValue.length >= 4) {
            String splitValue3 = splitValue[3];
            if (DateSettingModel.DateOffsetDayEnum.FIRST_DAY.name().equals(splitValue3) || DateSettingModel.DateOffsetDayEnum.LAST_DAY.name().equals(splitValue3)) {
                hasDayUnit = true;
                DateSettingModel.DateOffsetDayEnum dayEnum = DateSettingModel.DateOffsetDayEnum.valueOf(splitValue3);
                if (dayEnum == DateSettingModel.DateOffsetDayEnum.FIRST_DAY) {
                    isFirst = true;
                }
                if (splitValue.length == 5) {
                    timeValue = splitValue[4];
                }
            } else {
                timeValue = splitValue3;
            }
            if (timeValue != null && "getSystemTime()".equals(timeValue)) {
                timeValue = CtrlReportUtil.formatTime(now);
            }
        }
        DateSettingModel.DateUnitEnum unitEnum = DateSettingModel.DateUnitEnum.valueOf(splitValue[2]);
        switch (unitEnum) {
            case WEEK: {
                if (!isFirst) {
                    ++offset;
                }
                dateValue = DateUtil.tuneDateOfWeek(now, offset, isFirst ? 0 : 6);
                break;
            }
            case MONTH: {
                if (hasDayUnit) {
                    dateValue = DateUtil.tuneDateOfMonth(now, offset, isFirst);
                    break;
                }
                dateValue = DateUtil.tuneDateOfMonth(now, offset, false);
                break;
            }
            case SEASON: {
                if (hasDayUnit) {
                    dateValue = DateUtil.tuneDateOfQuarter(now, offset, isFirst);
                    break;
                }
                dateValue = DateUtil.tuneDateOfQuarter(now, offset, false);
                break;
            }
            case YEAR: {
                if (hasDayUnit) {
                    dateValue = DateUtil.tuneDateOfyear(now, offset, isFirst);
                    break;
                }
                dateValue = DateUtil.tuneDateOfyear(now, offset, false);
                break;
            }
            default: {
                dateValue = DateUtil.tuneDate(now, offset);
            }
        }
        if (timeValue != null) {
            return dateValue + " " + timeValue;
        }
        return dateValue;
    }

    public static boolean isVer2(String dateValue) {
        if (StringUtil.isEmptyString((String)dateValue)) {
            return false;
        }
        return dateValue.startsWith(VER2_PRE);
    }
}

