/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.util;

import com.kingdee.bos.datawizard.edd.ctrlreport.bo.KSQLReportBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.exception.ExtMacroException;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroValue;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignDataType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.OQLModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.industry.MacroUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.CommonCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.SortedNamedObjectNodeArray;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ExtRptContentChecker {
    private static Logger logger = Logger.getLogger(ExtRptContentChecker.class);
    private static Pattern SYSTEM_PARAM_PATTERN = Pattern.compile("'@ExtRpt[a-zA-Z]*'");
    private static Pattern MACRO_PARAM_PATTERN = Pattern.compile("[$]{1}[a-zA-Z0-9]{1}[a-zA-Z0-9_]+");

    public static boolean[] needMoreCopy(String sql) {
        boolean[] ret2 = new boolean[]{false, false};
        if (sql != null) {
            Matcher m = SYSTEM_PARAM_PATTERN.matcher(sql);
            while (m.find()) {
                if (!ExtRptContentChecker.checkAndFill(ExtRptContentChecker.addPrefix(m.group()), ret2)) continue;
                return ret2;
            }
        }
        return ret2;
    }

    private static String addPrefix(String source) {
        return source == null ? source : "=" + source;
    }

    private static boolean isUserInteractValue(String value) {
        return value != null && value.startsWith("=") && (value.indexOf("@ExtRptCurrentUserPersonID") != -1 || value.indexOf("@ExtRptCurrentUserPersonName") != -1 || value.indexOf("@ExtRptCurrentUserOrgRange") != -1);
    }

    private static boolean checkAndFill(String formula, boolean[] ret2) {
        if (!ret2[0] && ExtRptContentChecker.isUserInteractValue(formula)) {
            ret2[0] = true;
        }
        if (!ret2[1] && formula != null && formula.startsWith("=") && (formula.indexOf("@ExtRptCurrentOrgUnitID") != -1 || formula.indexOf("@ExtRptCurrentOrgUnitName") != -1)) {
            ret2[1] = true;
        }
        return ret2[0] && ret2[1];
    }

    public static void analysisMacroUsage(Object easCtx, Set<String> names, HashMap<String, DesignParameter> paramMap, CtrlDesignQueryModel model) throws ExtMacroException {
        names.clear();
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        if (commonQuery == null) {
            return;
        }
        ExtRptContentChecker.analysisParamMacroUsage(names, paramMap);
        String customType = CtrlReportUtil.getObjectString(commonQuery.getProperties().get(CtrlDesignUtil.CustomType));
        if (String.valueOf(1).equals(customType)) {
            ExtRptContentChecker.checkAndFill(names, CtrlDesignQueryModel.makeSQL(model));
        } else if (String.valueOf(9).equals(customType)) {
            OQLModel oqlModel = model.getOqlModel();
            ExtRptContentChecker.checkAndFill(names, oqlModel.getContent());
        }
        for (String macroUid : names) {
            ExtMacroValue extMacroValue = MacroUtil.loadFirstFieldMacroValues(easCtx, macroUid, -1);
            StringBuilder currentValue = new StringBuilder();
            List<List<Object>> macroAllColumnValueList = extMacroValue.getAllColumnValues();
            if (macroAllColumnValueList != null && macroAllColumnValueList.size() > 0) {
                int i = 0;
                for (Object value : macroAllColumnValueList.get(0)) {
                    if (i != 0) {
                        currentValue.append("0xx1xx");
                    }
                    ++i;
                    currentValue.append(value);
                }
            }
            DesignParameter dp = new DesignParameter();
            dp.setCurentValue(currentValue.toString());
            dp.setDesignDataType(DesignDataType.TXT);
            dp.setName(macroUid);
            dp.setIgnoreNull(false);
            paramMap.put(macroUid + "_temp_macro_param_suffix", dp);
        }
    }

    public static void analysisLinkParamMacroUsage(Set<String> names, Cell cell) {
        ExtProps ep = cell.getExtProps(false);
        if (ep == null) {
            return;
        }
        SortedExtPropFormulasArray formulaArr = ep.getFormulas(false);
        if (formulaArr == null) {
            return;
        }
        ICalculableProps prop = formulaArr.get(ExtConst.FORMULA_HYPERLINK);
        if (prop == null) {
            return;
        }
        Map tars = ((HyperlinkCalculableProps)prop).getTargets();
        if (tars == null) {
            return;
        }
        ETTargets ett = (ETTargets)tars.get("EXTRPT");
        if (ett == null) {
            return;
        }
        List targets = ett.getTargets();
        if (targets == null) {
            return;
        }
        for (ExtTransitionTarget target : targets) {
            if (target == null) continue;
            Map params = target.getParameters();
            Iterator ite = params.entrySet().iterator();
            while (ite.hasNext()) {
                CommonCalculableProps param = (CommonCalculableProps)ite.next().getValue();
                if (param == null) continue;
                String pValue = param.getFormula(cell.getSheet().getBook().getDeps().getExprContext(), (ICalculable)cell);
                ExtRptContentChecker.checkAndFill(names, pValue);
            }
        }
    }

    public static void analysisParamMacroUsage(Set<String> names, HashMap paramMap) {
        for (Object dp : paramMap.values()) {
            if (!(dp instanceof DesignParameter)) continue;
            ExtRptContentChecker.analysisParamMacroUsage(names, ((DesignParameter)((Object)dp)).getCurentValue());
        }
    }

    public static void analysisParamMacroUsage(Set<String> names, String value) {
        if (value == null) {
            return;
        }
        ExtRptContentChecker.checkAndFill(names, value);
    }

    private static void analysisNameNodeMacroUsage(Set<String> names, SortedNamedObjectNodeArray nodes) {
        if (nodes != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                Object obj = nodes.get(i);
                if (!(obj instanceof NamedObjectNode)) continue;
                ExtRptContentChecker.checkAndFill(names, ((NamedObjectNode)obj).getRefersTo());
            }
        }
    }

    private static void checkAndFill(Set<String> names, String content) {
        if (content == null) {
            return;
        }
        content = content.replaceAll("0xx1xx", "");
        Matcher m = MACRO_PARAM_PATTERN.matcher(content);
        while (m.find()) {
            names.add(m.group().substring(1));
        }
    }

    public static void analysisMacroUsage(Object easCtx, Set<String> names, HashMap paramMap, Book template) throws ExtMacroException {
        int i;
        names.clear();
        ExtRptContentChecker.analysisParamMacroUsage(names, paramMap);
        ExtDataSetManager dsManager = template.getDataSetManager();
        for (i = 0; i < dsManager.size(); ++i) {
            ExtRptContentChecker.checkAndFill(names, ExtRptContentChecker.parseSQL(easCtx, dsManager.getAt(i)));
        }
        ExtRptContentChecker.analysisNameNodeMacroUsage(names, template.getNames());
        for (i = 0; i < template.getSheetCount(); ++i) {
            Sheet sheet = template.getSheet(i);
            ExtRptContentChecker.analysisNameNodeMacroUsage(names, sheet.getNames());
            Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, 1048575, 65535, true, true);
            while (iter.hasNext()) {
                Cell cell = iter.next();
                ExtRptContentChecker.checkAndFill(names, cell.getFormula());
                ExtRptContentChecker.analysisLinkParamMacroUsage(names, cell);
            }
        }
    }

    private static String parseSQL(Object easCtx, ExtDataSet ds) {
        CtrlDesignQueryModel model = ExtRptContentChecker.parseCtrlDesignQueryModel(easCtx, ds);
        if (model != null) {
            return CtrlDesignQueryModel.makeSQL(model);
        }
        return "";
    }

    private static String getDatasetDesc(ExtDataSet ds) {
        return "ExtDataSet{name:" + ds.toString() + ",define:(" + ds.getDefine() + "),type:" + ds.getDataSetType().getDisplayName() + "}";
    }

    private static CtrlDesignQueryModel parseCtrlDesignQueryModel(Object easCtx, ExtDataSet ds) {
        CtrlDesignQueryModel model = null;
        try {
            model = KSQLReportBO.initModel(easCtx, ds, null);
        }
        catch (Exception e) {
            logger.error((Object)("failed to initialize the datasource," + ExtRptContentChecker.getDatasetDesc(ds)), (Throwable)e);
        }
        return model;
    }
}

