/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.util.fi;

import com.kingdee.bos.datawizard.edd.ctrlreport.util.fi.FIParam;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.fi.FIParamDataType;
import com.kingdee.bos.framework.core.util.Messages;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FIParamIO {
    private static Logger logger = Logger.getLogger(FIParamIO.class);

    public static void serialize(List<FIParam> params, Book template) {
        IXmlElement root = XmlUtil.createNode((String)"FIParams");
        for (FIParam p : params) {
            IXmlElement ep = XmlUtil.createNode((String)"FIParam");
            ep.setAttribute("name", p.getName());
            ep.setAttribute("value", p.getValue());
            ep.setAttribute("dataType", String.valueOf((Object)p.getDataType()));
            ep.setAttribute("sheetName", p.getSheetName());
            ep.addCData(p.getDesc());
            root.addChild(ep);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XmlUtil.save((IXmlElement)root, (OutputStream)out);
            template.setUserObject("rpts_report_cosmic_fiParams", (Object)new String(out.toByteArray(), "UTF-8"));
        }
        catch (IOException e) {
            logger.error((Object)"xml output error.", (Throwable)e);
        }
    }

    public static List<FIParam> load(Book template) {
        IXmlElement root;
        String serialString = (String)template.getUserObjectValue("rpts_report_cosmic_fiParams");
        if (StringUtil.isEmptyString((String)serialString)) {
            return FIParamIO.loadDefault();
        }
        try {
            root = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(serialString.getBytes("UTF-8")));
        }
        catch (Throwable e) {
            logger.error((Object)"SAXBuilder build error.", e);
            return FIParamIO.loadDefault();
        }
        ArrayList<FIParam> params = new ArrayList<FIParam>();
        List children = root.searchChildren("FIParam");
        for (Object o : children) {
            if (!(o instanceof IXmlElement)) continue;
            IXmlElement child = (IXmlElement)o;
            params.add(new FIParam().setDataType(FIParamDataType.valueOf(child.getAttribute("dataType"))).setDesc(child.getText()).setName(child.getAttribute("name")).setSheetName(child.getAttribute("sheetName")).setValue(child.getAttribute("value")));
        }
        return params;
    }

    private static List<FIParam> loadDefault() {
        ArrayList<FIParam> params = new ArrayList<FIParam>();
        FIParam param = new FIParam();
        param.setName("org").setValue("").setSheetName("sheet1").setDesc(Messages.getMLS("accountingOrganization", "\u6838\u7b97\u7ec4\u7ec7")).setDataType(FIParamDataType.String);
        params.add(param);
        param = new FIParam();
        param.setName("fy").setValue("0").setSheetName("sheet1").setDesc(Messages.getMLS("fiscalYear", "\u8d22\u5e74")).setDataType(FIParamDataType.Integer);
        params.add(param);
        param = new FIParam();
        param.setName("period").setValue("0").setSheetName("sheet1").setDesc(Messages.getMLS("period", "\u671f\u95f4")).setDataType(FIParamDataType.Integer);
        params.add(param);
        return params;
    }
}

