/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.data;

import com.kingdee.bos.framework.core.util.Messages;

public class DesignDataType {
    public static final int INT_TXT = 0;
    public static final int INT_NUMERICAL = 1;
    public static final int INT_DATE = 2;
    public static final int INT_BOOLEAN = 3;
    public static final int INT_DATETIME = 4;
    public static final int INT_TIME = 5;
    public static final DesignDataType TXT = new DesignDataType(0);
    public static final DesignDataType NUMERICAL = new DesignDataType(1);
    public static final DesignDataType DATE = new DesignDataType(2);
    public static final DesignDataType BOOLEAN = new DesignDataType(3);
    public static final DesignDataType DATETIME = new DesignDataType(4);
    public static final DesignDataType TIME = new DesignDataType(5);
    private int intValue;

    private DesignDataType(int i) {
        this.intValue = i;
    }

    public int intValue() {
        return this.intValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.intValue;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DesignDataType other = (DesignDataType)obj;
        if (this.intValue != other.intValue) {
            return false;
        }
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        switch (this.intValue) {
            case 0: {
                return Messages.getMLS("text", "\u6587\u672c");
            }
            case 1: {
                return Messages.getMLS("number", "\u6570\u503c");
            }
            case 2: {
                return Messages.getMLS("date", "\u65e5\u671f");
            }
            case 3: {
                return Messages.getMLS("boolean", "\u5e03\u5c14");
            }
            case 4: {
                return Messages.getMLS("dateTime", "\u65e5\u671f\u65f6\u95f4");
            }
            case 5: {
                return Messages.getMLS("timeTime", "\u65f6\u95f4");
            }
        }
        return "";
    }

    public static final DesignDataType getDataType(int intValue) {
        switch (intValue) {
            case 0: {
                return TXT;
            }
            case 1: {
                return NUMERICAL;
            }
            case 2: {
                return DATE;
            }
            case 3: {
                return BOOLEAN;
            }
            case 4: {
                return DATETIME;
            }
            case 5: {
                return TIME;
            }
        }
        return null;
    }

    public static final boolean isDateTime(DesignDataType dt) {
        int intValue = dt.intValue;
        switch (intValue) {
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }
}

