/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.model;

import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignCondition;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.ParseFilter;
import com.kingdee.cosmic.ctrl.common.CtrlUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.data.modal.query.Column;
import com.kingdee.cosmic.ctrl.data.modal.query.Condition;
import com.kingdee.cosmic.ctrl.data.modal.query.IColumnList;
import com.kingdee.cosmic.ctrl.data.modal.query.IJoinList;
import com.kingdee.cosmic.ctrl.data.modal.query.IOrderList;
import com.kingdee.cosmic.ctrl.data.modal.query.IQuery;
import com.kingdee.cosmic.ctrl.data.modal.query.ITable;
import com.kingdee.cosmic.ctrl.data.modal.query.ITableList;
import com.kingdee.cosmic.ctrl.data.modal.query.Join;
import com.kingdee.cosmic.ctrl.data.modal.query.Order;
import com.kingdee.cosmic.ctrl.data.modal.query.QueryType;
import com.kingdee.cosmic.ctrl.data.modal.query.Table;
import com.kingdee.cosmic.ctrl.data.modal.query.design.DesignedFilterList;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CtrlDesignSQLMaker {
    public static final String NATIVE_SQL_PREFIX = "/*dialect*/";
    private static final String[] INDENTS = new String[4];
    private static final String UNDEFINED_QUERY_TABLE = "UNDEFINED-QUREY-TABLE:";
    public static final Pattern MC_AS;
    public static final Pattern QT_MF;

    public static String makeQuery(IQuery qry) {
        return CtrlDesignSQLMaker.makeQuery(qry, null);
    }

    public static String makeQuery(IQuery qry, String[] fields) {
        if (qry.getQueryType() == QueryType.SQL_CUSTOM) {
            return qry.getContent();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT");
        if (qry.isDistinct()) {
            sql.append(" DISTINCT");
        }
        if (fields == null) {
            sql.append(CtrlDesignSQLMaker.makeSelect(qry.getColumns()));
        } else {
            sql.append(CtrlDesignSQLMaker.makeSelect(fields));
        }
        sql.append("\r\nFROM");
        sql.append(CtrlDesignSQLMaker.makeFrom(qry.getTables(), qry.getJoins()));
        String s = CtrlDesignSQLMaker.makeWhere(qry.getFilter());
        if (!StringUtil.isEmptyString((String)s)) {
            sql.append("\r\nWHERE ");
            sql.append(s);
        }
        if (!StringUtil.isEmptyString((String)(s = CtrlDesignSQLMaker.makeOrderBy(qry.getOrders())))) {
            sql.append("\r\nORDER BY");
            sql.append(s);
        }
        return sql.toString();
    }

    public static String makeSelect(String[] fields) {
        return fields == null || fields.length == 0 ? "\r\n *" : CtrlUtil.Array.objectArray2String((Object[])fields, (String)",\r\n");
    }

    public static String makeSelect(IColumnList cols) {
        int z = cols.size();
        if (z == 0) {
            return "\r\n *";
        }
        StringBuilder select = new StringBuilder();
        for (int i = 0; i < z; ++i) {
            if (i > 0) {
                select.append(",");
            }
            select.append("\r\n ");
            select.append(CtrlDesignSQLMaker.makeSelectColumn((Column)cols.get(i)));
        }
        return select.toString();
    }

    public static String makeSelectColumn(Column col) {
        StringBuilder sb = new StringBuilder();
        sb.append(col.getExpr());
        sb.append(" AS \"");
        sb.append(col.getName());
        sb.append("\"");
        return sb.toString();
    }

    public static String makeFrom(ITableList tbls, IJoinList joins) {
        JoinsParser jem = new JoinsParser(joins);
        List nodes = jem.getTopestNodes();
        StringBuilder sb = new StringBuilder();
        int tabCount = tbls.size();
        for (int i = 0; i < tabCount; ++i) {
            ITable tbl = (ITable)tbls.get(i);
            if (-1 != jem.findTopestNode(tbl.getName())) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("\r\n ");
            sb.append(CtrlDesignSQLMaker.makeFromTable(tbl));
        }
        int joinCount = nodes.size();
        for (int i = 0; i < joinCount; ++i) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("\r\n ");
            JoinNode joinExt = (JoinNode)nodes.get(i);
            sb.append(CtrlDesignSQLMaker.makeJoinNode(joinExt, tbls, 0));
        }
        return sb.toString();
    }

    public static String makeFromTable(ITable tbl) {
        StringBuilder content = new StringBuilder();
        if (tbl instanceof Table) {
            content.append("[");
            content.append(tbl.getExpr());
            content.append("]");
        } else if (tbl instanceof IQuery) {
            content.append("(");
            content.append(((IQuery)tbl).getContent());
            content.append(")");
        }
        content.append(" AS \"");
        content.append(tbl.getName());
        content.append("\"");
        return content.toString();
    }

    public static String makeFromTable(ITableList tbls, String tblName) {
        ITable tbl = (ITable)tbls.get(tblName);
        if (tbl == null) {
            return UNDEFINED_QUERY_TABLE + tblName;
        }
        return CtrlDesignSQLMaker.makeFromTable(tbl);
    }

    public static String makeJoinNode(JoinNode node, ITableList tbls, int nest) {
        ArrayList joins = node.getJoins();
        Join join = (Join)joins.get(0);
        String[] s2 = new String[2];
        for (int i = 0; i < 2; ++i) {
            JoinNode jn;
            JoinNode joinNode = jn = i == 0 ? node.getLeft() : node.getRight();
            s2[i] = jn == null ? CtrlDesignSQLMaker.makeFromTable(tbls, i == 0 ? join.getLeftTable() : join.getRightTable()) : "(" + CtrlDesignSQLMaker.makeJoinNode(jn, tbls, nest + 1) + ")\r\n";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(s2[0]);
        sb.append(" ");
        sb.append(join.getJoinType().getName().toUpperCase());
        sb.append(" JOIN ");
        sb.append(s2[1]);
        sb.append(" ON ");
        int z = joins.size();
        for (int i = 0; i < z; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            join = (Join)joins.get(i);
            sb.append("(");
            sb.append(join.getCondition().getExpr());
            sb.append(")");
        }
        return sb.toString();
    }

    public static String makeWhere(Condition cnd) {
        if (cnd == null) {
            return null;
        }
        CtrlDesignCondition cdcnd = (CtrlDesignCondition)cnd;
        if (null != cdcnd.getDynamicExpr()) {
            String de = cdcnd.getDynamicExpr();
            cdcnd.setDynamicExpr(null);
            return de;
        }
        String whereString = ParseFilter.getWhereString((DesignedFilterList)cdcnd.getExtObj());
        return whereString;
    }

    public static String makeOrderBy(IOrderList ords) {
        int z = ords.size();
        if (z == 0) {
            return null;
        }
        StringBuilder select = new StringBuilder();
        for (int i = 0; i < z; ++i) {
            if (i > 0) {
                select.append(", ");
            }
            select.append("\r\n ");
            select.append(CtrlDesignSQLMaker.makeOrderColumn((Order)ords.get(i)));
        }
        return select.toString();
    }

    public static String makeOrderColumn(Order ord) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(ord.getExpr());
        sb.append("\"");
        sb.append(ord.isAscending() ? " ASC" : " DESC");
        return sb.toString();
    }

    public String buildSQL(IQuery qry) {
        return null;
    }

    public String buildSQLNew(IQuery qry) {
        return this.buildSQL(qry, null);
    }

    private String wrapFields(String sql, String[] fields) {
        boolean nativeSql;
        if (fields == null) {
            return sql;
        }
        boolean bl = nativeSql = sql != null && sql.startsWith(NATIVE_SQL_PREFIX);
        String sql2 = sql == null ? "" : sql.substring(nativeSql ? NATIVE_SQL_PREFIX.length() : 0).trim();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(CtrlUtil.Array.objectArray2String((Object[])fields, (String)",")).append(" FROM (").append(sql2).append(") AS ").append("T").append(System.currentTimeMillis());
        if (nativeSql) {
            sb.insert(0, NATIVE_SQL_PREFIX);
        }
        return sb.toString();
    }

    public String buildSQL(IQuery qry, String[] fields) {
        String sql;
        if (QueryType.SQL_WIZARD.equals(qry.getQueryType())) {
            sql = CtrlDesignSQLMaker.makeQuery(qry, fields);
        } else {
            sql = qry.getContent();
            ((CtrlDesignKsqlQuery)qry).setDynamicContent(null);
            if (sql != null && sql.startsWith(NATIVE_SQL_PREFIX)) {
                return this.wrapFields(sql, fields);
            }
        }
        if (sql != null) {
            sql = this.replaceMeta(sql, qry);
        }
        if (!QueryType.SQL_WIZARD.equals(qry.getQueryType())) {
            sql = this.wrapFields(sql, fields);
        }
        return sql;
    }

    private String replaceMeta(String qryExpr, IQuery qry) {
        ITableList tbls = qry.getTables();
        Matcher mch = QT_MF.matcher(qryExpr);
        StringBuilder sb1 = new StringBuilder();
        int j = 0;
        while (mch.find()) {
            int i = mch.start();
            sb1.append(qryExpr.substring(j, i));
            j = mch.end();
            sb1.append(this.replaceQtMf(qryExpr.substring(i, j), tbls));
        }
        sb1.append(qryExpr.substring(j));
        mch = MC_AS.matcher(sb1);
        StringBuilder sb2 = new StringBuilder();
        j = 0;
        sb2.append(sb1.substring(j));
        return sb2.toString();
    }

    private String replaceQtMf(String qtmf, ITableList tbls) {
        int i = qtmf.indexOf("].[");
        String qtName = qtmf.substring(1, i);
        String mfName = qtmf.substring(i + 3, qtmf.length() - 1);
        ITable tbl = (ITable)tbls.get(qtName);
        if (!(tbl instanceof Table) && !(tbl instanceof IQuery)) {
            qtName = UNDEFINED_QUERY_TABLE + qtName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(qtName);
        sb.append("\".");
        sb.append(mfName);
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(CtrlDesignSQLMaker.makeSelect((String[])null));
    }

    static {
        CtrlDesignSQLMaker.INDENTS[0] = "";
        CtrlDesignSQLMaker.INDENTS[1] = " ";
        CtrlDesignSQLMaker.INDENTS[2] = "  ";
        CtrlDesignSQLMaker.INDENTS[3] = "   ";
        MC_AS = Pattern.compile("[^\\.]\\[[^\\[\\]]*\\]\\ AS ", 32);
        QT_MF = Pattern.compile("\\[[^\\[\\]]*\\]\\.\\[[^\\[\\]]*\\]", 32);
    }

    private static class JoinsParser {
        private ArrayList topestNodes;

        public JoinsParser(IJoinList joins) {
            this.parse(joins);
        }

        public List getTopestNodes() {
            return this.topestNodes;
        }

        private void parse(IJoinList joins) {
            this.topestNodes = new ArrayList();
            int z = joins.size();
            for (int i = 0; i < z; ++i) {
                JoinNode rightNode;
                Join join = (Join)joins.get(i);
                int left = this.findTopestNode(join.getLeftTable());
                int right = this.findTopestNode(join.getRightTable());
                if (left == -1) {
                    if (right == -1) {
                        this.topestNodes.add(new JoinNode(join));
                        continue;
                    }
                    JoinNode rightExt = (JoinNode)this.topestNodes.get(right);
                    this.topestNodes.set(right, new JoinNode(join, null, rightExt));
                    continue;
                }
                if (right == -1) {
                    JoinNode leftExt = (JoinNode)this.topestNodes.get(left);
                    this.topestNodes.set(left, new JoinNode(join, leftExt, null));
                    continue;
                }
                JoinNode leftNode = (JoinNode)this.topestNodes.get(left);
                if (leftNode == (rightNode = (JoinNode)this.topestNodes.get(right))) {
                    JoinNode node = this.findLowestNode(leftNode, join);
                    node.addJoin(join);
                    continue;
                }
                if (left > right) {
                    int tmp = left;
                    left = right;
                    right = tmp;
                }
                this.topestNodes.set(left, new JoinNode(join, leftNode, rightNode));
                this.topestNodes.remove(right);
            }
        }

        private int findTopestNode(String tblName) {
            for (int i = 0; i < this.topestNodes.size(); ++i) {
                JoinNode joinExt = (JoinNode)this.topestNodes.get(i);
                if (!joinExt.containsTable(tblName)) continue;
                return i;
            }
            return -1;
        }

        private JoinNode findLowestNode(JoinNode startNode, Join join) {
            for (int i = 0; i < 2; ++i) {
                JoinNode node;
                JoinNode joinNode = node = i == 0 ? startNode.getLeft() : startNode.getRight();
                if (node == null || !node.containsTables(join)) continue;
                return this.findLowestNode(node, join);
            }
            return startNode;
        }
    }

    private static class JoinNode {
        private ArrayList tables = new ArrayList();
        private ArrayList joins = new ArrayList();
        private JoinNode left;
        private JoinNode right;

        public JoinNode(Join join) {
            this.joins.add(join);
            this.tables.add(join.getLeftTable());
            this.tables.add(join.getRightTable());
        }

        public JoinNode(Join join, JoinNode left, JoinNode right) {
            this(join);
            if (left != null) {
                this.left = left;
                this.tables.addAll(left.getTables());
            }
            if (right != null) {
                this.right = right;
                this.tables.addAll(right.getTables());
            }
        }

        public void addJoin(Join join) {
            this.joins.add(join);
        }

        public ArrayList getJoins() {
            return this.joins;
        }

        public ArrayList getTables() {
            return this.tables;
        }

        public boolean containsTable(String name) {
            return this.tables.contains(name);
        }

        public boolean containsTables(Join join) {
            return this.tables.contains(join.getLeftTable()) && this.tables.contains(join.getRightTable());
        }

        public JoinNode getLeft() {
            return this.left;
        }

        public JoinNode getRight() {
            return this.right;
        }
    }
}

