/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.model;

import com.kingdee.bos.boslayer.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.ExtStringUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignDataType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InputType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.JavaModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.OQLModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.ProcedureModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CycleException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignCondition;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.pr.ParamRelationDesignModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.xml.DesignParameterIO;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.xml.JavaParameterIO;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.xml.OQLModelIO;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.xml.ProcedureParameterIO;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.DataType;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.data.modal.CommonQuery;
import com.kingdee.cosmic.ctrl.data.modal.DataDef;
import com.kingdee.cosmic.ctrl.data.modal.IDefObj;
import com.kingdee.cosmic.ctrl.data.modal.Outputs;
import com.kingdee.cosmic.ctrl.data.modal.io.CommonQuery2Xml;
import com.kingdee.cosmic.ctrl.data.modal.io.DataDef2Xml;
import com.kingdee.cosmic.ctrl.data.modal.io.Ext2Xml;
import com.kingdee.cosmic.ctrl.data.modal.io.IObj2Xml;
import com.kingdee.cosmic.ctrl.data.modal.io.IXml2Obj;
import com.kingdee.cosmic.ctrl.data.modal.io.QueryExt2Xml;
import com.kingdee.cosmic.ctrl.data.modal.io.Xml2DataDef;
import com.kingdee.cosmic.ctrl.data.modal.io.Xml2Def;
import com.kingdee.cosmic.ctrl.data.modal.io.Xml2Ext;
import com.kingdee.cosmic.ctrl.data.modal.io.Xml2QueryExt;
import com.kingdee.cosmic.ctrl.data.modal.query.Condition;
import com.kingdee.cosmic.ctrl.data.modal.query.IQuery;
import com.kingdee.cosmic.ctrl.data.modal.query.QueryType;
import com.kingdee.cosmic.ctrl.data.modal.query.io.Query2Xml;
import com.kingdee.cosmic.ctrl.data.modal.query.io.Xml2Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CtrlDesignUtil {
    public static final String split_dot = "\\.";
    public static final String FILTER_FIELDS = "fields";
    public static final String FILTER_FIELD = "field";
    private static final String A_goodOutput = "goodOutput";
    private static final String A_outDB = "OutDB";
    public static String VERSION = "version";
    public static String CustomType = "SQLCustomType";
    public static String isDynamicField = "isDynamicField";
    public static IBriefViewTreeNode root = null;
    public static final DesignDataType[] DATA_TYPES = new DesignDataType[]{DesignDataType.TXT, DesignDataType.NUMERICAL, DesignDataType.DATE, DesignDataType.DATETIME, DesignDataType.TIME, DesignDataType.BOOLEAN};
    public static final DataType[] PARAM_TYPES = new DataType[]{DataType.STRING, DataType.DATETIME, DataType.DECIMAL, DataType.INTEGER};
    public static final List<String> calcStrs = new ArrayList<String>(Arrays.asList("=", ">", "<", ">=", "<=", "<>", "!="));

    public static final String getDesignTableType(String str) {
        String strRet = null;
        if (CtrlReportUtil.getObjectString(str).length() != 0) {
            String[] arr = str.split(split_dot);
            strRet = arr[arr.length - 1];
        }
        return strRet;
    }

    public static final String getDataSetTypeName(String str) {
        if ("9".equals(str)) {
            return "sql_oql";
        }
        return "sql_ksql";
    }

    public static final String getDesignTableExp(String str) {
        String strRet = null;
        if (CtrlReportUtil.getObjectString(str).length() != 0) {
            StringBuilder sb = new StringBuilder();
            String[] arr = str.split(split_dot);
            for (int i = 0; i < arr.length - 1; ++i) {
                sb.append(arr[i]).append(".");
            }
            if (sb.length() > 0) {
                strRet = sb.substring(0, sb.length() - 1);
            }
        }
        return strRet;
    }

    public static final String toFilterSolutionXml(List<Map<String, String>> paramList) {
        IXmlElement e = XmlUtil.createNode((String)FILTER_FIELDS);
        e.setAttribute(VERSION, "2");
        for (HashMap hashMap : paramList) {
            String paramName = (String)hashMap.get("name");
            String paramValue = CtrlReportUtil.getObjectString(hashMap.get("value"));
            String paramValueAlias = CtrlReportUtil.getObjectString(hashMap.get("valueAlias"));
            String paramType = (String)hashMap.get("dataType");
            IXmlElement et = XmlUtil.createNode((String)FILTER_FIELD);
            et.setAttribute("dataType", paramType);
            et.setAttribute("name", paramName);
            et.setAttribute("value", paramValue);
            et.setAttribute("valueAlias", paramValueAlias);
            e.addChild(et);
        }
        String xmlstr = XmlUtil.toString((IXmlElement)e);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\r\n").append(xmlstr);
        return stringBuilder.toString();
    }

    public static final String toFilterSolutionXml(Map mapDesignParam) {
        IXmlElement e = XmlUtil.createNode((String)FILTER_FIELDS);
        e.setAttribute(VERSION, "2");
        Set entrySet = mapDesignParam.entrySet();
        for (Map.Entry entry : entrySet) {
            DesignParameter p = (DesignParameter)((Object)entry.getValue());
            String paramName = p.getName();
            String paramValue = CtrlReportUtil.getObjectString(p.getCurentValue());
            String paramValueAlias = CtrlReportUtil.getObjectString(p.getCurentValueAlias());
            String paramType = String.valueOf(p.getDesignDataType().intValue());
            IXmlElement et = XmlUtil.createNode((String)FILTER_FIELD);
            et.setAttribute("dataType", paramType);
            et.setAttribute("name", paramName);
            et.setAttribute("value", paramValue);
            et.setAttribute("valueAlias", paramValueAlias);
            e.addChild(et);
        }
        String xmlstr = XmlUtil.toString((IXmlElement)e);
        StringBuilder strRet = new StringBuilder();
        strRet.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\r\n").append(xmlstr);
        return strRet.toString();
    }

    public static final String toFilterSolutionXmlByDesignParameter(List paramList) {
        if (null == paramList || paramList.isEmpty()) {
            return null;
        }
        IXmlElement e = XmlUtil.createNode((String)FILTER_FIELDS);
        e.setAttribute(VERSION, "2");
        for (DesignParameter p : paramList) {
            String paramName = p.getName();
            String curValue = p.getCurentValue();
            String paramValue = StringUtil.isEmptyString((String)curValue) ? p.getDefaultValue() : curValue;
            InputType inputType = p.getInputType();
            paramValue = CtrlReportUtil.getObjectString(paramValue);
            String paramValueAlias = p.getCurentValueAlias();
            if (StringUtil.isEmptyString((String)paramValueAlias)) {
                paramValueAlias = paramValue;
            }
            paramValueAlias = CtrlReportUtil.getObjectString(paramValueAlias);
            if (inputType != null && inputType.equals(InputType.INPUT)) {
                if (!StringUtil.isEmptyString((String)paramValueAlias)) {
                    paramValueAlias = ExtStringUtil.replace(paramValueAlias, ";", "0xx1xx");
                }
                if (!StringUtil.isEmptyString((String)paramValue)) {
                    paramValue = ExtStringUtil.replace(paramValue, ";", "0xx1xx");
                }
            }
            String paramType = String.valueOf(p.getDesignDataType().intValue());
            IXmlElement et = XmlUtil.createNode((String)FILTER_FIELD);
            et.setAttribute("dataType", paramType);
            et.setAttribute("name", paramName);
            et.setAttribute("value", paramValue);
            et.setAttribute("valueAlias", paramValueAlias);
            e.addChild(et);
        }
        String xmlstr = XmlUtil.toString((IXmlElement)e);
        StringBuilder strRet = new StringBuilder();
        strRet.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\r\n").append(xmlstr);
        return strRet.toString();
    }

    public static IXmlElement toXml(Object context, CtrlDesignCommonQuery commonQuery, IQuery query) {
        IXmlElement ele;
        IXmlElement e = XmlUtil.createNode((String)"CommonQuery");
        CtrlDesignUtil.toXml(e, commonQuery);
        IXmlElement query_e = Query2Xml.toXml((IQuery)query);
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)query;
        query_e.setAttribute(A_goodOutput, ksqlQuery.getGoodOutput());
        String outDB = ksqlQuery.getOutDB();
        if (null == outDB) {
            outDB = "";
        }
        query_e.setAttribute(A_outDB, outDB);
        e.addChild(query_e);
        QueryExt2Xml obj2xml = new QueryExt2Xml();
        Ext2Xml ext2xml = new Ext2Xml((IObj2Xml)obj2xml);
        CommonQuery2Xml.makeCommonQueryExt((CommonQuery)commonQuery, (IXmlElement)e, (Ext2Xml)ext2xml);
        e.addChild(ext2xml.getXML());
        ParamRelationDesignModel model = null;
        try {
            model = commonQuery.getParamRelationDesignModel(context, null);
        }
        catch (CycleException cycleException) {
            // empty catch block
        }
        if (model != null && (ele = model.save()) != null) {
            e.addChild(ele);
        }
        return e;
    }

    private static final void toXml(IXmlElement e, CtrlDesignCommonQuery obj) {
        OQLModel oqlModel;
        JavaModel jm;
        ProcedureModel pm;
        Outputs outputs;
        if (obj == null) {
            return;
        }
        CtrlDesignUtil.makeCommonQueryMulLang(e, (DataDef)obj);
        List ps = obj.getParameters();
        if (ps != null && ps.size() > 0) {
            e.addChild(DesignParameterIO.makeParameters(ps));
        }
        if ((outputs = obj.getOutputs()) != null && outputs.size() > 0) {
            e.addChild(DataDef2Xml.Outputs2Xml.toXml((Outputs)outputs));
        }
        if ((pm = obj.getProcedureModel()) != null) {
            e.addChild(ProcedureParameterIO.makeProcedure(pm));
        }
        if ((jm = obj.getJavaModel()) != null) {
            e.addChild(JavaParameterIO.makeJava(jm));
        }
        if ((oqlModel = obj.getOqlModel()) != null) {
            e.addChild(OQLModelIO.makeOQL(oqlModel));
        }
    }

    private static void makeCommonQueryMulLang(IXmlElement xmlObj, DataDef obj) {
        Map ps = obj.getProperties();
        for (Map.Entry att : ps.entrySet()) {
            String attName = (String)att.getKey();
            String attVal = null;
            Object value = att.getValue();
            if (value instanceof String) {
                attVal = value.toString();
            }
            if (attVal == null) continue;
            if (attName.equals("l1")) {
                attName = "alias.en";
            } else if (attName.equals("l2")) {
                attName = "alias.zh_CN";
            } else if (attName.equals("l3")) {
                attName = "alias.zh_TW";
            }
            xmlObj.setAttribute(attName, attVal);
        }
    }

    public static final void toObject(Object context, CtrlDesignQueryModel model, IXmlElement e, Set<String> circularDependencySet) throws CycleException {
        CtrlDesignCommonQuery commonQuery = new CtrlDesignCommonQuery();
        CtrlDesignUtil.toObject(commonQuery, e);
        model.setCommonQuery(commonQuery);
        RunReportParam.upgradeParam(model);
        IXmlElement child = e.getChild("Query");
        model.setQuery(child == null ? null : CtrlDesignUtil.parseToQuery(child));
        Xml2QueryExt xml2obj = new Xml2QueryExt();
        Xml2Ext xml2ext = new Xml2Ext((IXml2Obj)xml2obj);
        xml2ext.parseXML(e.getChild("EXT"));
        Xml2Query.parseQueryExt((IQuery)model.getQuery(), (IXmlElement)child, (Xml2Ext)xml2ext);
        String whereExpr = CtrlReportUtil.getObjectString(model.getQuery().getFilter().getExpr());
        CtrlDesignCondition con = new CtrlDesignCondition(whereExpr);
        con.setExtObj(model.getQuery().getFilter().getExtObj());
        model.getQuery().setFilter((Condition)con);
        IXmlElement root = e.getChild("ParamRelationRoot");
        if (root != null) {
            ParamRelationDesignModel prm = new ParamRelationDesignModel();
            prm.load(root);
            commonQuery.setParamRelationDesignModel(context, prm, circularDependencySet);
        } else {
            commonQuery.setParamRelationDesignModel(context, null, circularDependencySet);
        }
    }

    private static final IQuery parseToQuery(IXmlElement e) {
        IXmlElement child;
        CtrlDesignKsqlQuery obj = null;
        QueryType qt = QueryType.fromName((String)e.getAttribute("type"));
        obj = new CtrlDesignKsqlQuery(qt == QueryType.SQL_WIZARD);
        Xml2Def.parseDefObj((IDefObj)obj, (IXmlElement)e);
        String s = e.getAttribute("distinct");
        if (s != null) {
            obj.setDistinct(Boolean.parseBoolean(s));
        }
        if ((child = e.getChild("Tables")) != null && obj.getTables() != null) {
            obj.getTables().addAll((Collection)Xml2Query.parseTables((IXmlElement)child));
        }
        if ((child = e.getChild("Joins")) != null && obj.getJoins() != null) {
            obj.getJoins().addAll((Collection)Xml2Query.parseJoins((IXmlElement)child));
        }
        if ((child = e.getChild("Columns")) != null) {
            obj.getColumns().addAll((Collection)Xml2Query.parseColumns((IXmlElement)child));
        }
        if ((child = e.getChild("Orders")) != null && obj.getOrders() != null) {
            obj.getOrders().addAll((Collection)Xml2Query.parseOrders((IXmlElement)child));
        }
        if ((child = e.getChild("Filter")) != null) {
            obj.setFilter(Xml2Query.parseCondition((IXmlElement)child));
        }
        if ((child = e.getChild("Content")) != null) {
            obj.setContent(Xml2Query.parseContent((IXmlElement)child));
        }
        CtrlDesignKsqlQuery ksqlQuery = obj;
        String goodOutput = "true";
        if (null != e.getAttribute(A_goodOutput)) {
            goodOutput = e.getAttribute(A_goodOutput);
        }
        ksqlQuery.setGoodOutput(goodOutput);
        String outDB = CtrlDesignUtil.getOutDB(e);
        ksqlQuery.setOutDB(outDB);
        return obj;
    }

    private static final void toObject(CtrlDesignCommonQuery obj, IXmlElement e) {
        CtrlDesignUtil.makeXmlToCommonQuery(e, (DataDef)obj);
        IXmlElement child = e.getChild("Parameters");
        obj.setParameters(child == null ? new ArrayList() : DesignParameterIO.parseParameters(child));
        child = e.getChild("Outputs");
        obj.setOutputs(child == null ? null : Xml2DataDef.Xml2Outputs.toObject((IXmlElement)child));
        child = e.getChild("Procedure");
        obj.setProcedureModel(child == null ? new ProcedureModel() : ProcedureParameterIO.getProcedureModel(child));
        child = e.getChild("Java");
        obj.setJavaModel(child == null ? new JavaModel() : JavaParameterIO.getJavaModel(child));
        child = e.getChild("OQL");
        obj.setOqlModel(child == null ? new OQLModel() : OQLModelIO.getOQLModel(child));
    }

    private static void makeXmlToCommonQuery(IXmlElement xmlObj, DataDef obj) {
        Map ps = obj.getProperties();
        ps.put("alias.en", CtrlReportUtil.getObjectString(xmlObj.getAttribute("alias.en")));
        ps.put("alias.zh_CN", CtrlReportUtil.getObjectString(xmlObj.getAttribute("alias.zh_CN")));
        ps.put("alias.zh_TW", CtrlReportUtil.getObjectString(xmlObj.getAttribute("alias.zh_TW")));
        String version = "";
        if (null != xmlObj.getAttribute(VERSION)) {
            version = xmlObj.getAttribute(VERSION);
        }
        ps.put(VERSION, version);
        String ct = String.valueOf(1);
        if (null != xmlObj.getAttribute(CustomType)) {
            ct = xmlObj.getAttribute(CustomType);
        }
        ps.put(CustomType, ct);
        String dynamicField = "false";
        if (null != xmlObj.getAttribute(isDynamicField)) {
            dynamicField = xmlObj.getAttribute(isDynamicField);
        }
        ps.put(isDynamicField, dynamicField);
    }

    public static final String getOutDB(IXmlElement e) {
        String outDB = "";
        if (null != e.getAttribute(A_outDB)) {
            outDB = e.getAttribute(A_outDB);
            return outDB;
        }
        IXmlElement child = e.getChild("Query");
        if (child != null) {
            return CtrlDesignUtil.getOutDB(child);
        }
        return outDB;
    }

    public static String getCalcStr(String sql) {
        char[] chars = sql.toCharArray();
        String result = null;
        String temp = "";
        for (int i = 0; i < chars.length; ++i) {
            if (calcStrs.contains(temp = temp + chars[i])) {
                result = temp;
                continue;
            }
            temp = "";
        }
        return result;
    }

    public static String[] splitByCalcStr(String sql, String calcStr) {
        String[] arr = new String[3];
        if (calcStr != null) {
            String[] split = sql.split(calcStr);
            if (split.length < 2) {
                throw new RuntimeException("analysis ksql error, please check Ksql");
            }
            arr[0] = split[0].trim();
            arr[1] = calcStr;
            arr[2] = split[1].trim();
        } else {
            arr = sql.split(" ");
            if (arr.length < 3) {
                throw new RuntimeException("analysis ksql error, please check Ksql");
            }
        }
        return arr;
    }

    public static String filterToDateStr(String filterValue) {
        String match;
        int index;
        String regex;
        Pattern pattern;
        Matcher matcher;
        int start = filterValue.indexOf("TO_DATE(");
        if (start != -1) {
            int count = CtrlDesignUtil.countClosingParentheses(filterValue);
            String str = filterValue.substring(start + "TO_DATE(".length());
            int end = str.indexOf(44);
            StringBuilder result = new StringBuilder();
            result.append(str, 0, end);
            for (int i = 0; i < count; ++i) {
                result.append(')');
            }
            filterValue = result.toString().trim();
        }
        if ((matcher = (pattern = Pattern.compile(regex = "(\\d{2}:\\d{2}:\\d{2})")).matcher(filterValue)).find() && (index = filterValue.indexOf(match = matcher.group(1))) != -1) {
            filterValue = "'" + filterValue.substring(index);
        }
        return filterValue;
    }

    public static int countClosingParentheses(String str) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '(') {
                --count;
                continue;
            }
            if (c != ')') continue;
            ++count;
        }
        return count;
    }
}

