/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.boslayer.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.boslayer.eas.framework.report.util.RptParams;
import com.kingdee.bos.corelayer.proxy.ISQLDesignerProxy;
import com.kingdee.bos.corelayer.proxy.ProxyFactory;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.KSQLReportBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.datasetfactory.IExtendReport;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroValue;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.DateTransUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.ExtBizData;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.ExtStringUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignDataType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InputType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CycleException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataSetContentNotExistsException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataSetNotPresetPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.InvalidParamInputException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.industry.InnerParam;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.industry.InnerParamUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.industry.MacroUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DataSetDefineModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DateUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DefDbsourceModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.SqlDSModelDrill;
import com.kingdee.bos.datawizard.edd.tobi.util.ExtFilterParamUtil;
import com.kingdee.bos.datawizard.edd.web.filter.ReportParamDescription;
import com.kingdee.bos.datawizard.edd.web.vo.Entry;
import com.kingdee.bos.extreport.utils.CloseUtil;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.bos.extreport.utils.XMLUtil;
import com.kingdee.bos.framework.core.util.Messages;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.cosmic.ctrl.common.macro.MacroFormatUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.data.modal.DefObj;
import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.Format;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RunReportParam {
    private static final Logger logger = Logger.getLogger(RunReportParam.class);
    public static final String Slash = "\\";
    public static final String entityfieldname = "entityfieldname";
    public static final String enetitytype = "enetitytype";

    public static void isValidInput(DesignParameter parameter, String value) throws InvalidParamInputException {
        InputType inputType = parameter.getInputType();
        DesignDataType dataType = parameter.getDesignDataType();
        value = CtrlReportUtil.getObjectString(value);
        if (inputType.equals(InputType.LABEL)) {
            return;
        }
        if (!parameter.isAllowNull() && "".equals(value)) {
            throw new InvalidParamInputException(parameter.getAlias() + Messages.getMLS("cannotBeEmpty", "\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (!"".equals(value) && !value.startsWith("@ExtRpt") && !MacroFormatUtil.checkMacroUidFormat((String)value) && !"#@$firstData$@#".equals(value) && (inputType.equals(InputType.INPUT) || inputType.equals(InputType.LIST) || inputType.equals(InputType.Spinner) || inputType.equals(InputType.CHECKBOX) || inputType.equals(InputType.F7LIST) || inputType.equals(InputType.ALONE_CHECKBOX))) {
            RunReportParam.isRightDataType(parameter.getAliasName(), value, dataType.intValue());
        }
    }

    private static void isRightDataType(String alias, String value, int dataType) throws InvalidParamInputException {
        String[] values = value.split("0xx1xx");
        for (int i = 0; i < values.length; ++i) {
            String singleValue = values[i];
            if (StringUtils.isEmpty(singleValue)) continue;
            if (dataType == 1) {
                if (RunReportParam.isNumeric(singleValue)) continue;
                throw new InvalidParamInputException(alias + Messages.getMLS("mustBeNumericType", " \u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b"));
            }
            if (dataType == 2) {
                if (RunReportParam.isValidDate(singleValue)) continue;
                throw new InvalidParamInputException(alias + Messages.getMLS("mustBeDateTypeFormat1", "\u5fc5\u987b\u662f\u65e5\u671f\u7c7b\u578b\uff0c\u683c\u5f0f\u5982#1").replace("#1", " 2001-03-19"));
            }
            if (dataType == 4) {
                if (RunReportParam.isValidDateTime(singleValue)) continue;
                throw new InvalidParamInputException(alias + Messages.getMLS("mustBeDateTimeTypeFormat1", "\u5fc5\u987b\u662f\u65e5\u671f\u65f6\u95f4\u7c7b\u578b\uff0c\u683c\u5f0f\u5982#1").replace("#1", " 2001-03-19 13:30:21"));
            }
            if (dataType == 5) {
                if (RunReportParam.isValidTime(singleValue)) continue;
                throw new InvalidParamInputException(alias + Messages.getMLS("mustBeDateTimeTypeFormat1", "\u5fc5\u987b\u662f\u65e5\u671f\u65f6\u95f4\u7c7b\u578b\uff0c\u683c\u5f0f\u5982#1").replace("#1", " 13:30:21"));
            }
            if (dataType != 3 || RunReportParam.isBoolean(singleValue)) continue;
            throw new InvalidParamInputException(alias + Messages.getMLS("mustBeBooleanType", "\u5fc5\u987b\u662f\u5e03\u5c14\u7c7b\u578b\u3002"));
        }
    }

    private static boolean isValidDate(String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setLenient(false);
        try {
            sdf.parse(dateStr);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private static boolean isValidDateTime(String dateTimeStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setLenient(false);
        try {
            sdf.parse(dateTimeStr);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private static boolean isValidTime(String timeStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        sdf.setLenient(false);
        try {
            sdf.parse(timeStr);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isNumeric(String numStr) {
        return numStr.matches("^[-+]?\\d+(\\.\\d+)?$");
    }

    public static boolean isBoolean(String booleanStr) {
        return "0".equals(booleanStr) || "1".equals(booleanStr) || Boolean.TRUE.toString().equalsIgnoreCase(booleanStr) || Boolean.FALSE.toString().equalsIgnoreCase(booleanStr);
    }

    public static final Map<String, DesignParameter> setExecuteParam(List allUnionParam, String parameterXmlString) throws IOException, XmlParsingException {
        Map<String, DesignParameter> mapDesignParameter = RunReportParam.changWhereValueToMapParams(parameterXmlString);
        if (!mapDesignParameter.isEmpty()) {
            RunReportParam.getExecuteParam(allUnionParam, mapDesignParameter);
        }
        return mapDesignParameter;
    }

    public static Map<String, DesignParameter> getExecuteParam(List<DesignParameter> allUnionParam, Map<String, DesignParameter> mapDesignParameter) {
        HashMap mapNull = new HashMap();
        HashMap mapIgnoreNull = new HashMap();
        if (null != allUnionParam) {
            for (DesignParameter pCurrent : allUnionParam) {
                String currentParamName = pCurrent.getName();
                if (pCurrent.isAllowNull()) {
                    mapNull.put(currentParamName, null);
                }
                if (!pCurrent.isIgnoreNull()) continue;
                mapIgnoreNull.put(currentParamName, null);
            }
        }
        Set<Map.Entry<String, DesignParameter>> entrySet = mapDesignParameter.entrySet();
        for (Map.Entry<String, DesignParameter> entry : entrySet) {
            String name = entry.getKey();
            DesignParameter pDesign = entry.getValue();
            boolean isAllowNull = true;
            boolean isIgnoreNull = true;
            if (!mapNull.containsKey(name)) {
                isAllowNull = false;
            }
            if (!mapIgnoreNull.containsKey(name)) {
                isIgnoreNull = false;
            }
            pDesign.setAllowNull(isAllowNull);
            pDesign.setIgnoreNull(isIgnoreNull);
        }
        return mapDesignParameter;
    }

    public static final Map<String, DesignParameter> changWhereValueToMapParams(String whereValue) throws IOException, XmlParsingException {
        LinkedHashMap<String, DesignParameter> param = new LinkedHashMap<String, DesignParameter>();
        if (null != whereValue && whereValue.length() > 0) {
            IXmlElement root = XMLUtil.loadRootElement(whereValue);
            boolean lowVersion = false;
            String version = CtrlReportUtil.getObjectString(root.getAttribute(CtrlDesignUtil.VERSION));
            if (version.length() <= 0) {
                lowVersion = true;
            }
            List lst = root.getChildren();
            for (IXmlElement et : lst) {
                String name = CtrlReportUtil.getObjectString(et.getAttribute("name"));
                String value = CtrlReportUtil.getObjectString(et.getAttribute("value"));
                String valueAlias = CtrlReportUtil.getObjectString(et.getAttribute("valueAlias"));
                String dataType = CtrlReportUtil.getObjectString(et.getAttribute("dataType"));
                if (lowVersion) {
                    if (!StringUtils.isEmpty(value) && value.indexOf(";") != -1) {
                        value = ExtStringUtil.replace(value, ";", "0xx1xx");
                    }
                    if (!StringUtils.isEmpty(valueAlias) && valueAlias.indexOf(";") != -1) {
                        valueAlias = ExtStringUtil.replace(valueAlias, ";", "0xx1xx");
                    }
                }
                DesignParameter dp = new DesignParameter();
                dp.setName(name);
                dp.setCurentValue(value);
                dp.setCurentValueAlias(valueAlias);
                dp.setDesignDataType(DesignDataType.getDataType(Integer.parseInt(dataType)));
                param.put(name, dp);
            }
        }
        return param;
    }

    public static final void putDefalutListParamsMap(Object context, Map<String, DesignParameter> mapDesignParma) {
        List<InnerParam> params = InnerParamUtil.getInnerParams(context);
        for (InnerParam param : params) {
            RunReportParam.putParamsMap(mapDesignParma, param.getId(), param.getAlias(), param.getValue());
        }
    }

    private static final void putParamsMap(Map<String, DesignParameter> mapDesignParam, String paramName, String paramAlias, Object objValue) {
        paramAlias = ExtStringUtil.replace(paramAlias, "@", "");
        paramAlias = ExtStringUtil.replace(paramAlias, "'", "");
        String value = CtrlReportUtil.getObjectString(objValue);
        DesignParameter dp = new DesignParameter();
        dp.setName(paramName);
        dp.setAlias(paramAlias);
        dp.setCurentValue(value);
        dp.setDesignDataType(DesignDataType.getDataType(0));
        mapDesignParam.put(paramName, dp);
    }

    public static final void putParamsMap(Map mapDesignParam, String paramName, Object objValue) {
        String value = CtrlReportUtil.getObjectString(objValue);
        DesignParameter dp = new DesignParameter();
        dp.setName(paramName);
        dp.setCurentValue(value);
        dp.setDesignDataType(DesignDataType.getDataType(0));
        mapDesignParam.put(paramName, dp);
    }

    public static final String getSystemFullLabel(DefaultKingdeeTreeNode nodeRoot, String systemID) {
        String pathStringLabel = null;
        try {
            Enumeration enume = nodeRoot.children();
            while (enume.hasMoreElements()) {
                DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
                IBriefViewTreeNode bvNode = (IBriefViewTreeNode)repNode.getUserObject();
                String currentSystemID = bvNode.getFullName();
                if (StringUtil.equals((String)currentSystemID, (String)systemID)) {
                    Object[] pathtoRoot = repNode.getPath();
                    pathStringLabel = RunReportParam.getPathString(pathtoRoot);
                    return pathStringLabel;
                }
                pathStringLabel = RunReportParam.getSystemFullLabel(repNode, systemID);
                if (null == pathStringLabel) continue;
                return pathStringLabel;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return pathStringLabel;
    }

    public static final String getPathString(Object[] obs) {
        StringBuilder sb = new StringBuilder();
        int size = obs.length;
        for (int i = 0; i < size; ++i) {
            sb.append(obs[i].toString());
            if (i >= size - 1) continue;
            sb.append(Slash);
        }
        return sb.toString();
    }

    public static final Variant getVariant(String[] values, int dataType) {
        if (values == null) {
            return Variant.nullVariant;
        }
        String value = "";
        StringBuilder sb = new StringBuilder();
        sb.append(value);
        for (int i = 0; i < values.length; ++i) {
            sb.append(CtrlReportUtil.getObjectString(values[i]));
            sb.append("0xx1xx");
        }
        value = sb.toString();
        if (!StringUtils.isEmpty(value)) {
            value = value.substring(0, value.length() - "0xx1xx".length());
        }
        return RunReportParam.getVariant(value, dataType);
    }

    public static final Variant getVariant(String value, int dataType) {
        value = CtrlReportUtil.getObjectString(value);
        int mulSelected = value.indexOf("0xx1xx");
        if (value.length() == 0) {
            return Variant.nullVariant;
        }
        if (dataType == 0) {
            if (mulSelected != -1) {
                String[] arr = value.split("0xx1xx");
                if (value.endsWith("0xx1xx")) {
                    ArrayList<String> valueList = new ArrayList<String>(Arrays.asList(arr));
                    valueList.add("");
                    arr = valueList.toArray(new String[0]);
                }
                int len = arr.length;
                Variant[] vts = new Variant[len];
                for (int n = 0; n < len; ++n) {
                    Variant vt;
                    vts[n] = vt = new Variant((Object)arr[n], 11);
                }
                return new Variant((Object)vts, 527);
            }
            return new Variant((Object)value, 11);
        }
        if (dataType == 1) {
            if (mulSelected != -1) {
                String[] arr = value.split("0xx1xx");
                int len = arr.length;
                Variant[] vts = new Variant[len];
                for (int n = 0; n < len; ++n) {
                    Variant vt;
                    String temp = arr[n];
                    BigDecimal bd = null;
                    try {
                        bd = new BigDecimal(temp);
                        vt = new Variant((Object)bd, 10);
                    }
                    catch (Exception e) {
                        vt = Variant.nullVariant;
                    }
                    vts[n] = vt;
                }
                return new Variant((Object)vts, 512);
            }
            BigDecimal bd = null;
            try {
                bd = new BigDecimal(value);
                return new Variant((Object)bd, 10);
            }
            catch (Exception e) {
                return Variant.nullVariant;
            }
        }
        if (dataType == 2) {
            if (mulSelected != -1) {
                String[] arr = value.split("0xx1xx");
                int len = arr.length;
                Variant[] vts = new Variant[len];
                for (int n = 0; n < len; ++n) {
                    String temp = arr[n];
                    vts[n] = Format.parseData((String)temp, (boolean)true);
                }
                return new Variant((Object)vts, 512);
            }
            return Format.parseData((String)value, (boolean)true);
        }
        if (dataType == 4) {
            if (mulSelected != -1) {
                String[] arr = value.split("0xx1xx");
                int len = arr.length;
                Variant[] vts = new Variant[len];
                for (int n = 0; n < len; ++n) {
                    String temp = arr[n];
                    vts[n] = Format.parseData((String)temp, (boolean)true);
                }
                return new Variant((Object)vts, 512);
            }
            return Format.parseData((String)value, (boolean)true);
        }
        if (dataType == 5) {
            if (mulSelected != -1) {
                String[] arr = value.split("0xx1xx");
                int len = arr.length;
                Variant[] vts = new Variant[len];
                for (int n = 0; n < len; ++n) {
                    String temp = arr[n];
                    vts[n] = Format.parseData((String)temp, (boolean)true);
                }
                return new Variant((Object)vts, 512);
            }
            return Format.parseData((String)value, (boolean)true);
        }
        if (dataType == 3) {
            if (mulSelected != -1) {
                String[] arr = value.split("0xx1xx");
                int len = arr.length;
                Variant[] vts = new Variant[len];
                for (int n = 0; n < len; ++n) {
                    Variant vt;
                    String temp = arr[n];
                    Boolean b = null;
                    try {
                        b = "0".equals(temp) ? Boolean.FALSE : ("1".equals(temp) ? Boolean.TRUE : Boolean.valueOf(temp));
                        vt = new Variant((Object)b, 8);
                    }
                    catch (Exception e) {
                        vt = Variant.nullVariant;
                    }
                    vts[n] = vt;
                }
                return new Variant((Object)vts, 512);
            }
            Boolean b = null;
            try {
                b = "0".equals(value) ? Boolean.FALSE : ("1".equals(value) ? Boolean.TRUE : Boolean.valueOf(value));
                return new Variant((Object)b, 8);
            }
            catch (Exception e) {
                return Variant.nullVariant;
            }
        }
        return new Variant((Object)value, 11);
    }

    public static final Variant getOutputParamVariant(Object value, int dataType) {
        if (dataType == 0) {
            return new Variant(value, 11);
        }
        if (dataType == 1 || dataType == 2) {
            BigDecimal bd = null;
            try {
                bd = new BigDecimal(String.valueOf(value));
                return new Variant((Object)bd, 10);
            }
            catch (Exception e) {
                return Variant.nullVariant;
            }
        }
        if (dataType == 3) {
            java.util.Date date = null;
            try {
                if (value != null && value.getClass().getName().equals("oracle.sql.DATE")) {
                    try {
                        Object oracleTime = value.getClass().getMethod("timestampValue", new Class[]{null}).invoke(value, (Object[])null);
                        Long times = (Long)oracleTime.getClass().getMethod("getTime", new Class[]{null}).invoke(oracleTime, (Object[])null);
                        date = new java.util.Date(times);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else if (value instanceof Date) {
                    date = new java.util.Date(((Date)value).getTime());
                } else if (value instanceof java.util.Date) {
                    date = (java.util.Date)value;
                } else if (value instanceof String) {
                    date = CtrlReportUtil.sdf_yyyy_MM_dd.get().parse((String)value);
                }
                String temp = CtrlReportUtil.formatDate(date);
                return Format.parseData((String)temp, (boolean)true);
            }
            catch (Exception e) {
                return Variant.nullVariant;
            }
        }
        if (dataType == 4) {
            java.util.Date date = null;
            try {
                if (value != null && value.getClass().getName().equals("oracle.sql.TIMESTAMP")) {
                    try {
                        Object oracleTime = value.getClass().getMethod("timestampValue", new Class[]{null}).invoke(value, (Object[])null);
                        Long times = (Long)oracleTime.getClass().getMethod("getTime", new Class[]{null}).invoke(oracleTime, (Object[])null);
                        date = new java.util.Date(times);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else if (value instanceof Timestamp) {
                    date = new java.util.Date(((Timestamp)value).getTime());
                } else if (value instanceof java.util.Date) {
                    date = (java.util.Date)value;
                } else if (value instanceof String) {
                    date = CtrlReportUtil.sdfDateTime.get().parse((String)value);
                }
                String temp = CtrlReportUtil.formatDateTime(date);
                return Format.parseData((String)temp, (boolean)true);
            }
            catch (Exception e) {
                return Variant.nullVariant;
            }
        }
        return new Variant(value, 11);
    }

    public static final Object getOracleDateValue(Object value) {
        if (value != null && (value.getClass().getName().equals("oracle.sql.TIMESTAMP") || value.getClass().getName().equals("oracle.sql.DATE"))) {
            try {
                Object oracleTime = value.getClass().getMethod("timestampValue", new Class[]{null}).invoke(value, (Object[])null);
                Long times = (Long)oracleTime.getClass().getMethod("getTime", new Class[]{null}).invoke(oracleTime, (Object[])null);
                Timestamp date = new Timestamp(times);
                return date;
            }
            catch (Exception e) {
                return value;
            }
        }
        return value;
    }

    private static void showErrMsg(String dbsourcename, CtrlReportException e) throws CtrlReportException {
        String msg = Messages.getMLS("datasetNotFound", "\u627e\u4e0d\u5230\u6570\u636e\u96c6");
        String msg0 = Messages.getMLS("reasonPossiblelyAs", "\u539f\u56e0\u53ef\u80fd\u4e3a\uff1a");
        String msg1 = Messages.getMLS("datasetDeleted", "1\u3001\u6570\u636e\u96c6\u5df2\u7ecf\u88ab\u5220\u9664");
        String msg2 = Messages.getMLS("datasetReNamed", "2\u3001\u6570\u636e\u96c6\u5df2\u7ecf\u88ab\u6539\u540d");
        String msg3 = Messages.getMLS("datasetOrgNotMatch", "3\u3001\u6570\u636e\u96c6\u4e0e\u62a5\u8868\u521b\u5efa\u7ec4\u7ec7\u4e0d\u4e00\u81f4");
        String msg4 = Messages.getMLS("datasetPathChanged", "4\u3001\u6570\u636e\u96c6\u5bfc\u5165\u540e\u5b50\u7cfb\u7edf\u8def\u5f84\u6539\u53d8");
        String msg5 = Messages.getMLS("datasetIdChanged", "5\u3001\u6570\u636e\u96c6\u5bfc\u5165\u540eID\u6539\u53d8");
        String msge = Messages.getMLS("resetDatasetInReportDesigner", "\u8bf7\u91cd\u65b0\u5728\u62a5\u8868\u8bbe\u8ba1\u5668\u4e2d\u8bbe\u7f6e\u6570\u636e\u96c6\uff01");
        StringBuilder sb = new StringBuilder();
        sb.append(msg).append("\uff1a").append(dbsourcename).append("\r\n").append(msg0).append("\r\n");
        sb.append(msg1).append("\r\n").append(msg2).append("\r\n").append(msg3).append("\r\n").append(msg4).append("\r\n").append(msg5).append("\r\n").append(msge);
        if (e != null) {
            throw e;
        }
        throw new CtrlReportException(sb.toString());
    }

    public static final boolean cacheDbSourceModel(Object ctx, ExtDataSet[] datasets, List allUnionParam) throws CtrlReportException {
        for (int i = 0; i < datasets.length; ++i) {
            String define;
            DataSetDefineModel sqlDataSetDefineModel;
            ExtDataSet ds = datasets[i];
            if (ds == null || (sqlDataSetDefineModel = DataSetDefineModel.parseDefine(define = ds.getDefine())) == null) continue;
            String dbsourceName = sqlDataSetDefineModel.getName();
            CtrlDesignQueryModel model = null;
            try {
                model = KSQLReportBO.initModel(ctx, ds, null);
            }
            catch (CycleException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (model == null) {
                RunReportParam.showErrMsg(dbsourceName, null);
                return false;
            }
            RunReportParam.unionKsqlParam(ctx, allUnionParam, model, datasets[i].getBook());
        }
        return true;
    }

    public static final boolean cacheDbSourceModel(Object ctx, ExtDataSet[] datasets, List<Map<String, Object>> reportDBModel, List<DesignParameter> allUnionParam) throws CtrlReportException {
        for (int i = 0; i < datasets.length; ++i) {
            ExtDataSet ds = datasets[i];
            String define = ds.getDefine();
            DataSetDefineModel sqlDataSetDefineModel = DataSetDefineModel.parseDefine(define);
            if (sqlDataSetDefineModel == null) continue;
            String dbsourceName = sqlDataSetDefineModel.getName();
            String dbsourceid = sqlDataSetDefineModel.getId();
            String dbType = sqlDataSetDefineModel.getType();
            CtrlDesignQueryModel model = null;
            try {
                model = KSQLReportBO.initModel(ctx, ds, null);
            }
            catch (CycleException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (DataSetContentNotExistsException e) {
                RunReportParam.showErrMsg(dbsourceName, e);
            }
            if (model == null) {
                RunReportParam.showErrMsg(dbsourceName, null);
                return false;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", ExtDataSetType.getExtDataSetType((String)define).getType());
            map.put("dbsourceid", dbsourceid);
            map.put("model", model);
            RunReportParam.unionKsqlParam(ctx, allUnionParam, model, datasets[i].getBook());
            reportDBModel.add(map);
        }
        return true;
    }

    public static void unionKsqlParam(Object ctx, List<DesignParameter> allUnionParam, CtrlDesignQueryModel model, Book book) throws CtrlReportException {
        List currentList = model.getCommonQuery().getParameters();
        if (null == currentList || currentList.isEmpty()) {
            return;
        }
        HashMap<String, DesignParameter> defaultSystemPreParameters = new HashMap<String, DesignParameter>();
        RunReportParam.putDefalutListParamsMap(ctx, defaultSystemPreParameters);
        for (DesignParameter pCurrent : currentList) {
            String currentParamName = pCurrent.getName();
            if (null == currentParamName) continue;
            boolean isFind = false;
            for (DesignParameter pAll : allUnionParam) {
                String paramName = pAll.getName();
                if (!currentParamName.equalsIgnoreCase(paramName)) continue;
                isFind = true;
                break;
            }
            if (isFind) continue;
            allUnionParam.add(pCurrent);
            RunReportParam.processDefaultValue(ctx, pCurrent, allUnionParam, defaultSystemPreParameters);
        }
    }

    public static void processDefaultValue(Object ctx, DesignParameter pCurrent, List<DesignParameter> allUnionParam, Map<String, DesignParameter> defaultSystemPreParameters) throws CtrlReportException {
        boolean isMacroParam = false;
        String defaultValue = pCurrent.getDefaultValue();
        String defaultAlias = pCurrent.getDefaultAlias();
        if (defaultValue != null) {
            if (DateTransUtil.isVer2(defaultValue)) {
                String date2Str = DateTransUtil.transDate2Str(defaultValue, ctx);
                pCurrent.setCurentValue(date2Str);
                pCurrent.setCurentValueAlias(date2Str);
                pCurrent.setDefaultValue(date2Str);
                pCurrent.setDefaultAlias(date2Str);
            } else {
                String[] values = defaultValue.split("0xx1xx");
                String[] alias = null;
                if (defaultAlias != null) {
                    alias = defaultAlias.split("0xx1xx");
                }
                StringBuilder valueParsedTemp = new StringBuilder();
                StringBuilder aliasParsedTemp = new StringBuilder();
                Integer constValueLen = null;
                for (int i = 0; i < values.length; ++i) {
                    String value1 = values[i];
                    String alias1 = null;
                    if (alias != null) {
                        alias1 = alias[i];
                    }
                    if (aliasParsedTemp.length() > 0 && (constValueLen == null || i < constValueLen)) {
                        valueParsedTemp.append("0xx1xx");
                        aliasParsedTemp.append("0xx1xx");
                    }
                    if (value1 != null && value1.startsWith("@ExtRpt")) {
                        DesignParameter p = defaultSystemPreParameters.get(value1.substring(1));
                        valueParsedTemp.append(p.getCurentValue());
                        if (!StringUtil.isEmptyString((String)p.getCurentValueAlias())) {
                            aliasParsedTemp.append(p.getCurentValueAlias());
                            continue;
                        }
                        aliasParsedTemp.append(p.getCurentValue());
                        continue;
                    }
                    if (value1 != null && MacroFormatUtil.checkMacroUidFormat((String)value1)) {
                        isMacroParam = true;
                        StringBuilder macroValueBuilder = new StringBuilder();
                        StringBuilder macroDisplayBuilder = new StringBuilder();
                        IInputCtrl ctrl = pCurrent.getInputCtrl();
                        String ctrlDefValue = ctrl != null && ctrl.getDefValue() != null ? ctrl.getDefValue().getName() : null;
                        String ctrlDefDisplay = ctrl != null && ctrl.getDefDisplay() != null ? ctrl.getDefDisplay().getName() : null;
                        ExtMacroValue extMacroValue = MacroUtil.loadMacroValuesByUid(ctx, value1.substring(1), -1);
                        if (extMacroValue.getAllColumnValues() != null) {
                            List<String> allColumnNames = extMacroValue.getAllColumnNames();
                            List<List<Object>> allColumnValues = extMacroValue.getAllColumnValues();
                            int defValueIndex = -1;
                            int defDisplayIndex = -1;
                            if (ctrlDefValue != null && ctrlDefDisplay != null) {
                                int len = allColumnNames.size();
                                for (int j = 0; j < len; ++j) {
                                    String columnName = allColumnNames.get(j);
                                    if (ctrlDefValue.equalsIgnoreCase(columnName)) {
                                        defValueIndex = j;
                                    }
                                    if (ctrlDefDisplay.equalsIgnoreCase(columnName)) {
                                        defDisplayIndex = j;
                                    }
                                    if (defValueIndex != -1 && defDisplayIndex != -1) break;
                                }
                            }
                            if (defDisplayIndex == -1) {
                                defDisplayIndex = 0;
                            }
                            if (defValueIndex == -1) {
                                defValueIndex = 0;
                            }
                            if (null != allColumnValues && !allColumnValues.isEmpty()) {
                                int rowCount;
                                int index = 0;
                                int len = rowCount = allColumnValues.get(0).size();
                                if (ctrl != null) {
                                    int rowLimit = ctrl.getRowLimit() == null ? Integer.MAX_VALUE : Integer.parseInt(ctrl.getRowLimit());
                                    len = ctrl.isAllowMultipleSelected() ? Math.min(rowCount, rowLimit) : Math.min(rowCount, 1);
                                }
                                for (int j = 0; j < len; ++j) {
                                    if (index != 0) {
                                        macroValueBuilder.append("0xx1xx");
                                        macroDisplayBuilder.append("0xx1xx");
                                    }
                                    macroValueBuilder.append(allColumnValues.get(defValueIndex).get(j));
                                    macroDisplayBuilder.append(allColumnValues.get(defDisplayIndex).get(j));
                                    ++index;
                                }
                            }
                        }
                        valueParsedTemp.append((CharSequence)macroValueBuilder);
                        aliasParsedTemp.append((CharSequence)macroDisplayBuilder);
                        continue;
                    }
                    if ("#@$firstData$@#".equals(defaultValue)) {
                        String v = "";
                        String a = "";
                        Entry item = RunReportParam.parseFirstDataValue(ctx, pCurrent, allUnionParam);
                        v = String.valueOf(item.getValue());
                        a = String.valueOf(item.getText());
                        valueParsedTemp.append(v);
                        aliasParsedTemp.append(a);
                        continue;
                    }
                    IInputCtrl ctrl = pCurrent.getInputCtrl();
                    if (ctrl != null && constValueLen == null && ctrl.isAllowMultipleSelected()) {
                        int rowLimit = ctrl.getRowLimit() == null ? Integer.MAX_VALUE : Integer.parseInt(ctrl.getRowLimit());
                        constValueLen = Math.min(values.length, rowLimit);
                    }
                    if (constValueLen != null && i >= constValueLen) continue;
                    valueParsedTemp.append(value1);
                    if (StringUtil.isEmptyString((String)alias1)) continue;
                    aliasParsedTemp.append(alias1);
                }
                if (aliasParsedTemp.length() == 0) {
                    aliasParsedTemp = valueParsedTemp;
                }
                String valueParsed = valueParsedTemp.toString();
                String aliasParsed = aliasParsedTemp.toString();
                pCurrent.setCurentValue(valueParsed);
                pCurrent.setCurentValueAlias(aliasParsed);
                pCurrent.setDefaultValue(valueParsed);
                pCurrent.setDefaultAlias(aliasParsed);
            }
        }
        DesignDataType ddt = pCurrent.getDesignDataType();
        if (!isMacroParam) {
            String value;
            if (DesignDataType.DATE.equals(ddt) || ddt.equals(DesignDataType.DATETIME)) {
                value = RunReportParam.getDateValue(ctx, ddt, defaultValue);
                pCurrent.setDefaultValue(value);
                pCurrent.setDefaultAlias(value);
                pCurrent.setCurentValue(value);
                pCurrent.setCurentValueAlias(value);
            } else if (ddt.equals(DesignDataType.TIME)) {
                value = RunReportParam.getTimeValue(ctx, defaultValue);
                pCurrent.setDefaultValue(value);
                pCurrent.setDefaultAlias(value);
                pCurrent.setCurentValue(value);
                pCurrent.setCurentValueAlias(value);
            }
        }
    }

    public static Entry parseFirstDataValue(Object ctx, DesignParameter p, List<DesignParameter> params) {
        ReportParamDescription param = new ReportParamDescription();
        try {
            ExtFilterParamUtil.setParamSuppliedValues(ctx, p, param, null, params);
            Object supplies = param.getSuppliedValue();
            if (supplies instanceof List) {
                for (Object item : (List)supplies) {
                    if (!(item instanceof Entry)) continue;
                    return (Entry)item;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        String value = "parse first data error!";
        return new Entry(value, value);
    }

    public static final Map<String, DesignParameter> getParamDefalutValue(Object ctx, CtrlDesignQueryModel model) {
        HashMap<String, DesignParameter> mapDesignParam = new HashMap<String, DesignParameter>();
        List currentList = model.getCommonQuery().getParameters();
        if (null != currentList) {
            for (DesignParameter pCurrent : currentList) {
                String currentParamName = pCurrent.getName();
                if (null == currentParamName) continue;
                DesignParameter p = new DesignParameter();
                DesignDataType ddt = pCurrent.getDesignDataType();
                String defaultValue = CtrlReportUtil.getObjectString(pCurrent.getDefaultValue());
                if (ddt.equals(DesignDataType.DATE) || ddt.equals(DesignDataType.DATETIME)) {
                    defaultValue = RunReportParam.getDateValue(ctx, ddt, defaultValue);
                } else if (ddt.equals(DesignDataType.TIME)) {
                    defaultValue = RunReportParam.getTimeValue(ctx, defaultValue);
                }
                HashMap<String, DesignParameter> defaultSystemPreParameters = new HashMap<String, DesignParameter>();
                if (defaultValue != null && defaultValue.startsWith("@ExtRpt")) {
                    RunReportParam.putDefalutListParamsMap(ctx, defaultSystemPreParameters);
                    DesignParameter parameters_Default = (DesignParameter)((Object)defaultSystemPreParameters.get(defaultValue.substring(1)));
                    if (parameters_Default != null) {
                        defaultValue = parameters_Default.getCurentValue();
                    }
                }
                InputType inputType = pCurrent.getInputType();
                if (!StringUtil.isEmptyString((String)defaultValue) && inputType != null && inputType.equals(InputType.INPUT)) {
                    defaultValue = ExtStringUtil.replace(defaultValue, ";", "0xx1xx");
                }
                p.setName(currentParamName);
                p.setDefaultValue(defaultValue);
                p.setDesignDataType(pCurrent.getDesignDataType());
                p.setIgnoreNull(pCurrent.isIgnoreNull());
                p.setAllowNull(pCurrent.isAllowNull());
                mapDesignParam.put(currentParamName, p);
            }
            RunReportParam.putDefalutListParamsMap(ctx, mapDesignParam);
        }
        return mapDesignParam;
    }

    public static final String getRealFieldName(DefObj def) {
        if (def == null) {
            return null;
        }
        String fieldName = def.getName();
        String fieldNameReal = CtrlReportUtil.getObjectString(def.getProperty(entityfieldname));
        if (!StringUtils.isEmpty(fieldNameReal)) {
            fieldName = fieldNameReal.startsWith("f") ? fieldNameReal.substring(1) : fieldNameReal;
        }
        return fieldName;
    }

    public static final String getSQLVersion(CtrlDesignQueryModel model) {
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        String version = "";
        Map map = commonQuery.getProperties();
        if (null != map) {
            version = CtrlReportUtil.getObjectString(map.get(CtrlDesignUtil.VERSION));
        }
        return version;
    }

    public static final void setSQLVersion(CtrlDesignQueryModel model) {
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        commonQuery.getProperties().put(CtrlDesignUtil.VERSION, "2");
    }

    public static final void upgradeParam(CtrlDesignQueryModel model) {
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        Map map = commonQuery.getProperties();
        String version = CtrlReportUtil.getObjectString(map.get(CtrlDesignUtil.VERSION));
        if (StringUtils.isEmpty(version) || version.equals("-1")) {
            List currentList = model.getCommonQuery().getParameters();
            if (null != currentList) {
                for (DesignParameter p : currentList) {
                    String defalutAlias;
                    String defalutValue = CtrlReportUtil.getObjectString(p.getDefaultValue());
                    if (!StringUtils.isEmpty(defalutValue) && defalutValue.indexOf(59) != -1) {
                        defalutValue = ExtStringUtil.replace(defalutValue, ";", "0xx1xx");
                        p.setDefaultValue(defalutValue);
                    }
                    if (StringUtils.isEmpty(defalutAlias = CtrlReportUtil.getObjectString(p.getDefaultAlias())) || defalutAlias.indexOf(59) == -1) continue;
                    defalutAlias = ExtStringUtil.replace(defalutAlias, ";", "0xx1xx");
                    p.setDefaultAlias(defalutAlias);
                }
            }
            RunReportParam.setSQLVersion(model);
        }
    }

    public static java.util.Date getServerDate(Object ctx) {
        java.util.Date date = null;
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoFromServer");
        try {
            RptParams psR = FacadeFactory.commonExecute(ctx, pr);
            date = (java.util.Date)psR.getObject("Date");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            date = null;
        }
        return date;
    }

    public static List<Map<String, Object>> getBizDataList(Object context, boolean isKSQL, DefObj def, Map sqlDbMap, DesignParameter[] relatedParams) throws Exception {
        DefDbsourceModel defDbsourceModel = new DefDbsourceModel(def);
        String datasetID = defDbsourceModel.getID();
        String datasetName = defDbsourceModel.getName();
        String groupId = defDbsourceModel.getGroupID();
        String groupName = defDbsourceModel.getGroupName();
        String isolateTag = defDbsourceModel.getIsolateTag();
        ISQLDesignerProxy sqlDesignerProxy = ProxyFactory.createSQLDesignerProxy(context);
        if ("100000".equals(isolateTag) && !sqlDesignerProxy.checkPresetManagePermission()) {
            throw new DataSetNotPresetPermissionException(Messages.getMLS("noPermissionForPresetDatasetPleaseContactAdminForAuthorization", "\u60a8\u6ca1\u6709\u8be5\u9884\u7f6e\u6570\u636e\u96c6\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u201c\u7ba1\u7406\u5458\u201d\u8fdb\u884c\u6388\u6743\u3002"));
        }
        return RunReportParam.getBizDataList(context, isKSQL, datasetID, datasetName, groupId, groupName, isolateTag, sqlDbMap, relatedParams);
    }

    private static void buildF7Exception(String dbSourceName) throws Exception {
        String msg = Messages.getMLS("datasetNotFound", "\u627e\u4e0d\u5230\u6570\u636e\u96c6");
        String msg0 = Messages.getMLS("reasonPossiblelyAs", "\u539f\u56e0\u53ef\u80fd\u4e3a\uff1a");
        String msg1 = Messages.getMLS("datasetDeleted", "1\u3001\u6570\u636e\u96c6\u5df2\u7ecf\u88ab\u5220\u9664");
        String msg2 = Messages.getMLS("datasetReNamed", "2\u3001\u6570\u636e\u96c6\u5df2\u7ecf\u88ab\u6539\u540d");
        String msg3 = Messages.getMLS("datasetNotFoundInCurrentSource", "3\u3001\u6570\u636e\u96c6\u4e0e\u5f53\u524d\u6570\u636e\u6e90\u521b\u5efa\u7ec4\u7ec7\u4e0d\u4e00\u81f4");
        String msg4 = Messages.getMLS("datasetPathChanged", "4\u3001\u6570\u636e\u96c6\u5bfc\u5165\u540e\u5b50\u7cfb\u7edf\u8def\u5f84\u6539\u53d8");
        String msg5 = Messages.getMLS("datasetIdChanged", "5\u3001\u6570\u636e\u96c6\u5bfc\u5165\u540eID\u6539\u53d8");
        String msge = Messages.getMLS("resetDatasetInSQLDesigner", "\u8bf7\u91cd\u65b0\u5728SQL\u8bbe\u8ba1\u5668\u8bbe\u7f6e\u6570\u636e\u96c6\uff01");
        StringBuilder sb = new StringBuilder();
        sb.append(msg).append("\uff1a").append(dbSourceName).append("\r\n").append(msg0).append("\r\n").append(msg1).append("\r\n").append(msg2).append("\r\n").append(msg3).append("\r\n").append(msg4).append("\r\n").append(msg5).append("\r\n").append(msge);
        throw new Exception(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<Map<String, Object>> getBizDataList(Object ctx, boolean isKSQL, String datasetID, String datasetName, String groupId, String groupName, String isolateTag, Map models, DesignParameter[] relatedParams) throws Exception {
        ArrayList reportDBModel = new ArrayList();
        Map<String, DesignParameter> mapDesignParam = new HashMap<String, DesignParameter>();
        if (isKSQL) {
            String dataMeta;
            CtrlDesignQueryModel model = null;
            String cacheKey = SqlDSModelDrill.getKey(datasetName, groupId);
            if (models != null && !StringUtil.isEmptyString((String)(dataMeta = (String)models.get(cacheKey)))) {
                model = KSQLReportBO.initModelFromXml(ctx, dataMeta, null);
            }
            if (model == null) {
                model = KSQLReportBO.initModel(ctx, groupId, groupName, datasetID, datasetName, isolateTag, null);
            }
            if (model == null) {
                RunReportParam.buildF7Exception(datasetName);
            }
            Object type = model.getCommonQuery().getProperties().get(CtrlDesignUtil.CustomType);
            String dataType = CtrlReportUtil.getObjectString(type);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", CtrlDesignUtil.getDataSetTypeName(CtrlReportUtil.getDataSetType(dataType)));
            map.put("dbsourceid", datasetID);
            map.put("model", model);
            reportDBModel.add(map);
            mapDesignParam = RunReportParam.getParamDefalutValue(ctx, model);
        }
        ArrayList<Map<String, Object>> lst = new ArrayList();
        ExtBizData ebd = new ExtBizData();
        ebd.setReportDBModel(reportDBModel);
        RunReportParam.putDefalutListParamsMap(ctx, mapDesignParam);
        if (relatedParams != null) {
            for (int i = 0; i < relatedParams.length; ++i) {
                String name = relatedParams[i].getName();
                DesignParameter dp = (DesignParameter)((Object)mapDesignParam.get(name));
                if (dp != null && !StringUtil.isEmptyString((String)dp.getDefaultValue()) && !"#@$firstData$@#".equals(dp.getDefaultValue()) && StringUtil.isEmptyString((String)relatedParams[i].getCurentValue())) continue;
                mapDesignParam.put(name, relatedParams[i]);
            }
        }
        ebd.setParams(mapDesignParam);
        DataSetDefineModel dataSetDefineModel = new DataSetDefineModel();
        dataSetDefineModel.setId(datasetID);
        dataSetDefineModel.setName(datasetName);
        dataSetDefineModel.setGroupID(groupId);
        dataSetDefineModel.setGroupName(groupName);
        dataSetDefineModel.setType(((Map)reportDBModel.get(0)).get("type").toString());
        dataSetDefineModel.setIsolateTag(isolateTag);
        dataSetDefineModel.setGroupType("\u76ee\u5f55");
        String define = dataSetDefineModel.buildDefine();
        IExtendReport extendReport = KSQLReportBO.getExtendReport(ctx, define);
        ebd.execute(extendReport, 0, -1);
        ResultSet rs = ebd.getRs();
        try {
            lst = ExtDBUtil.setDataToList(rs);
        }
        finally {
            CloseUtil.close(rs);
        }
        return lst;
    }

    public static String getTimeValue(Object context, String timeValue) {
        if (timeValue != null && timeValue.startsWith("getSystemTime()")) {
            java.util.Date date = RunReportParam.getServerDate(context);
            timeValue = CtrlReportUtil.formatTime(date);
        }
        return timeValue;
    }

    public static String getTimeString(Object context, String timeValue) {
        if (StringUtils.isEmpty(timeValue)) {
            return " 00:00:00";
        }
        return " " + RunReportParam.getTimeValue(context, timeValue);
    }

    public static String getDateValue(Object ctx, DesignDataType ddt, String dateValue) {
        dateValue = CtrlReportUtil.getObjectString(dateValue);
        String timeValue = "";
        if (dateValue.indexOf(124) != -1) {
            String[] arr = dateValue.split("\\|");
            dateValue = arr[0];
            timeValue = arr[1];
        }
        java.util.Date date = null;
        String dateString = "";
        if (dateValue != null) {
            if (DateTransUtil.isVer2(dateValue)) {
                return DateTransUtil.transDate2Str(dateValue, ctx);
            }
            if (dateValue.startsWith("getSystemDate()")) {
                date = RunReportParam.getServerDate(ctx);
                dateString = ddt.equals(DesignDataType.DATETIME) ? CtrlReportUtil.formatDateTime(date) : CtrlReportUtil.formatDate(date);
            } else if (dateValue.startsWith("dayBegin")) {
                date = RunReportParam.getServerDate(ctx);
                dateString = DateUtil.getMonthFirstDay(date);
                if (ddt.equals(DesignDataType.DATETIME)) {
                    dateString = dateString + RunReportParam.getTimeString(ctx, timeValue);
                }
            } else if (dateValue.startsWith("dayEnd")) {
                date = RunReportParam.getServerDate(ctx);
                dateString = DateUtil.getMonthLastDay(date);
                if (ddt.equals(DesignDataType.DATETIME)) {
                    dateString = dateString + RunReportParam.getTimeString(ctx, timeValue);
                }
            } else if (dateValue.startsWith("dateAdd + ")) {
                date = RunReportParam.getServerDate(ctx);
                dateValue = ExtStringUtil.replace(dateValue, "dateAdd + ", "");
                int lenth = dateValue.length();
                int addNumber = Integer.parseInt(dateValue.substring(0, lenth - 1));
                dateString = DateUtil.tuneDate(date, addNumber);
                if (ddt.equals(DesignDataType.DATETIME)) {
                    dateString = dateString + RunReportParam.getTimeString(ctx, timeValue);
                }
            } else if (dateValue.startsWith("dateSub - ")) {
                date = RunReportParam.getServerDate(ctx);
                dateValue = ExtStringUtil.replace(dateValue, "dateSub - ", "");
                int lenth = dateValue.length();
                int addNumber = Integer.parseInt(dateValue.substring(0, lenth - 1));
                dateString = DateUtil.tuneDate(date, 0 - addNumber);
                if (ddt.equals(DesignDataType.DATETIME)) {
                    dateString = dateString + RunReportParam.getTimeString(ctx, timeValue);
                }
            } else if (dateValue.startsWith("=")) {
                date = RunReportParam.getServerExprDate(ctx, dateValue);
                dateString = ddt.equals(DesignDataType.DATETIME) ? CtrlReportUtil.formatDateTime(date) : CtrlReportUtil.formatDate(date);
            } else {
                dateString = dateValue;
            }
        }
        return dateString;
    }

    public static java.util.Date getServerExprDate(Object ctx, String expr) {
        java.util.Date date = null;
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getServerExprDate");
        pr.setString("expr", expr);
        try {
            RptParams psR = FacadeFactory.commonExecute(ctx, pr);
            date = (java.util.Date)psR.getObject("Date");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            date = null;
        }
        return date;
    }

    public static final Map<String, DesignParameter> extParam2DesignParma(Map<String, IParameter> mapParameterImpl) throws SyntaxErrorException {
        HashMap<String, DesignParameter> mapDesignParam = new HashMap<String, DesignParameter>();
        if (null != mapParameterImpl && !mapParameterImpl.isEmpty()) {
            Set<Map.Entry<String, IParameter>> entrySet = mapParameterImpl.entrySet();
            for (Map.Entry<String, IParameter> entry : entrySet) {
                java.util.Date date;
                Variant vt;
                String name = entry.getKey();
                IParameter p = entry.getValue();
                int dataType = p.getDataType();
                Variant v = p.getValue();
                String valueString = CtrlReportUtil.getObjectString(v.getValue());
                Variant valueObject = p.getValue();
                if (valueObject instanceof Variant && valueObject.isArray()) {
                    Variant[] vts = (Variant[])valueObject.getValue();
                    if (null != vts) {
                        StringBuilder valueStringTemp = new StringBuilder();
                        int length = vts.length;
                        for (int i = 0; i < length; ++i) {
                            String vtTemp;
                            java.util.Date date2;
                            Variant vt2 = vts[i];
                            if (dataType == 2) {
                                date2 = vt2.toDate();
                                vtTemp = CtrlReportUtil.sdf_yyyy_MM_dd.get().format(date2);
                            } else if (dataType == 4) {
                                date2 = vt2.toDate();
                                vtTemp = CtrlReportUtil.sdfDateTime.get().format(date2);
                            } else if (dataType == 5) {
                                date2 = vt2.toDate();
                                vtTemp = CtrlReportUtil.sdfTime.get().format(date2);
                            } else {
                                vtTemp = CtrlReportUtil.getObjectString(vt2.toString());
                            }
                            if (i > 0) {
                                valueStringTemp.append("0xx1xx");
                            }
                            valueStringTemp.append(vtTemp);
                        }
                        valueString = valueStringTemp.toString();
                    }
                } else if (dataType == 2 && valueObject instanceof Variant && !StringUtils.isEmpty(valueString)) {
                    vt = valueObject;
                    date = vt.toDate();
                    valueString = CtrlReportUtil.sdf_yyyy_MM_dd.get().format(date);
                } else if (dataType == 4 && valueObject instanceof Variant && !StringUtils.isEmpty(valueString)) {
                    vt = valueObject;
                    date = vt.toDate();
                    valueString = CtrlReportUtil.sdfDateTime.get().format(date);
                } else if (dataType == 5 && valueObject instanceof Variant && !StringUtils.isEmpty(valueString)) {
                    vt = valueObject;
                    date = vt.toDate();
                    valueString = CtrlReportUtil.sdfTime.get().format(date);
                }
                DesignParameter dp = new DesignParameter();
                dp.setName(name);
                dp.setCurentValue(valueString);
                dp.setDesignDataType(DesignDataType.getDataType(dataType));
                dp.setIgnoreNull(p.isIgnoreNull());
                dp.setAllowNull(p.isNullable());
                mapDesignParam.put(name, dp);
            }
        }
        return mapDesignParam;
    }
}

