/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.tobi.domain;

import com.kingdee.bos.datawizard.edd.ctrlreport.macro.exception.ExtMacroException;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroValue;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.industry.MacroUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.OrgRangeManage;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.datawizard.edd.tobi.domain.ArgInputComponentFactory;
import com.kingdee.bos.datawizard.edd.tobi.domain.ISuppliedValueProvider;
import com.kingdee.bos.datawizard.edd.web.vo.Entry;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.cosmic.ctrl.data.modal.DefObj;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SuppliedValueProvider
implements ISuppliedValueProvider {
    private Object context;
    private DesignParameter designParam;
    private Map sqlDbMap;
    private Map<String, DesignParameter> srcAll;

    public SuppliedValueProvider(Object context, DesignParameter dp, Map sqlDbMap, Map<String, DesignParameter> srcAll) {
        this.context = context;
        this.designParam = dp;
        this.sqlDbMap = sqlDbMap;
        this.srcAll = srcAll;
    }

    @Override
    public List<Entry> getSuppliedValues() throws Exception {
        IInputCtrl inputCtrl = this.designParam.getInputCtrl();
        if (null == inputCtrl) {
            return null;
        }
        List<Entry> suppliedValues = null;
        switch (inputCtrl.getDataBind()) {
            case 0: {
                if (inputCtrl.getDefDbsource() == null) break;
                DesignParameter[] relatedParams = null;
                boolean shouldRelated = true;
                relatedParams = ArgInputComponentFactory.fetchSuppliers(this.context, this.designParam, this.srcAll);
                suppliedValues = this.getSupperliedValuesByDB(inputCtrl, relatedParams);
                break;
            }
            case 6: {
                if (inputCtrl.getDefDisplay() == null || inputCtrl.getDefValue() == null) break;
                suppliedValues = this.getSupperliedValuesBySystem(inputCtrl);
                break;
            }
            case 1: {
                if (inputCtrl.getSelfList() == null) break;
                Iterator itemDataIter = inputCtrl.getSelfList().iterator();
                suppliedValues = this.buildSupperliedValues(itemDataIter, null, null);
                break;
            }
            case 7: {
                if (inputCtrl.getDefDbsource() == null) break;
                String macroUid = inputCtrl.getDefDbsource().getName();
                String ctrlDefValue = inputCtrl.getDefValue().getName();
                String ctrlDefDisplay = inputCtrl.getDefDisplay().getName();
                suppliedValues = new ArrayList<Entry>();
                ArrayList<String> fieldNames = new ArrayList<String>(2);
                fieldNames.add(ctrlDefValue);
                fieldNames.add(ctrlDefDisplay);
                ExtMacroValue extMacroValue = MacroUtil.loadMacroValuesByFieldNames(this.context, macroUid, fieldNames, -1);
                List<List<Object>> allColumnValues = extMacroValue.getAllColumnValues();
                if (null == allColumnValues) break;
                List<String> allColumnNames = extMacroValue.getAllColumnNames();
                int defValueIndex = -1;
                int defDisplayIndex = -1;
                int len = allColumnNames.size();
                for (int j = 0; j < len; ++j) {
                    String columnName = allColumnNames.get(j);
                    if (ctrlDefValue.equalsIgnoreCase(columnName)) {
                        defValueIndex = j;
                    }
                    if (ctrlDefDisplay.equalsIgnoreCase(columnName)) {
                        defDisplayIndex = j;
                    }
                    if (defValueIndex != -1 && defDisplayIndex != -1) break;
                }
                if (defDisplayIndex == -1) {
                    throw ExtMacroException.newNonFieldMacroException(extMacroValue.getMacroUid(), ctrlDefDisplay);
                }
                if (defValueIndex == -1) {
                    throw ExtMacroException.newNonFieldMacroException(extMacroValue.getMacroUid(), ctrlDefValue);
                }
                if (allColumnValues.isEmpty()) break;
                int rowCount = allColumnValues.get(0).size();
                for (int i = 0; i < rowCount; ++i) {
                    Entry entry = new Entry();
                    entry.setText(String.valueOf(allColumnValues.get(defDisplayIndex).get(i)));
                    entry.setValue(String.valueOf(allColumnValues.get(defValueIndex).get(i)));
                    suppliedValues.add(entry);
                }
                break;
            }
        }
        return suppliedValues;
    }

    private List<Entry> getSupperliedValuesBySystem(IInputCtrl inputCtrl) {
        String displayKey = inputCtrl.getDefDisplay().getName();
        String valueKey = inputCtrl.getDefValue().getName();
        List<Map<String, String>> lst = OrgRangeManage.getOrgRangeList(this.context);
        Iterator<Map<String, String>> itemDataIter = lst.iterator();
        return this.buildSupperliedValues(itemDataIter, valueKey.toLowerCase(), displayKey.toLowerCase());
    }

    private List<Entry> getSupperliedValuesByDB(IInputCtrl inputCtrl, DesignParameter[] relatedParams) throws Exception {
        String displayKey = "alias";
        String valueKey = "value";
        String dataSetType = inputCtrl.getDataSetType();
        boolean isKSQL = !"6".equals(dataSetType);
        DefObj def = inputCtrl.getDefDbsource();
        if (isKSQL) {
            displayKey = inputCtrl.getDefDisplay().getName();
            valueKey = inputCtrl.getDefValue().getName();
        }
        List<Map<String, Object>> result = RunReportParam.getBizDataList(this.context, isKSQL, def, this.sqlDbMap, relatedParams);
        Iterator<Map<String, Object>> itemDataIter = result.iterator();
        return this.buildSupperliedValues(itemDataIter, valueKey.toLowerCase(), displayKey.toLowerCase());
    }

    private List<Entry> buildSupperliedValues(Iterator itemDataIter, String valueKey, String displayKey) {
        ArrayList<Entry> supperliedValues = new ArrayList<Entry>();
        if (itemDataIter == null) {
            return supperliedValues;
        }
        String defName = "";
        String defAlias = "";
        while (itemDataIter.hasNext()) {
            Object dataItem = itemDataIter.next();
            Entry item = null;
            if (dataItem instanceof DefObj) {
                item = this.createItem(((DefObj)dataItem).getName(), ((DefObj)dataItem).getAlias());
            } else if (dataItem instanceof Map && !StringUtils.isEmpty(valueKey)) {
                Map mapItem = (Map)dataItem;
                defName = CtrlReportUtil.getObjectString(mapItem.get(valueKey));
                defAlias = CtrlReportUtil.getObjectString(mapItem.get(displayKey));
                item = this.createItem(defName, defAlias);
            }
            if (null == item) continue;
            supperliedValues.add(item);
        }
        return supperliedValues;
    }

    private Entry createItem(String name, String alias) {
        Entry item = new Entry();
        item.setValue(name);
        item.setText(alias);
        return item;
    }
}

