/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.util;

import com.kingdee.bos.boslayer.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.boslayer.bos.util.BOSUuid;
import com.kingdee.bos.corelayer.ISQLDesignerContext;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.CtrlQuerySolutionInfo;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.KSQLReportInfo;
import com.kingdee.bos.framework.core.util.Messages;
import com.kingdee.bos.report.ds.vo.DesignerVO;
import com.kingdee.cosmic.ctrl.common.datacenter.DataCenterDBType;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;

public class DesignerVOTranslator {
    public static final int FILTERSOLUTION_TYPE = 0;
    public static final int SQLDATASOURCE_TYPE = 1;
    public static final int OUTDBLIST_TYPE = 2;
    public static final int SUBSYSTEM_TYPR = 3;
    public static final int RESULTSSET_TYPE = 4;
    public static final int PERSONE_FOLDER_TYPE = 5;
    public static final int SNAPSHOT_TYPE = 6;
    public static final int METADATA_TYPE = -1;

    public static Object decode(DesignerVO vo) {
        if (vo == null) {
            return null;
        }
        switch (vo.getType()) {
            case 1: {
                KSQLReportInfo info = new KSQLReportInfo();
                info.setName((String)vo.getFieldContent("fname"));
                info.setCustomType(Integer.parseInt((String)vo.getFieldContent("ftype")));
                info.setContent((byte[])vo.getFieldContent("fdatasourcecontent"));
                info.setId(BOSUuid.read((String)vo.getFieldContent("fid")));
                info.setGroupName((String)vo.getFieldContent("groupName"));
                info.setSystemID((String)vo.getFieldContent("systemID"));
                return info;
            }
            case 2: {
                HashMap<String, String> db = new HashMap<String, String>();
                db.put("dbcentername", (String)vo.getFieldContent("dbcentername"));
                db.put("id", (String)vo.getFieldContent("id"));
                String dbtype = (String)vo.getFieldContent("dbtype");
                int i = DataCenterDBType.DataBaseConnecttoDBType((String)dbtype);
                if (i == -1) {
                    return null;
                }
                db.put("dbtype", String.valueOf(i));
                db.put("address", (String)vo.getFieldContent("address"));
                db.put("username", (String)vo.getFieldContent("username"));
                db.put("ownerId", (String)vo.getFieldContent("ownerId"));
                return db;
            }
            case 3: {
                MetaDataBriefInfo node = new MetaDataBriefInfo(vo);
                return node;
            }
        }
        throw new IllegalArgumentException(Messages.getMLS("unrecognizedDataType", "\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u7c7b\u578b"));
    }

    public static DesignerVO encode(ISQLDesignerContext context, Object instance) {
        DesignerVO vo = null;
        if (instance instanceof KSQLReportInfo) {
            KSQLReportInfo info = (KSQLReportInfo)instance;
            vo = new DesignerVO(1);
            BOSUuid uuid = info.getBOSUuid("fid");
            vo.addColumn("fid", uuid == null ? "" : uuid.toString());
            vo.addColumn("fcontrolunitid", "controlUnitId");
            vo.addColumn("fcreatorid", context.getUserID());
            vo.addColumn("fcreatetime", new Date());
            String metaFolderId = context.getMetaFolderId();
            vo.addColumn("ffoldermetaid", StringUtil.isEmptyString((String)metaFolderId) ? info.getString("systemID") : metaFolderId);
            vo.addColumn("ftype", info.getString("customtype"));
            vo.addColumn("fdatasourcecontent", info.getObject("content"));
            vo.addColumn("fisdynamicsql", info.getString("isdynamicsql"));
            vo.addColumn("flastupdaterid", context.getUserID());
            vo.addColumn("fname", info.getString("name"));
        } else if (instance instanceof CtrlQuerySolutionInfo) {
            CtrlQuerySolutionInfo info = (CtrlQuerySolutionInfo)instance;
            vo = new DesignerVO(0);
            if (info.containsKey("whereValue", String.class)) {
                vo.addColumn("ffiltercontent", info.getWhereValue().getBytes(StandardCharsets.UTF_8));
            }
            vo.addColumn("fid", info.getString("uuid"));
            if (info.containsKey("isDefault", Boolean.class)) {
                vo.addColumn("fisdefault", info.isIsDefault() ? "2" : "1");
            }
            if (info.containsKey("name", String.class)) {
                vo.addColumn("fname", info.getName() == null ? Messages.getMLS("defaultScheme", "\u9ed8\u8ba4\u65b9\u6848") : info.getName());
            }
            if (info.containsKey("reportFlag", String.class)) {
                vo.addColumn("freportflag", info.getReportFlag());
            }
            if (info.containsKey("shareType", Integer.class)) {
                vo.addColumn("fsharetype", info.getShareType());
            }
            if (info.containsKey("solutionType", Integer.class)) {
                vo.addColumn("fsolutiontype", info.getSolutionType());
            }
            vo.addColumn("fcreatorid", context.getUserID());
            vo.addColumn("forgid", context.getOrgID());
        }
        return vo;
    }
}

