/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.extreport.formula;

import com.kingdee.bos.extreport.common.model.formual.Catalog;
import com.kingdee.bos.extreport.common.model.formual.FormulaConfig;
import com.kingdee.bos.extreport.common.model.formual.FormulaDef;
import com.kingdee.bos.extreport.common.model.formual.FormulaParam;
import com.kingdee.bos.extreport.formula.AbstractExtReportFunctionProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;

public class FunctionProviderDefinition {
    private static final AtomicLong classSeq = new AtomicLong(0L);
    private static final Map<String, Class> providerClassMap = new HashMap<String, Class>(10);
    private Class providerParentClass;

    public FunctionProviderDefinition(Class providerParentClass) {
        this.providerParentClass = providerParentClass;
    }

    public List<Object> defineFunctionProviderInstance(FormulaConfig[] arrFormulaObjs) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NotFoundException, CannotCompileException {
        ArrayList<Object> allProviders = new ArrayList<Object>();
        for (FormulaConfig fc : arrFormulaObjs) {
            allProviders.addAll(this.defineNewFunctionProvider(fc));
        }
        return allProviders;
    }

    private List<Object> defineNewFunctionProvider(FormulaConfig config) throws CannotCompileException, NotFoundException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        List<FormulaDef> allDefs = config.getFormulaDef();
        List<Catalog> catalogs = config.getCatalogs();
        HashMap formulaCatalogMaps = new HashMap(catalogs.size());
        for (Catalog catalog : catalogs) {
            formulaCatalogMaps.put(catalog.getNumber(), new ArrayList(10));
        }
        for (FormulaDef fd : allDefs) {
            List formulaDefs = (List)formulaCatalogMaps.get(fd.getCatalog());
            if (null == formulaDefs) continue;
            formulaDefs.add(fd);
        }
        ArrayList<Object> providers = new ArrayList<Object>(formulaCatalogMaps.size());
        for (Map.Entry entry : formulaCatalogMaps.entrySet()) {
            String cataLog = (String)entry.getKey();
            List formulaDefs = (List)entry.getValue();
            Class functionProviderClass = this.dynamicCreateFunctionProviderClass(cataLog, formulaDefs);
            AbstractExtReportFunctionProvider provider = (AbstractExtReportFunctionProvider)functionProviderClass.newInstance();
            provider.setFormulaDefList(cataLog, formulaDefs);
            providers.add(provider);
        }
        return providers;
    }

    private Class dynamicCreateFunctionProviderClass(String catalog, List<FormulaDef> formulaDefs) throws CannotCompileException, NotFoundException, ClassNotFoundException {
        Class existedClass = this.getCurrentClassIfExists(catalog, formulaDefs);
        if (null != existedClass) {
            return existedClass;
        }
        String catalogValid = this.removeIllegalChar(catalog);
        String functionProviderClassName = "kd.bos.mservice.extreport.runtime.domain.FunctionProvider" + catalogValid + classSeq.getAndIncrement();
        ClassPool pool = ClassPool.getDefault();
        CtClass funcProviderClass = pool.makeClass(functionProviderClassName);
        for (FormulaDef formulaDef : formulaDefs) {
            String methodName = formulaDef.getNumber();
            List<FormulaParam> params = formulaDef.getParam();
            StringBuilder paramBuilder = new StringBuilder();
            for (FormulaParam fp : params) {
                paramBuilder.append("Object ").append(fp.getNumber().replace(".", "")).append(",");
            }
            if (paramBuilder.length() > 0) {
                paramBuilder.setLength(paramBuilder.length() - 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("public Object ");
            sb.append(methodName);
            sb.append("(");
            String paramStr = paramBuilder.toString();
            sb.append(paramStr);
            sb.append("){ return null;}");
            CtMethod functionMethod = CtMethod.make((String)sb.toString(), (CtClass)funcProviderClass);
            funcProviderClass.addMethod(functionMethod);
        }
        CtClass parentClass = pool.get(this.providerParentClass.getName());
        funcProviderClass.setSuperclass(parentClass);
        Class clazz = funcProviderClass.toClass();
        funcProviderClass.detach();
        this.cacheClass(catalog, clazz);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheClass(String catalog, Class clazz) {
        Map<String, Class> map = providerClassMap;
        synchronized (map) {
            providerClassMap.put(catalog, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class getCurrentClassIfExists(String catalog, List<FormulaDef> formulaDefs) {
        Map<String, Class> map = providerClassMap;
        synchronized (map) {
            Class providerClass = providerClassMap.get(catalog);
            if (null != providerClass) {
                Method[] methods = providerClass.getMethods();
                HashSet<String> methodNames = new HashSet<String>(methods.length);
                for (Method m : methods) {
                    methodNames.add(m.getName());
                }
                for (FormulaDef formulaDef : formulaDefs) {
                    if (methodNames.contains(formulaDef.getNumber())) continue;
                    return null;
                }
                return providerClass;
            }
        }
        return null;
    }

    private String removeIllegalChar(String catalog) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < catalog.length(); ++i) {
            char v = catalog.charAt(i);
            if (!(v >= '0' && v <= '9' || v >= 'A' && v <= 'Z') && (v < 'a' || v > 'z')) continue;
            stringBuilder.append(v);
        }
        return stringBuilder.toString();
    }
}

