/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.extreport.launcher.model;

import com.kingdee.bos.extreport.utils.JsonUtil;
import java.io.Serializable;
import java.util.ArrayList;

public class ExchangeMessage
implements Serializable {
    private static final long serialVersionUID = -7258317412001851512L;
    public static final String COMMAND_HEARTBEAT = "HEARTBEAT";
    public static final String COMMAND_LAUNCH_XLET = "LAUNCH_XLET";
    public static final String COMMAND_DISPOSE_XLET = "DISPOSE_XLET";
    public static final String COMMAND_APP_EXIT = "APP_EXIT";
    public static final String COMMAND_USER_LOGOUT = "USER_LOGOUT";
    public static final String COMMAND_USERACTION_QUESTION = "USERACTION_QUESTION";
    public static final String WEB_COMMAND_REFRESH = "WEB_REFRESH";
    public static final String WEB_COMMAND_CUSTOM_HYPER = "WEB_CUSTOM_HYPER";
    public static final String WEB_COMMAND_BILL_HYPER = "WEB_BILL_HYPER";
    public static final String WEB_COMMAND_PREVIEW_RPT = "WEB_PREVIEW_RPT";
    public static final String WEB_COMMAND_STOP_POLLING = "WEB_STOP_POLLING";
    public static final String WEB_COMMAND_WEB_DATASET_DESIGNER = "WEB_DATASET_DESIGNER";
    public static final String WEB_COMMAND_WEB_DATASET_PREVIEW = "WEB_DATASET_PREVIEW";
    public static final String OP_SUCCESS = "OP_SUCCESS";
    public static final String OP_FAILED = "OP_FAILED";
    private String uuid;
    public String clientId;
    public String command;
    public ArrayList<String> information;
    public ExchangeMessage forward_message;

    public static ExchangeMessage createSuccessReplyMessage(String originUuid, String originClientId, String originCommand) {
        ExchangeMessage em = new ExchangeMessage();
        em.uuid = originUuid;
        em.clientId = originClientId;
        em.command = originCommand;
        ArrayList<String> list = new ArrayList<String>();
        list.add(OP_SUCCESS);
        em.information = list;
        return em;
    }

    public static ExchangeMessage createFailedReplyMessage(String originUuid, String originClientId, String originCommand) {
        ExchangeMessage em = new ExchangeMessage();
        em.uuid = originUuid;
        em.clientId = originClientId;
        em.command = originCommand;
        ArrayList<String> list = new ArrayList<String>();
        list.add(OP_FAILED);
        em.information = list;
        return em;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{COMMAND:");
        buf.append(this.command);
        buf.append("; INFORMATION:");
        buf.append(this.information);
        buf.append('}');
        if (this.forward_message != null) {
            buf.append(" --> ");
            buf.append(this.forward_message);
        }
        return buf.toString();
    }

    public static ExchangeMessage decode(String messageContent) {
        return JsonUtil.decodeFromString(messageContent, ExchangeMessage.class);
    }

    public String packMessage() {
        return JsonUtil.encodeToString(this);
    }
}

