/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.core.util;

import com.kingdee.bos.framework.core.po.IInternational;
import java.util.Locale;

public class LocaleUtil {
    private static ThreadLocal<Locale> local = new ThreadLocal();

    public static void setLocale(String locale) {
        int pos;
        Locale result = null;
        if (locale == null || locale.trim().equals("")) {
            locale = "zh_CN";
        }
        result = (pos = locale.indexOf(95)) > 0 && pos < locale.length() - 1 ? new Locale(locale.substring(0, pos), locale.substring(pos + 1)) : new Locale(locale);
        local.set(result);
    }

    public static Locale getLocale() {
        Locale result = local.get();
        if (result == null) {
            result = new Locale("zh", "CN");
        }
        return result;
    }

    public static String getName(IInternational value) {
        String result = null;
        if (value == null) {
            return result;
        }
        Locale locale = LocaleUtil.getLocale();
        String language = locale.toString();
        result = language.equals("zh_CN") ? value.getChineseName() : (language.equals("en_US") ? value.getEnglishName() : value.getOtherName());
        if (result == null) {
            result = value.getChineseName();
        }
        if (result == null) {
            result = value.getEnglishName();
        }
        if (result == null) {
            result = value.getOtherName();
        }
        return result;
    }

    public static boolean isSame(IInternational src, IInternational target) {
        if (src == null || target == null) {
            return false;
        }
        if (src.getChineseName() != null && !src.getChineseName().equals(target.getChineseName()) || target.getChineseName() != null && !target.getChineseName().equals(src.getChineseName())) {
            return false;
        }
        if (src.getEnglishName() != null && !src.getEnglishName().equals(target.getEnglishName()) || target.getEnglishName() != null && !target.getEnglishName().equals(src.getEnglishName())) {
            return false;
        }
        return (src.getOtherName() == null || src.getOtherName().equals(target.getOtherName())) && (target.getOtherName() == null || target.getOtherName().equals(src.getOtherName()));
    }

    public static void copy(IInternational src, IInternational target) {
        if (src == null || target == null) {
            return;
        }
        target.setChineseName(src.getChineseName());
        target.setEnglishName(src.getEnglishName());
        target.setOtherName(src.getOtherName());
    }
}

