/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.ksql.model;

import com.kingdee.bos.framework.core.vo.KBIVO;
import com.kingdee.bos.framework.ksql.model.KsqlDataType;
import com.kingdee.bos.framework.ksql.model.KsqlMeta;
import java.util.ArrayList;
import java.util.Date;

public class KsqlRowset
extends KBIVO {
    private static final long serialVersionUID = 1L;
    private KsqlMeta meta;
    private ArrayList<ArrayList<Object>> rows;

    public KsqlMeta getMeta() {
        return this.meta;
    }

    public void setMeta(KsqlMeta meta) {
        this.meta = meta;
    }

    public ArrayList<ArrayList<Object>> getRows() {
        return this.rows;
    }

    public void setRows(ArrayList<ArrayList<Object>> rows) {
        this.rows = rows;
    }

    public int getRowsCount() {
        return this.rows == null ? 0 : this.rows.size();
    }

    public int getColsCount() {
        return this.meta == null ? 0 : this.meta.getColumnsCount();
    }

    public String getColName(int index) {
        return this.meta.getColumnName(index);
    }

    public String getColAlia(int index) {
        return this.meta.getColumnAlia(index);
    }

    public boolean isColNameExist(String colName) {
        return this.meta.getColumnIndex(colName) >= 0;
    }

    private int toColIndex(Object col) {
        if (col instanceof Integer) {
            return (Integer)col;
        }
        if (col instanceof String) {
            return this.meta.getColumnIndex((String)col);
        }
        return -1;
    }

    public String getColDataType(Object col) {
        int colIdx = this.toColIndex(col);
        return this.meta.getColumnDataType(colIdx);
    }

    public Object getData(int rowIdx, Object col) {
        int colIdx = this.toColIndex(col);
        return this.rows.get(rowIdx).get(colIdx);
    }

    public String getString(int rowIdx, Object col) {
        Object data = this.getData(rowIdx, col);
        String type = this.getColDataType(col);
        if (type.equals(KsqlDataType.STRING.toString())) {
            return (String)data;
        }
        return data == null ? null : data.toString();
    }

    public int getInt(int rowIdx, Object col) {
        Object data = this.getData(rowIdx, col);
        String type = this.getColDataType(col);
        if (type.equals(KsqlDataType.Number.toString())) {
            return (Integer)data;
        }
        return -1;
    }

    public boolean getBoolean(int rowIdx, Object col) {
        Object data = this.getData(rowIdx, col);
        String type = this.getColDataType(col);
        if (type.equals(KsqlDataType.Bool.toString())) {
            return (Boolean)data;
        }
        return false;
    }

    public Date getDate(int rowIdx, Object col) {
        Object data = this.getData(rowIdx, col);
        String type = this.getColDataType(col);
        if (type.equals(KsqlDataType.Date.toString()) || type.equals(KsqlDataType.DateTime.toString()) || type.equals(KsqlDataType.Time.toString())) {
            return (Date)data;
        }
        return null;
    }
}

