/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.report.ext.service.util;

import com.kingdee.bos.framework.core.util.Messages;
import com.kingdee.bos.report.ext.service.po.ExtDataSetTransModel;
import com.kingdee.bos.report.ext.service.po.ExtParameterTransModel;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.ConstantVariant;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.DataConvert;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class Utilities {
    private static final Logger log = Logger.getLogger(Utilities.class);

    public static Map<String, ExtParameterTransModel> makeParameterTransModelMap(Map<String, IParameter> extParams) {
        HashMap<String, ExtParameterTransModel> transModelMap = new HashMap<String, ExtParameterTransModel>(extParams.size());
        for (Map.Entry<String, IParameter> entry : extParams.entrySet()) {
            IParameter extmodel = entry.getValue();
            ExtParameterTransModel transmodel = new ExtParameterTransModel();
            transmodel.setName(extmodel.getName());
            transmodel.setAlias(extmodel.getAlias());
            transmodel.setDataType(extmodel.getDataType());
            Variant v = extmodel.getValue();
            Variant vNew = Utilities.oringinObject2PlainObject(v.getCopy());
            transmodel.setValue(vNew);
            transmodel.setNullable(extmodel.isNullable());
            transModelMap.put(entry.getKey(), transmodel);
        }
        return transModelMap;
    }

    public static Map<String, IParameter> makeExtParameterMap(Map<String, ExtParameterTransModel> transParams) {
        HashMap<String, IParameter> extParams = new HashMap<String, IParameter>(transParams.size());
        for (Map.Entry<String, ExtParameterTransModel> entry : transParams.entrySet()) {
            extParams.put(entry.getKey(), entry.getValue().toExtParameter());
        }
        return extParams;
    }

    public static void fillWithTransModel(ExtDataSet ds, ExecutionContext execCtx, ExtDataSetTransModel transModel) {
        Utilities.attachParams(execCtx, transModel);
        Utilities.initColumns(ds, transModel);
        if (transModel.getQsRows() <= 0) {
            Utilities.fastFillData(ds, transModel);
        } else {
            ds.clearData();
        }
    }

    private static void fastFillData(ExtDataSet ds, ExtDataSetTransModel transModel) {
        Variant[][] data = transModel.getData();
        if (data == null) {
            MiscUtil.error((String)(Messages.getMLS("datasetServerDataFetchFailed", "\u6570\u636e\u96c6\u670d\u52a1\u7aef\u53d6\u6570\u5931\u8d25\uff1a") + ds.getDefine()));
            return;
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) continue;
            for (int j = 0; j < data[i].length; ++j) {
                if (data[i][j] == null) continue;
                Variant v = data[i][j];
                data[i][j] = Utilities.plainObject2OriginObject(v);
            }
        }
        DataConvert.IDataConvert[] convert = DataConvert.getConvertArray((ExtDataSet)ds);
        Variant[][] datas = data;
        for (int i = 0; i < datas.length; ++i) {
            if (datas[i] == null) continue;
            for (int j = 0; j < datas[i].length; ++j) {
                if (datas[i][j] == null) continue;
                Variant v = datas[i][j];
                datas[i][j] = v == null ? v : convert[j].convertObject(v.getValue());
            }
        }
        ds.setData(data);
        ds.clearQSInfo();
    }

    private static void initColumns(ExtDataSet ds, ExtDataSetTransModel transModel) {
        Map<Integer, Object[]> columnInfo = transModel.getColumnInfo();
        Iterator<Integer> it = columnInfo.keySet().iterator();
        while (it.hasNext()) {
            Object[] info = columnInfo.get(it.next());
            try {
                ExtColumn col = new ExtColumn(ds, (String)info[1], ((Variant)info[2]).intValue(), ((Integer)info[4]).intValue());
                col.setAlias((String)info[0]);
                ds.addColumn(col);
            }
            catch (SyntaxErrorException e) {
                log.error((Object)Messages.getMLS("datasetGenerateColumnSyntaxParsingError", "\u6570\u636e\u96c6\u751f\u6210\u5217\u65f6\u53d1\u751f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff01"), (Throwable)e);
                MiscUtil.debug((String)Messages.getMLS("datasetGenerateColumnSyntaxParsingError", "\u6570\u636e\u96c6\u751f\u6210\u5217\u65f6\u53d1\u751f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff01"));
                MiscUtil.log((Throwable)e);
            }
        }
    }

    private static void attachParams(ExecutionContext execCtx, ExtDataSetTransModel transModel) {
        Map<String, ExtParameterTransModel> exportedParams = transModel.getExportedParams();
        if (exportedParams != null) {
            StringBuilder buff = new StringBuilder();
            Iterator<String> it = exportedParams.keySet().iterator();
            while (it.hasNext()) {
                ExtParameterTransModel trans = exportedParams.get(it.next());
                buff.append('@');
                buff.append(trans.getAlias());
                buff.append(" : ");
                buff.append(trans.getValue());
                buff.append('\n');
            }
            MiscUtil.info((String)buff.toString());
            execCtx.attachDataSetOutputParameters(Utilities.makeExtParameterMap(exportedParams));
        }
    }

    public static Variant oringinObject2PlainObject(Variant v) {
        int variantType = v.getVt();
        if (variantType == 10) {
            if (v.getValue() instanceof BigDecimal) {
                v = new Variant((Object)((BigDecimal)v.getValue()).toPlainString(), variantType);
            }
            if (v.getValue() instanceof String) {
                return v;
            }
        } else if (variantType == 9) {
            if (v.getValue() instanceof BigInteger) {
                v = new Variant((Object)((BigInteger)v.getValue()).toString(), variantType);
            }
            if (v.getValue() instanceof String) {
                return v;
            }
        } else if (variantType == 512) {
            Variant[] values = (Variant[])v.getValue();
            if (values != null) {
                Variant[] newValues = new Variant[values.length];
                for (int i = 0; i < values.length; ++i) {
                    newValues[i] = Utilities.oringinObject2PlainObject(values[i]);
                }
                v = new Variant((Object)newValues, variantType);
            }
        } else if (variantType == 15) {
            Variant value = (Variant)v.getValue();
            value = Utilities.oringinObject2PlainObject(value);
            v = new Variant((Object)value, variantType);
        } else if (v instanceof ConstantVariant) {
            return new Variant(v.getValue(), v.getVt());
        }
        return v;
    }

    public static Variant plainObject2OriginObject(Variant v) {
        int variantType = v.getVt();
        if (variantType == 10) {
            if (v.getValue() instanceof String) {
                v = new Variant((Object)new BigDecimal(String.valueOf(v.getValue())), variantType);
            }
        } else if (variantType == 9) {
            if (v.getValue() instanceof String) {
                v = new Variant((Object)new BigInteger(String.valueOf(v.getValue())), variantType);
            }
        } else if (variantType == 512) {
            Variant[] values = (Variant[])v.getValue();
            if (values != null) {
                Variant[] newValues = new Variant[values.length];
                for (int i = 0; i < values.length; ++i) {
                    newValues[i] = Utilities.plainObject2OriginObject(values[i]);
                }
                v = new Variant((Object)newValues, variantType);
            }
        } else if (variantType == 15) {
            Variant value = (Variant)v.getValue();
            value = Utilities.plainObject2OriginObject(value);
            v = new Variant((Object)value, variantType);
        }
        return v;
    }
}

