/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.i18n;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.i18n.DefaultI18nContext;
import com.kingdee.cosmic.ctrl.common.i18n.remote.LangProviderFactory;
import java.util.Locale;

public class CtrlCommonMessages {
    private static final String RESOURCES_PATH = "resources/Ctrl-Common";
    private static final String PROJECT = "Ctrl-Common";

    public static final String getMLS(String key, String defaultInfo) {
        QingContext qingContext = QingContext.getCurrent();
        if (qingContext != null) {
            return qingContext.getIi18nContext().getLanManager().getLangMessage(key, RESOURCES_PATH, defaultInfo);
        }
        Locale locale = Locale.getDefault();
        DefaultI18nContext i18nContext = new DefaultI18nContext(locale);
        String language = locale.getLanguage();
        if (Locale.CHINA.getLanguage().equals(language) || Locale.TAIWAN.getLanguage().equals(language) || Locale.US.getLanguage().equals(language)) {
            return i18nContext.getLanManager().getLangMessage(key, RESOURCES_PATH, defaultInfo);
        }
        return LangProviderFactory.getMLS(key, defaultInfo, PROJECT, locale);
    }

    public static final String getMLS(String key, String defaultInfo, String resourceName) {
        QingContext qingContext = QingContext.getCurrent();
        if (qingContext != null) {
            return qingContext.getIi18nContext().getLanManager().getLangMessage(key, resourceName, defaultInfo);
        }
        Locale locale = Locale.getDefault();
        DefaultI18nContext i18nContext = new DefaultI18nContext(locale);
        String language = locale.getLanguage();
        if (Locale.CHINA.getLanguage().equals(language) || Locale.TAIWAN.getLanguage().equals(language) || Locale.US.getLanguage().equals(language)) {
            return i18nContext.getLanManager().getLangMessage(key, resourceName, defaultInfo);
        }
        String project = "";
        int slashIndex = resourceName.indexOf(47);
        if (slashIndex != -1) {
            project = resourceName.substring(slashIndex + 1);
        }
        return LangProviderFactory.getMLS(key, defaultInfo, project, locale);
    }

    public static enum ProjectName {
        CTRL_EXT("resources/Ctrl-EXT");

        public final String value;

        private ProjectName(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

