/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.i18n.remote;

import com.kingdee.cosmic.ctrl.common.i18n.remote.ILangProviderProxy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class LangProviderFactory {
    private static Map<String, Properties> langMap = new HashMap<String, Properties>(100);
    private static ILangProviderProxy langProvider;

    public static void regist(ILangProviderProxy provider) {
        langProvider = provider;
    }

    public static ILangProviderProxy getLangProvider() {
        return langProvider;
    }

    public static String getMLS(String key, String defaultInfo, String project, Locale locale) {
        Properties prop = langMap.get(LangProviderFactory.getCacheKey(project, locale));
        if (prop == null) {
            prop = new Properties();
            langMap.put(LangProviderFactory.getCacheKey(project, locale), prop);
            ILangProviderProxy langProvider = LangProviderFactory.getLangProvider();
            if (langProvider == null) {
                return LangProviderFactory.getDefaultInfo(key, defaultInfo, project);
            }
            Map<String, String> result = langProvider.getLang(project);
            if (result != null && !result.isEmpty()) {
                result.forEach(prop::setProperty);
                langMap.put(LangProviderFactory.getCacheKey(project, locale), prop);
            } else {
                return LangProviderFactory.getDefaultInfo(key, defaultInfo, project);
            }
        }
        if (prop.isEmpty() || prop.get(key) == null) {
            return LangProviderFactory.getDefaultInfo(key, defaultInfo, project);
        }
        return prop.getProperty(key, defaultInfo);
    }

    private static String getDefaultInfo(String key, String defaultInfo, String project) {
        ResourceBundle bundle = ResourceBundle.getBundle("resources/" + project, Locale.US);
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (Exception e) {
                return defaultInfo;
            }
        }
        return defaultInfo;
    }

    private static String getCacheKey(String project, Locale locale) {
        return project + "_" + locale;
    }
}

