/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.layout.table2;

public final class CellOccupied {
    private int fromRow;
    private int toRow;
    private int fromCol;
    private int toCol;

    public CellOccupied(int fromRow, int fromCol, int toRow, int toCol) {
        if (fromRow > toRow) {
            fromRow += toRow;
            toRow = fromRow - toRow;
            fromRow -= toRow;
        }
        if (fromCol > toCol) {
            fromCol += toCol;
            toCol = fromCol - toCol;
            fromCol -= toCol;
        }
        this.fromRow = fromRow;
        this.toRow = toRow;
        this.fromCol = fromCol;
        this.toCol = toCol;
    }

    public CellOccupied(int row, int col) {
        this(row, col, row, col);
    }

    public int getFromRow() {
        return this.fromRow;
    }

    public int getToRow() {
        return this.toRow;
    }

    public int getFromCol() {
        return this.fromCol;
    }

    public int getToCol() {
        return this.toCol;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.fromRow);
        sb.append(',');
        sb.append(this.fromCol);
        if (this.fromRow != this.toRow || this.fromCol != this.toCol) {
            sb.append("->");
            sb.append(this.toRow);
            sb.append(',');
            sb.append(this.toCol);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CellOccupied) {
            CellOccupied another = (CellOccupied)obj;
            return another.fromRow == this.fromRow && another.fromCol == this.fromCol && another.toRow == this.toRow && another.toCol == this.toCol;
        }
        return false;
    }

    public int hashCode() {
        int result = this.fromRow * 100;
        result += this.toRow * 100;
        result += this.fromCol * 100;
        return result += this.toCol * 100;
    }
}

