/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.restype.def;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.restype.NamedObjectList;
import com.kingdee.cosmic.ctrl.common.restype.def.ActionDef;
import com.kingdee.cosmic.ctrl.common.restype.def.ActionGroupDef;
import com.kingdee.cosmic.ctrl.common.restype.def.ResTypeDefs;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ResTypeDef
implements Serializable {
    private static final Logger log = LogUtil.getPackageLogger(ResTypeDef.class);
    private String name;
    protected HashMap properties = new HashMap();
    private ActionDefs actionDefs;
    private ActionGroupDefs actionGroups;
    private String extendTypeNames;
    private List extendTypes;
    private ResTypeDefs internalTypes;
    private ResTypeDefs externalTypes;

    public String getExtendTypeNames() {
        return this.extendTypeNames;
    }

    public void setExtendTypeNames(String extendTypeNames) {
        this.extendTypeNames = extendTypeNames;
    }

    public boolean isRootType() {
        return true;
    }

    public ActionDefs getActionDefs() {
        return this.actionDefs;
    }

    public void setActionDefs(ActionDefs actionDefs) {
        this.actionDefs = actionDefs;
    }

    public ResTypeDef() {
    }

    public ResTypeDef(String name) {
        this.setName(name);
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap properties) {
        this.properties = properties;
    }

    public List getExtendTypes() {
        return this.extendTypes;
    }

    public void setExtendTypes(List childrenResNode) {
        this.extendTypes = childrenResNode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResTypeDefs getInternalTypes() {
        return this.internalTypes;
    }

    public void setInternalTypes(ResTypeDefs privateTypes) {
        this.internalTypes = privateTypes;
    }

    public String toString() {
        List extendTypes = this.getExtendTypes();
        if (extendTypes != null) {
            return "ResTypeDef" + this.hashCode() + "@" + this.name + "[" + this.extendTypeNames + "]";
        }
        return "ResTypeDef" + this.hashCode() + "@" + this.name;
    }

    public ResTypeDefs getExternalTypes() {
        return this.externalTypes;
    }

    public void setExternalTypes(ResTypeDefs externalTypes) {
        this.externalTypes = externalTypes;
    }

    public ActionGroupDefs getActionGroups() {
        return this.actionGroups;
    }

    public void setActionGroups(ActionGroupDefs actionGroups) {
        this.actionGroups = actionGroups;
    }

    public void solveActionGroups() {
        Iterator i = this.getActionDefs().iterator();
        while (i.hasNext()) {
            ActionDef def = (ActionDef)i.next();
            if (def.getActionGroupName() == null) continue;
            if (this.actionGroups != null) {
                def.setActionGroupDef(this.actionGroups.get(def.getActionGroupName()));
            }
            if (def.getActionGroupDef() != null) continue;
            throw new UnsupportedOperationException(CtrlCommonMessages.getMLS("todoHaveUndeclaredActionGroup", "TODO-\u6709\u4e00\u4e2a\u672a\u58f0\u660e\u7684actionGroup:") + def.getActionGroupName());
        }
    }

    public final Object getProperty(String name) {
        return this.properties == null ? null : this.properties.get(name);
    }

    public Object sortProperty(String resourcePackage) {
        Object goal = this.properties.get("path");
        if (goal != null) {
            return goal;
        }
        goal = this.getProperty(resourcePackage);
        if (goal != null) {
            this.properties.put("path", goal);
            return goal;
        }
        ArrayList fathers = new ArrayList();
        for (int i = 0; i < this.extendTypes.size(); ++i) {
            fathers.add(this.extendTypes.get(i));
        }
        while (!fathers.isEmpty()) {
            Object cao = fathers.remove(0);
            ResTypeDef father = (ResTypeDef)cao;
            ArrayList grandfather = (ArrayList)father.getExtendTypes();
            if (grandfather != null) {
                for (int i = 0; i < grandfather.size(); ++i) {
                    fathers.add(grandfather.get(i));
                }
            }
            if ((goal = father.getProperty(resourcePackage)) == null) continue;
            return goal;
        }
        return goal;
    }

    public final boolean noAction() {
        return this.actionDefs == null || !this.actionDefs.iterator().hasNext();
    }

    public final boolean isSingleInhirt() {
        return this.extendTypes != null && this.extendTypes.size() == 1;
    }

    public static class ActionGroupDefs
    implements Serializable {
        private NamedObjectList defs = new NamedObjectList();

        public ActionGroupDef add(ActionGroupDef actionGroupDef) {
            return (ActionGroupDef)this.defs.add(actionGroupDef);
        }

        public ActionGroupDef get(String name) {
            return (ActionGroupDef)this.defs.get(name);
        }

        public ActionGroupDef remove(String name) {
            return (ActionGroupDef)this.defs.remove(name);
        }

        public Iterator iterator() {
            return this.defs.iterator();
        }
    }

    public static class ActionDefs
    implements Serializable {
        private NamedObjectList defs = new NamedObjectList();

        public ActionDef add(ActionDef actionDef) {
            return (ActionDef)this.defs.add(actionDef);
        }

        public ActionDef get(String name) {
            return (ActionDef)this.defs.get(name);
        }

        public ActionDef remove(String name) {
            return (ActionDef)this.defs.remove(name);
        }

        public Iterator iterator() {
            return this.defs.iterator();
        }
    }
}

