/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.tool;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class BenchmarkTimer {
    private static Logger logger = Logger.getLogger(BenchmarkTimer.class);
    private static final BenchmarkTimer self = new BenchmarkTimer();
    private boolean enable = false;
    private Map tMap = new Hashtable();

    public static void enable(boolean b) {
        BenchmarkTimer.self.enable = b;
    }

    public static void startTime(String keyDesc) {
        if (BenchmarkTimer.self.enable) {
            Thread t = Thread.currentThread();
            if (BenchmarkTimer.self.tMap.get(t) != null) {
                ThreadTimeItem ti = (ThreadTimeItem)BenchmarkTimer.self.tMap.get(t);
                ti.addItem(keyDesc, System.currentTimeMillis());
            } else {
                ThreadTimeItem ti = new ThreadTimeItem();
                ti.addItem(keyDesc, System.currentTimeMillis());
                BenchmarkTimer.self.tMap.put(t, ti);
            }
        }
    }

    public static void stopTime() {
        Thread t;
        if (BenchmarkTimer.self.enable && BenchmarkTimer.self.tMap.get(t = Thread.currentThread()) != null) {
            ThreadTimeItem ti = (ThreadTimeItem)BenchmarkTimer.self.tMap.get(t);
            ThreadTimeItem.Item item = ti.stopItem();
            item.printTimeInfo(t);
            if (ti.size() == 0) {
                BenchmarkTimer.self.tMap.remove(t);
            }
        }
    }

    public static void main(String[] args) {
        BenchmarkTimer.enable(true);
        new Thread(){

            @Override
            public void run() {
                class A {
                    A() {
                    }

                    void test1(long sleep) {
                        BenchmarkTimer.startTime("test1-" + sleep);
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        BenchmarkTimer.stopTime();
                    }

                    void test2() {
                        BenchmarkTimer.startTime("test2");
                        for (int i = 0; i < 1000000; ++i) {
                            if (i % 13 != 0) continue;
                        }
                        BenchmarkTimer.stopTime();
                    }
                }
                A a = new A();
                a.test1(100L);
                a.test2();
            }
        }.start();
        A a = new A();
        a.test1(400L);
        a.test2();
    }

    static class ThreadTimeItem {
        Stack stack = new Stack();

        ThreadTimeItem() {
        }

        public Item stopItem() {
            Item item = (Item)this.stack.pop();
            item.t = System.currentTimeMillis();
            return item;
        }

        public void addItem(String keyDesc, long s) {
            Item item = new Item();
            item.keyDesc = keyDesc;
            item.s = s;
            this.stack.push(item);
        }

        public int size() {
            return this.stack.size();
        }

        static class Item {
            private static final ThreadLocal<DateFormat> sdf = new ThreadLocal<DateFormat>(){

                @Override
                protected DateFormat initialValue() {
                    return new SimpleDateFormat("HH:mm:ss.ms");
                }
            };
            String keyDesc;
            long s;
            long t;

            Item() {
            }

            public void printTimeInfo(Thread thread) {
                logger.debug((Object)("[BenchmarkTimer] begin=" + this.getFormatedDateString(this.s) + " used=" + (this.t - this.s) + "ms\tDesc:" + this.keyDesc + " \t[Thread:" + thread.getName() + "]"));
            }

            private String getFormatedDateString(long l) {
                return sdf.get().format(new Date(l));
            }
        }
    }
}

