/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.tool;

import com.kingdee.cosmic.ctrl.common.tool.EventTest;
import com.kingdee.cosmic.ctrl.common.tool.Monitor;
import com.kingdee.cosmic.ctrl.common.tool.Params;
import com.kingdee.cosmic.ctrl.common.tool.Util;
import java.util.HashMap;
import java.util.Map;

class TestGenerator
implements Params {
    private static final String CODE_CREATE_MONITOR_COMMENT = "// create monitor";
    private static final String CODE_CREATE_MONITOR = "Monitor ${monitor_instance} = new Monitor();";
    private static final String CODE_REGISTER_LISTENER_COMMENT = "// register listener";
    private static final String CODE_CREATE_LISTENER = "${listener_name} ${listener_instance} = new ${listener_title}();";
    private static final String CODE_REGISTER_LISTENER = "${listener_instance} = (${listener_name}) ${monitor_instance}.register(${listener_instance});";
    private static final String CODE_ADD_LISTENER_COMMENT = "// add listener";
    private static final String CODE_ADD_LISTENER = "${master_instance}.${method_name}(${listener_instance});";
    private static final String CODE_TEST_TODO = "// TODO: add test code here...";
    private static final String CODE_INIT_TODO = "// TODO: add test code here...";
    private static final String CODE_EDIT_SCHEDULE_COMMENT = "// edit schedule";
    private static final String CODE_EDIT_SCHEDULE = "${monitor_instance}.addItem(${listener_instance}, \"${method_name}\");";
    private static final String CODE_CHECK_RESULT_COMMENT = "// check result";
    private static final String CODE_CHECK_RESULT = "${monitor_instance}.printSchedule();";
    private static final String CODE_CHECK_RESULT_TODO = "// TODO: add check result code here... e.g.:\n// assertTrue(${monitor_instance}.checkAllFired());";
    private static final String CODE_CLEAN_MONITOR_COMMENT = "// clean monitor";
    private static final String CODE_CLEAN_MONITOR = "${monitor_instance}.clean();";
    private static final String CODE_TEST_CLASS_BEGIN = "public class ${test_name} {\n\t";
    private static final String CODE_BLACK_CLASS_BEGIN = "public class ${class} extends ${super} {\n\t";
    private static final String CODE_CLASS_END = "\n}";
    private static final String CODE_TEST_MAIN = "public static void main(String arg[]) {\n\t${test_name} test = new ${test_name}();\n\ttest.testEvent();\n}";
    private static final String CODE_BLACK_MAIN = "public static void main(String arg[]) {\n\trun(${class}.class);\n}\n";
    private static final String CODE_TEST_FOO_BEGIN = "final public void ${method_name}() {\n\t";
    private static final String CODE_FOO_END = "\n}";
    private static final String CODE_INIT_FOO_BEGIN = "protected void ${method_name}() {\n\t";
    private static final String TEST_FUNCTION_NAME = "testEvent";
    private static final String INIT_FUNCTION_NAME = "initEvents";
    private Map listeners = new HashMap();
    private String master = "master";
    private String monitor = "monitor";
    private String listener = "listener";
    private StringBuffer scheCode = new StringBuffer();
    private StringBuffer regCode = new StringBuffer();
    private StringBuffer addListenerCode = new StringBuffer();
    private boolean initial = false;
    private static final int INIT_FOO = 0;
    private static final int TEST_FOO = 1;

    TestGenerator() {
    }

    private void writeRegister(String listenerName, String listenerImp, String addMethod) {
        this.listener = this.getListenerInstance();
        StringBuffer sb = new StringBuffer(CODE_CREATE_LISTENER);
        sb.append('\n');
        sb.append(CODE_REGISTER_LISTENER);
        Util.replace(sb, "${listener_name}", listenerName);
        Util.replace(sb, "${listener_title}", listenerImp);
        Util.replace(sb, "${monitor_instance}", this.monitor);
        Util.replace(sb, "${listener_instance}", this.listener);
        if (this.regCode.length() == 0) {
            this.regCode.append(CODE_REGISTER_LISTENER_COMMENT);
        }
        this.regCode.append('\n');
        this.regCode.append(sb);
        sb = new StringBuffer(CODE_ADD_LISTENER);
        Util.replace(sb, "${master_instance}", this.master);
        Util.replace(sb, "${method_name}", addMethod);
        Util.replace(sb, "${listener_instance}", this.listener);
        if (this.addListenerCode.length() == 0) {
            this.addListenerCode.append(CODE_ADD_LISTENER_COMMENT);
        }
        this.addListenerCode.append('\n');
        this.addListenerCode.append(sb);
    }

    private void writeSchedule(String method) {
        StringBuffer sb = new StringBuffer(CODE_EDIT_SCHEDULE);
        Util.replace(sb, "${monitor_instance}", this.monitor);
        Util.replace(sb, "${listener_instance}", this.listener);
        Util.replace(sb, "${method_name}", method);
        if (this.scheCode.length() == 0) {
            this.scheCode.append(CODE_EDIT_SCHEDULE_COMMENT);
        }
        this.scheCode.append('\n');
        this.scheCode.append(sb);
    }

    void addTest(String listenerName, String listenerImp, String[] methodNames, String addMethodName) {
        this.maybeInit();
        this.writeRegister(listenerName, listenerImp, addMethodName);
        for (int i = 0; i < methodNames.length; ++i) {
            this.writeSchedule(methodNames[i]);
        }
    }

    private void maybeInit() {
        if (this.initial) {
            return;
        }
        this.master = this.getMasterInstance();
        this.monitor = this.getMonitorInstance();
        this.initial = true;
    }

    private String getMonitorInstance() {
        return "monitor";
    }

    private String getMasterInstance() {
        return "master";
    }

    private String getListenerInstance() {
        String title = "listener";
        int index = 1;
        String key = title;
        while (this.listeners.containsKey(key)) {
            key = title + index;
            ++index;
        }
        this.listeners.put(key, null);
        return key;
    }

    public String getTestCode(String testClassName) {
        return this.getTestClass(testClassName).toString();
    }

    StringBuffer getBlackClass(Class cls, String className) {
        StringBuffer body = new StringBuffer();
        StringBuffer temp = null;
        body.append("\n/** master */\n");
        temp = Util.declareObject(cls.getName(), this.master);
        body.append(temp);
        body.append('\n');
        temp = new StringBuffer("public ${class}() {\n\tadd(master);\n}\n");
        Util.replace(temp, "${class}", className);
        body.append('\n');
        body.append(temp);
        temp = new StringBuffer(CODE_BLACK_MAIN);
        Util.replace(temp, "${class}", className);
        body.append('\n');
        body.append(temp);
        temp = new StringBuffer("protected void initMaster() {\n\tmaster = new ${class}();\n}\n");
        Util.replace(temp, "${class}", cls.getName());
        body.append('\n');
        body.append(temp);
        temp = this.getFoo(INIT_FUNCTION_NAME, 0);
        body.append('\n');
        body.append(temp);
        Util.tab(body);
        temp = new StringBuffer(CODE_BLACK_CLASS_BEGIN);
        Util.replace(temp, "${class}", className);
        Util.replace(temp, "${super}", "EventTest");
        temp.append(body);
        temp.append("\n}");
        body = this.importClass(EventTest.class);
        body.append('\n');
        body.append("/** @exclude */\n");
        body.append(temp);
        return body;
    }

    StringBuffer getTestClass(String testClassName) {
        StringBuffer body = new StringBuffer(CODE_TEST_MAIN);
        Util.replace(body, "${test_name}", testClassName);
        body.append('\n');
        body.append('\n');
        body.append(this.getFoo(TEST_FUNCTION_NAME, 1));
        Util.tab(body);
        StringBuffer testClass = new StringBuffer(CODE_TEST_CLASS_BEGIN);
        Util.replace(testClass, "${test_name}", testClassName);
        testClass.append(body);
        testClass.append("\n}");
        StringBuffer sb = this.importClass(Monitor.class);
        sb.append('\n');
        sb.append("/** @exclude */\n");
        sb.append(testClass);
        return sb;
    }

    private StringBuffer importClass(Class cls) {
        String className = cls.getName();
        StringBuffer sb = new StringBuffer("import ");
        sb.append(className);
        sb.append(";\n");
        return sb;
    }

    private StringBuffer getFoo(String functionName, int type) {
        StringBuffer body = new StringBuffer();
        StringBuffer sb = null;
        if (type == 1) {
            body = this.integrateTest();
            sb = new StringBuffer(CODE_TEST_FOO_BEGIN);
        } else if (type == 0) {
            body = this.integrateInit();
            sb = new StringBuffer(CODE_INIT_FOO_BEGIN);
        } else {
            sb = new StringBuffer();
        }
        Util.replace(sb, "${method_name}", functionName);
        Util.tab(body);
        sb.append(body);
        sb.append("\n}");
        return sb;
    }

    private StringBuffer integrateTest() {
        StringBuffer sb = new StringBuffer(CODE_CREATE_MONITOR_COMMENT);
        StringBuffer temp = new StringBuffer(CODE_CREATE_MONITOR);
        Util.replace(temp, "${monitor_instance}", this.monitor);
        sb.append('\n');
        sb.append(temp);
        if (this.regCode.length() > 0) {
            sb.append('\n');
            sb.append('\n');
            sb.append(this.regCode);
        }
        if (this.scheCode.length() > 0) {
            sb.append('\n');
            sb.append('\n');
            sb.append(this.scheCode);
        }
        sb.append('\n');
        sb.append('\n');
        sb.append("// TODO: add test code here...");
        sb.append('\n');
        sb.append('\n');
        sb.append('\n');
        sb.append(CODE_CHECK_RESULT_COMMENT);
        temp = new StringBuffer(CODE_CHECK_RESULT);
        Util.replace(temp, "${monitor_instance}", this.monitor);
        sb.append('\n');
        sb.append(temp);
        temp = new StringBuffer(CODE_CHECK_RESULT_TODO);
        Util.replace(temp, "${monitor_instance}", this.monitor);
        sb.append('\n');
        sb.append(temp);
        temp = new StringBuffer(CODE_CLEAN_MONITOR);
        Util.replace(temp, "${monitor_instance}", this.monitor);
        sb.append('\n');
        sb.append('\n');
        sb.append(CODE_CLEAN_MONITOR_COMMENT);
        sb.append('\n');
        sb.append(temp);
        return sb;
    }

    private StringBuffer integrateInit() {
        StringBuffer sb = new StringBuffer();
        if (this.regCode.length() > 0) {
            if (sb.length() > 0) {
                sb.append('\n');
                sb.append('\n');
            }
            sb.append(this.regCode);
        }
        if (this.scheCode.length() > 0) {
            if (sb.length() > 0) {
                sb.append('\n');
                sb.append('\n');
            }
            sb.append(this.scheCode);
        }
        if (this.addListenerCode.length() > 0) {
            if (sb.length() > 0) {
                sb.append('\n');
                sb.append('\n');
            }
            sb.append(this.addListenerCode);
        }
        if (sb.length() > 0) {
            sb.append('\n');
            sb.append('\n');
        }
        sb.append("// TODO: add test code here...");
        sb.append('\n');
        return sb;
    }
}

