/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Objects;

public class ArrayUtil {
    public static int getLength(Object[] objs) {
        int i;
        for (i = 0; i < objs.length && objs[i] != null; ++i) {
        }
        return i;
    }

    public static int getCount(Object[] objs) {
        int count = 0;
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            ++count;
        }
        return count;
    }

    public static final boolean hasSameElements(Object[] objs0, Object[] objs1) {
        if (objs0 == objs1) {
            return true;
        }
        if (objs1 != null && objs0 != null && objs0.length == objs1.length) {
            int i;
            int len = objs0.length;
            boolean[] found_map = new boolean[len];
            for (i = 0; i < len; ++i) {
                found_map[i] = false;
            }
            for (i = 0; i < len; ++i) {
                int j;
                for (j = 0; j < len && (found_map[j] || !(found_map[j] = objs0[i].equals(objs1[j]))); ++j) {
                }
                if (j != len) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final Object[] removeElement(Object[] objs, Object obj) {
        ArrayList<Object> list = new ArrayList<Object>(objs.length);
        for (int i = 0; i < objs.length; ++i) {
            if (obj == objs[i]) continue;
            list.add(objs[i]);
        }
        if (list.size() == objs.length) {
            return objs;
        }
        Object[] array = (Object[])Array.newInstance(objs.getClass().getComponentType(), list.size());
        return list.toArray(array);
    }

    public static final int[] removeElement(int[] array, int index) {
        if (index < 0 || index >= array.length) {
            throw new IndexOutOfBoundsException("Bad parameter for delete column.");
        }
        int[] t_array = new int[array.length - 1];
        if (t_array.length != 0) {
            System.arraycopy(array, 0, t_array, 0, index);
            System.arraycopy(array, index + 1, t_array, index, t_array.length - index);
        }
        return t_array;
    }

    public static final Object[] removeElement(Object[] array, int index) {
        if (index < 0 || index >= array.length) {
            throw new IndexOutOfBoundsException("Bad parameter for delete column.");
        }
        Object[] t_array = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        if (t_array.length != 0) {
            System.arraycopy(array, 0, t_array, 0, index);
            System.arraycopy(array, index + 1, t_array, index, t_array.length - index);
        }
        return t_array;
    }

    public static final Object[] insertElement(Object[] array, int index, Object val) {
        if (index < 0 || index > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object[] t_array = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, t_array, 0, index);
        t_array[index] = val;
        if (index != array.length) {
            System.arraycopy(array, index, t_array, index + 1, t_array.length - index - 1);
        }
        return t_array;
    }

    public static final int[] insertElement(int[] array, int index, int val) {
        if (index < 0 || index > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] t_array = new int[array.length + 1];
        System.arraycopy(array, 0, t_array, 0, index);
        t_array[index] = val;
        if (index != array.length) {
            System.arraycopy(array, index, t_array, index + 1, t_array.length - index - 1);
        }
        return t_array;
    }

    public static final int[] removeUniqueElement(int[] a, int key) {
        if (a == null) {
            return null;
        }
        int index = -1;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != key) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return a;
        }
        int[] newA = new int[a.length - 1];
        if (newA.length != 0) {
            System.arraycopy(a, 0, newA, 0, index);
            System.arraycopy(a, index + 1, newA, index, newA.length - index);
        }
        return newA;
    }

    public static final boolean containElement(Object[] objs, Object element) {
        return ArrayUtil.findElement(objs, element, -1) != -1;
    }

    public static final int findElement(Object[] objs, Object element, int expect) {
        if (objs == null) {
            return -1;
        }
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] != element && (objs[i] == null || !objs[i].equals(element)) || expect == i) continue;
            return i;
        }
        return -1;
    }

    public static final int findStringElement(String[] objs, String element, int expect, boolean ignoreCase) {
        if (objs == null) {
            return -1;
        }
        for (int i = 0; i < objs.length; ++i) {
            if (!Objects.equals(objs[i], element) && (!ignoreCase || !objs[i].equalsIgnoreCase(element)) || expect == i) continue;
            return i;
        }
        return -1;
    }

    public static final boolean difference(Object[] objs0, Object[] objs1, ArrayList missing, ArrayList additional) {
        int i;
        if (objs0 == objs1) {
            return true;
        }
        Object[] rObjs0 = objs0 == null ? new Object[]{} : objs0;
        Object[] rObjs1 = objs1 == null ? new Object[]{} : objs1;
        int[] index1 = new int[rObjs1.length];
        for (i = 0; i < rObjs1.length; ++i) {
            index1[i] = i;
        }
        for (i = 0; i < rObjs0.length; ++i) {
            boolean found = false;
            for (int j = 0; j < rObjs1.length; ++j) {
                if (rObjs0[i] != rObjs1[j]) continue;
                found = true;
                index1[j] = -1;
                break;
            }
            if (found) continue;
            additional.add(rObjs0[i]);
        }
        for (i = 0; i < rObjs1.length; ++i) {
            if (index1[i] == -1) continue;
            missing.add(rObjs1[i]);
        }
        return missing.size() == 0 && additional.size() == 0;
    }

    public static final String objectArray2String(Object[] objs, String split) {
        if (objs == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < objs.length; ++i) {
            buffer.append(objs[i] == null ? "null" : objs[i].toString());
            buffer.append(split);
        }
        if (buffer.length() > 0) {
            return buffer.substring(0, buffer.length() - split.length());
        }
        return buffer.toString();
    }

    public static final String byteArray2String(byte[] t, String split) {
        if (t == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < t.length; ++i) {
            s.append(t[i]);
            s.append(split);
        }
        if (s.length() > 0) {
            return s.substring(0, s.length() - split.length());
        }
        return s.toString();
    }

    public static final String intArray2String(int[] t, String split) {
        if (t == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < t.length; ++i) {
            s.append(t[i]);
            s.append(split);
        }
        if (s.length() > 0) {
            return s.substring(0, s.length() - split.length());
        }
        return s.toString();
    }

    public static final ArrayList objects2ArrayList(Object[] objs) {
        ArrayList<Object> al = new ArrayList<Object>();
        if (objs != null) {
            for (int i = 0; i < objs.length; ++i) {
                al.add(objs[i]);
            }
        }
        return al;
    }

    public static final Object[] copyGenericArray(Object[] array) {
        Object[] copy = new Object[array.length];
        System.arraycopy(array, 0, copy, 0, copy.length);
        return copy;
    }

    public static final void clearArray(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = null;
        }
    }

    public static final byte[] addByteArray(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static boolean isEqual(Double d1, Double d2) {
        return Math.abs(d1 - d2) < 1.0E-6;
    }

    public static boolean isEqual(Float f1, Float f2) {
        return (double)Math.abs(f1.floatValue() - f2.floatValue()) < 1.0E-6;
    }
}

