/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import java.awt.Color;
import java.util.Locale;

public class ColorUtil {
    public static Color parseColor(String strColor) {
        Color color = null;
        if (!strColor.startsWith("#")) {
            strColor = "#" + strColor;
        }
        try {
            String strR = strColor.substring(1, 3);
            String strG = strColor.substring(3, 5);
            String strB = strColor.substring(5, 7);
            if (strColor.length() > 7) {
                String strA = strColor.substring(7);
                color = new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16), Integer.parseInt(strA));
            } else {
                color = new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16));
            }
        }
        catch (Exception err) {
            throw new IllegalArgumentException(CtrlCommonMessages.getMLS("inputColorExpressionInvalid", "\u8f93\u5165\u7684\u989c\u8272\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff0c\u6b63\u786e\u683c\u5f0f\u5982\uff1a") + "#00ff99", err);
        }
        return color;
    }

    public static String colorToHexStr(Color color) {
        StringBuilder colorstr = new StringBuilder("#");
        String str = Integer.toHexString(color.getRed());
        if (str.length() > 2) {
            colorstr.append(str.substring(0, 2));
        } else if (str.length() < 2) {
            colorstr.append('0').append(str);
        } else {
            colorstr.append(str);
        }
        str = Integer.toHexString(color.getGreen());
        if (str.length() > 2) {
            colorstr.append(str.substring(0, 2));
        } else if (str.length() < 2) {
            colorstr.append('0').append(str);
        } else {
            colorstr.append(str);
        }
        str = Integer.toHexString(color.getBlue());
        if (str.length() > 2) {
            colorstr.append(str.substring(0, 2));
        } else if (str.length() < 2) {
            colorstr.append('0').append(str);
        } else {
            colorstr.append(str);
        }
        if (color.getAlpha() != 255) {
            str = Integer.toHexString(color.getAlpha());
            if (str.length() > 2) {
                colorstr.append(str.substring(0, 2));
            } else if (str.length() < 2) {
                colorstr.append('0').append(str);
            } else {
                colorstr.append(str);
            }
        }
        return colorstr.toString().toUpperCase(Locale.ENGLISH);
    }

    public static String colorToHexAlpha(String color) {
        if (color == null || color.startsWith("#")) {
            return color;
        }
        if (color.length() > 6) {
            String alpha = color.substring(6);
            color = "#" + color.substring(0, 6) + Integer.toHexString(Integer.parseInt(alpha));
        }
        return color;
    }

    public static String strToRgba(String strColor) {
        if (strColor == null || strColor.startsWith("#")) {
            return strColor;
        }
        String strR = strColor.substring(0, 2);
        String strG = strColor.substring(2, 4);
        String strB = strColor.substring(4, 6);
        String strA = strColor.substring(6);
        int alphaInt = Integer.parseInt(strA);
        float alphaFloat = (float)Math.round((float)alphaInt / 255.0f * 100.0f) / 100.0f;
        return "rgba(" + Integer.parseInt(strR, 16) + "," + Integer.parseInt(strG, 16) + "," + Integer.parseInt(strB, 16) + "," + alphaFloat + ")";
    }
}

