/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class DBUtil {
    private static final Logger log = LogUtil.getPackageLogger(DBUtil.class);

    public static final boolean loadDriver(String driverClass) {
        log.info((Object)(":| Load JDBC driver " + driverClass));
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException ex) {
            log.warn((Object)ex, (Throwable)ex);
            return false;
        }
        log.info((Object)":) Load JDBC driver OK.");
        return true;
    }

    public static final boolean loadMSSQLDriver() {
        return DBUtil.loadDriver("com.microsoft.jdbc.sqlserver.SQLServerDriver");
    }

    public static final boolean loadKSQLDriver() {
        return DBUtil.loadDriver("kd.bos.ksql.shell.Driver");
    }

    public static final Connection openDB(String connUrl, String user, String pwd) throws SQLException {
        log.info((Object)(":| Open DB-Connection " + connUrl));
        Connection conn = DriverManager.getConnection(connUrl, user, pwd);
        log.info((Object)":) Open DB-Connection OK.");
        return conn;
    }

    public static final Connection openMSSQLDB(String serverUrl, String dbName, String user, String pwd) throws SQLException {
        return DBUtil.openDB("jdbc:microsoft:sqlserver://" + serverUrl + ";SelectMethod=cursor;Charset=GBK;DatabaseName=" + dbName, user, pwd);
    }

    public static final Connection openMSSQLDB_as_ksql(String serverUrl, String dbName, String user, String pwd) throws SQLException {
        String connUrl = "jdbc:ksql:com.microsoft.jdbc.sqlserver.SQLServerDriver:dbtype=mssqlserver:trace=off:file=null:Optimize=1:jdbc:microsoft:sqlserver://" + serverUrl + ";DataBaseName=" + dbName;
        return DBUtil.openDB(connUrl, user, pwd);
    }

    public static final void closeDBConn(Connection dbConn) {
        log.debug((Object)":| Close DB-Connection ...");
        if (dbConn != null) {
            try {
                dbConn.close();
            }
            catch (SQLException ex) {
                log.error((Object)ex, (Throwable)ex);
            }
            log.debug((Object)":) Close DB-Connection OK.");
        }
    }

    public static final void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                log.error((Object)ex, (Throwable)ex);
            }
        }
    }

    public static final void closeResultSetExEx(ResultSet rs) {
        if (rs != null) {
            Statement stmt = null;
            Connection conn = null;
            try {
                stmt = rs.getStatement();
                conn = stmt.getConnection();
            }
            catch (Exception ex) {
                log.info((Object)"", (Throwable)ex);
            }
            DBUtil.closeResultSet(rs);
            if (stmt != null) {
                DBUtil.closeStatement(stmt);
                if (conn != null) {
                    DBUtil.closeDBConn(conn);
                }
            }
        }
    }

    public static final void closeResultSetEx(ResultSet rs) {
        if (rs != null) {
            Statement stmt = null;
            try {
                stmt = rs.getStatement();
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
            }
            DBUtil.closeResultSet(rs);
            if (stmt != null) {
                DBUtil.closeStatement(stmt);
            }
        }
    }

    public static final void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                log.error((Object)ex, (Throwable)ex);
            }
        }
    }

    public static final void readRow(ResultSet rs, Object[] outs, int colCount) throws SQLException {
        for (int i = 0; i < colCount; ++i) {
            outs[i] = rs.getObject(i + 1);
        }
    }

    public static final void readRow(ResultSet rs, Object[] outs) throws SQLException {
        for (int i = 0; i < outs.length; ++i) {
            outs[i] = rs.getObject(i + 1);
        }
    }

    public static final Object[] readRow(ResultSet rs) throws SQLException {
        Object[] rowData = new Object[rs.getMetaData().getColumnCount()];
        DBUtil.readRow(rs, rowData);
        return rowData;
    }

    public static final ResultSet executeSql(Connection conn, String sql) throws SQLException {
        long l0 = 0L;
        if (log.isDebugEnabled()) {
            l0 = System.currentTimeMillis();
            log.debug((Object)("Execute KSQL ...\r\n" + sql));
        }
        ResultSet rs = null;
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            rs = stmt.executeQuery();
            if (log.isDebugEnabled()) {
                log.debug((Object)("spent:" + (System.currentTimeMillis() - l0) + " ms!"));
            }
        }
        return rs;
    }

    public static final RowSet makeRowSet(ResultSet rs) throws SQLException {
        try (JdbcRowSet jrs = new JdbcRowSet();){
            if (rs.getMetaData().getColumnCount() > 0) {
                jrs.populate(rs);
            }
            JdbcRowSet jdbcRowSet = jrs;
            return jdbcRowSet;
        }
    }
}

