/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util;

import com.kingdee.cosmic.ctrl.common.util.BMPReader;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StreamUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.Base64;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.ImageIcon;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class ImageUtil {
    private static final Logger log = LogUtil.getLogger(ImageUtil.class);

    public static Image getImage(String str) {
        byte[] bytes = ImageUtil.getImageByteContent(str);
        if (bytes != null) {
            return ImageUtil.makeImage(bytes);
        }
        return null;
    }

    public static final Image makeImage(byte[] data) {
        if (data.length > 1 && data[0] == 66 && data[1] == 77) {
            return BMPReader.loadBitMap(data);
        }
        return new ImageIcon(data).getImage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getImageByteContent(String str) {
        if (StringUtil.isEmptyString(str)) return null;
        if (str.startsWith("data:image")) {
            return Base64.decode(str.substring(str.indexOf("base64,") + 7));
        }
        String filePath = str;
        if (str.startsWith("file://")) {
            filePath = str.substring(7);
        }
        try (FileInputStream in = new FileInputStream(new File(FilenameUtils.normalize((String)filePath)));){
            byte[] content = null;
            byte[] byArray = content = StreamUtil.readInputStream(in);
            return byArray;
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("The file below is not found: " + filePath), (Throwable)e);
            return null;
        }
        catch (IOException e1) {
            log.error((Object)"Read Picture I/O error.", (Throwable)e1);
            return null;
        }
    }
}

