/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class InputStreamPacker {
    private InputStream is;
    private ArrayList byteArrays = new ArrayList();
    private int cacheSize = 512;
    private byte[] result;

    public InputStreamPacker(InputStream is) {
        this.is = is;
    }

    public byte[] getPackedByteArray() {
        if (this.result != null) {
            return this.result;
        }
        int lastCount = 0;
        try {
            lastCount = this.is.read(this.getNextBytes());
            while (lastCount == this.cacheSize) {
                lastCount = this.is.read(this.getNextBytes());
            }
        }
        catch (IOException e) {
            this.byteArrays.remove(this.byteArrays.size() - 1);
        }
        int size = (this.byteArrays.size() - 1) * this.cacheSize;
        if (lastCount > 0) {
            size += lastCount;
        }
        this.result = new byte[size];
        int cursor = 0;
        for (int i = 0; i < this.byteArrays.size() - 1; ++i) {
            System.arraycopy(this.byteArrays.get(i), 0, this.result, cursor, this.cacheSize);
            cursor += this.cacheSize;
        }
        if (lastCount > 0) {
            System.arraycopy(this.byteArrays.get(this.byteArrays.size() - 1), 0, this.result, cursor, lastCount);
        }
        this.byteArrays.clear();
        return this.result;
    }

    private byte[] getNextBytes() {
        byte[] bytes = new byte[this.cacheSize];
        this.byteArrays.add(bytes);
        return bytes;
    }
}

