/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util.list;

import com.kingdee.cosmic.ctrl.common.util.list.BlockTable;

public class Block {
    private BlockTable blocks;
    private int startPosition;
    private int startIndex;
    private int size;
    private int[] per_sizes;

    Block(BlockTable blocks, int start_position, int size) {
        this(blocks, start_position, size, -1, 0);
    }

    Block(BlockTable blocks, int start_position, int size, int logicalIndex, int objsCount) {
        this(blocks, start_position, size, logicalIndex, objsCount == 0 || blocks.isFxiedOjbectSize() ? null : new int[objsCount]);
    }

    Block(BlockTable blocks, int start_position, int size, int logicalIndex, int[] sizes) {
        this.blocks = blocks;
        this.startPosition = start_position;
        this.size = size;
        this.startIndex = logicalIndex;
        this.per_sizes = sizes;
    }

    final boolean isIdleBlock() {
        return this.startIndex == -1;
    }

    final int tailIndex() {
        return this.startIndex + this.objectsCount() - 1;
    }

    final boolean indexSequential(int logicalIndex) {
        return this.startIndex + this.objectsCount() == logicalIndex;
    }

    final int objectsCount() {
        return this.blocks.isFxiedOjbectSize() ? this.size : this.per_sizes.length;
    }

    final int blockSize() {
        return this.size;
    }

    final int startPosition() {
        return this.startPosition;
    }

    final int startIndex() {
        return this.startIndex;
    }

    final int offsetStartIndex(int off) {
        return this.startIndex += off;
    }

    final boolean has(int logicalIndex) {
        return this.startIndex != -1 && this.startIndex <= logicalIndex && this.tailIndex() >= logicalIndex;
    }

    final void increaseSize(int size_diff) {
        this.size += size_diff;
    }

    final void setAllocated(int logicalIndex, int objsCount) {
        if (this.startIndex == -1) {
            this.startIndex = logicalIndex;
            if (!this.blocks.isFxiedOjbectSize()) {
                this.per_sizes = new int[objsCount];
            }
        }
    }

    final void addObjects(int objsSize, int objsCount) {
        this.size += objsSize;
        if (!this.blocks.isFxiedOjbectSize()) {
            int[] tmp = new int[this.per_sizes.length + objsCount];
            System.arraycopy(this.per_sizes, 0, tmp, 0, this.per_sizes.length);
            this.per_sizes = tmp;
        }
    }

    final void cutFront(int cutSize) {
        this.startPosition += cutSize;
        this.size -= cutSize;
    }

    final Block cutFrontAsBlock(int cutSize) {
        Block cut = null;
        if (cutSize < this.size) {
            if (cutSize != 0) {
                cut = new Block(this.blocks, this.startPosition, cutSize);
                this.cutFront(cutSize);
            }
        } else {
            cut = this;
        }
        return cut;
    }

    final void cutTail(int cutSize) {
        this.size -= cutSize;
    }

    final Block[] splits(int logicalIndex) {
        Block[] splits = new Block[]{this.pickUp(this.startIndex, logicalIndex - this.startIndex), this.pickUp(logicalIndex, this.tailIndex() + 1 - logicalIndex)};
        return splits;
    }

    final Block[] freeObjects(int logicalIndex, int objsCount) {
        Block[] splits = new Block[3];
        splits[0] = this.pickUp(this.startIndex, logicalIndex - this.startIndex);
        splits[1] = this.pickUp(logicalIndex, objsCount);
        splits[1].startIndex = -1;
        splits[1].per_sizes = null;
        splits[2] = this.pickUp(logicalIndex + objsCount, this.startIndex + this.objectsCount() - (logicalIndex + objsCount));
        if (splits[2] != null) {
            splits[2].startIndex -= objsCount;
        }
        return splits;
    }

    final boolean unit(Block blk) {
        if (blk == null) {
            return false;
        }
        if (this.startIndex == -1 && blk.startIndex == -1) {
            if (this.startPosition + this.size == blk.startPosition()) {
                this.size += blk.blockSize();
                return true;
            }
        } else if (this.startIndex != -1 && blk.startIndex != -1 && this.startPosition + this.size == blk.startPosition() && this.tailIndex() + 1 == blk.startIndex) {
            int oldCount = this.objectsCount();
            this.addObjects(blk.blockSize(), blk.objectsCount());
            if (!this.blocks.isFxiedOjbectSize()) {
                System.arraycopy(blk.per_sizes, 0, this.per_sizes, oldCount, blk.objectsCount());
            }
            return true;
        }
        return false;
    }

    final Block pickUp(int index, int objsCount) {
        if (objsCount <= 0) {
            return null;
        }
        int[] tmp = null;
        int objsSize = 0;
        if (!this.blocks.isFxiedOjbectSize()) {
            tmp = new int[objsCount];
            System.arraycopy(this.per_sizes, index - this.startIndex, tmp, 0, tmp.length);
            for (int i = 0; i < objsCount; ++i) {
                objsSize += this.per_sizes[i + index - this.startIndex];
            }
        } else {
            objsSize = objsCount;
        }
        return new Block(this.blocks, this.objectPosition(index), objsSize, index, tmp);
    }

    final int objectSize(int logicalIndex) {
        return this.blocks.isFxiedOjbectSize() ? 1 : this.per_sizes[logicalIndex - this.startIndex];
    }

    final void setObjectSize(int logicalIndex, int size) {
        if (!this.blocks.isFxiedOjbectSize()) {
            this.per_sizes[logicalIndex - this.startIndex] = size;
        }
    }

    final int objectPosition(int logicalIndex) {
        int position = this.startPosition;
        if (this.blocks.isFxiedOjbectSize()) {
            position += logicalIndex - this.startIndex;
        } else {
            for (int i = this.startIndex; i < logicalIndex; ++i) {
                position += this.per_sizes[i - this.startIndex];
            }
        }
        return position;
    }

    public String toString() {
        String str = "position=" + this.startPosition + ",size=" + this.size;
        if (this.startIndex != -1) {
            str = str + ",index=" + this.startIndex + ",objsCount=" + this.objectsCount();
        }
        return str + "\r\n";
    }
}

