/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util.logger;

import com.kingdee.cosmic.ctrl.common.util.logger.LogParser;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;

public class LogReader {
    private Map indexes;
    private long length;
    private String file;
    private boolean parse;
    private static int BUFFER_SIZE = 32768;
    private static String LINE_SEPARATOR = System.getProperty("line.separator");

    public LogReader(String file, int pageRowCount, boolean parse) throws IOException {
        this.file = file;
        this.length = -1L;
        this.parse = parse;
        this.indexes = new HashMap();
        this.buildIndex(pageRowCount);
    }

    public int getPageCount() {
        return this.indexes.size();
    }

    public List readPage(int page) throws IOException {
        ArrayList<Object> logs = new ArrayList<Object>();
        if (page > this.getPageCount() || page <= 0) {
            return logs;
        }
        long currentPos = (Long)this.indexes.get(page);
        long nextPos = this.length;
        if (page < this.indexes.size()) {
            nextPos = (Long)this.indexes.get(page + 1);
        }
        byte[] buffer = null;
        try (RandomAccessFile raf = new RandomAccessFile(FilenameUtils.normalize((String)this.file), "r");){
            raf.seek(currentPos);
            buffer = new byte[(int)(nextPos - currentPos)];
            raf.read(buffer);
        }
        String data = new String(buffer, StandardCharsets.UTF_8);
        StringTokenizer st = new StringTokenizer(data, this.parse ? "[" : LINE_SEPARATOR, false);
        while (st.hasMoreTokens()) {
            String tokens;
            String string = tokens = this.parse ? "[" + st.nextToken().trim() : st.nextToken();
            if (this.parse) {
                logs.add(LogParser.parse(tokens));
                continue;
            }
            logs.add(tokens);
        }
        st = null;
        data = null;
        buffer = null;
        return logs;
    }

    private void buildIndex(int pageRows) throws IOException {
        byte[] buffer = new byte[BUFFER_SIZE];
        try (RandomAccessFile raf = new RandomAccessFile(FilenameUtils.normalize((String)this.file), "r");){
            int row = -1;
            int page = 0;
            long readPos = 0L;
            this.length = raf.length();
            if (this.length <= 0L) {
                return;
            }
            String delim = this.parse ? "[" : LINE_SEPARATOR;
            int delimLen = delim.length();
            while (raf.getFilePointer() < this.length) {
                int previousPos;
                readPos = raf.getFilePointer();
                int size = this.readBlock(buffer, raf);
                String data = new String(buffer, 0, size);
                if (!data.endsWith(LINE_SEPARATOR) && raf.getFilePointer() < raf.length()) {
                    data = data + raf.readLine() + LINE_SEPARATOR;
                }
                int nextPos = previousPos = -delimLen;
                while (true) {
                    previousPos = previousPos < 0 ? 0 : nextPos;
                    if ((nextPos = data.indexOf(delim, nextPos + delimLen)) < 0) break;
                    if (++row % pageRows != 0) continue;
                    long bytepos = data.substring(0, this.parse ? nextPos : previousPos).getBytes(StandardCharsets.UTF_8).length;
                    this.indexes.put(++page, readPos + bytepos);
                }
                data = null;
            }
            buffer = null;
        }
    }

    private int readBlock(byte[] buffer, RandomAccessFile raf) throws IOException {
        Arrays.fill(buffer, (byte)32);
        return raf.read(buffer);
    }
}

