/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.variant;

import com.kingdee.cosmic.ctrl.common.variant.ExprErr;
import com.kingdee.cosmic.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.common.variant.VarBase;
import com.kingdee.cosmic.ctrl.common.variant.Variant;
import java.math.BigDecimal;

class VarNull
extends VarBase {
    VarNull() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.isNull()) {
            result.setBigDecimal(BigDecimal.valueOf(0.0));
        } else {
            result.setVariant(right);
        }
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.isNull()) {
            result.setBigDecimal(BigDecimal.valueOf(0.0));
        } else {
            right.negate(result);
        }
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        result.setBigDecimal(BigDecimal.valueOf(0.0));
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.isNull()) {
            ExprErr.goError(2L, null);
        } else {
            result.setBigDecimal(BigDecimal.valueOf(0.0));
        }
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        result.setVariant(Variant.nullVariant);
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        result.setVariant(Variant.nullVariant);
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        result.setVariant(right);
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        result.setBoolean(right.getVt() != 0);
    }
}

