/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.data.modal.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.DataType;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.data.modal.Parameter;
import com.kingdee.cosmic.ctrl.data.modal.io.Def2Xml;
import com.kingdee.cosmic.ctrl.data.modal.io.Xml2Def;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ParameterIO {
    public static final String T_PARAMETERS = "Parameters";
    public static final String T_PARAMETER = "Parameter";
    public static final String A_DATA_TYPE = "dataType";
    public static final String A_SCOPE = "scope";
    public static final String A_ALLOW_NULL = "allowNull";
    public static final String A_DEFAULT_VALUE = "defaultValue";
    public static final String T_INPUT = "Input";
    public static final String A_TYPE = "type";

    public static final IXmlElement makeParameter(Parameter p) {
        IXmlElement xml = XmlUtil.createNode((String)T_PARAMETER);
        if (p != null) {
            Def2Xml.makeDefObj(p, xml);
            Def2Xml.makeProperties(Parameter.CUSTEM_PROPERTIES, p.getProperties(), xml);
            if (p.getDataType() != null) {
                xml.setAttribute(A_DATA_TYPE, p.getDataType().getName());
            }
            xml.setAttribute(A_ALLOW_NULL, Boolean.toString(p.isAllowNull()));
            String s = p.getDefaultValue();
            if (!StringUtil.isEmptyString(s)) {
                xml.setAttribute(A_DEFAULT_VALUE, p.getDefaultValue());
            }
        }
        return xml;
    }

    public static final IXmlElement makeParameters(List ps) {
        IXmlElement xml = XmlUtil.createNode((String)T_PARAMETERS);
        Iterator itr = ps.iterator();
        while (itr.hasNext()) {
            xml.addChild(ParameterIO.makeParameter((Parameter)itr.next()));
        }
        return xml;
    }

    public static Parameter parseParameter(IXmlElement xml) {
        Parameter obj = new Parameter();
        Xml2Def.parseDefObj(obj, xml);
        Xml2Def.parseProperties(Parameter.CUSTEM_PROPERTIES, obj.getProperties(), xml);
        obj.setDataType(DataType.fromName(xml.getAttribute(A_DATA_TYPE)));
        obj.setAllowNull(Boolean.parseBoolean(xml.getAttribute(A_ALLOW_NULL)));
        obj.setDefaultValue(xml.getAttribute(A_DEFAULT_VALUE));
        return obj;
    }

    public static final List parseParameters(IXmlElement xml) {
        List lst = xml.searchChildren(T_PARAMETER);
        ArrayList<Parameter> ps = new ArrayList<Parameter>(lst.size());
        Iterator i = lst.iterator();
        while (i.hasNext()) {
            Parameter p = ParameterIO.parseParameter((IXmlElement)i.next());
            ps.add(p);
        }
        return ps;
    }
}

