/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.expr;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.kdf.expr.ExprError;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.CtrlFormatUtilities;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

final class Util {
    protected static final int FALSE = 0;
    protected static final int TRUE = 1;
    private static final Locale[] locales = new Locale[]{Locale.getDefault(), Locale.US, Locale.CHINA, Locale.TAIWAN, Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE, Locale.CHINESE, Locale.UK, Locale.CANADA, Locale.CANADA_FRENCH, Locale.JAPANESE, Locale.KOREA, Locale.KOREAN, Locale.FRANCE, Locale.FRENCH, Locale.GERMAN, Locale.GERMANY, Locale.ITALIAN, Locale.ITALY, Locale.JAPAN, Locale.PRC};
    private static final int[] styles = new int[]{3, 2, 1, 0};
    private static final int QUICKPARSE = 0;
    private static final int FULLAFTERQUICK = 2;
    private static final int LOCALESNUMINQUICKPARSE = 4;
    private static final String[] weekFields = new String[]{"EEE", "EEEE"};
    private static final String[] yearFields = new String[]{"yy", "yyyy", "yyyy"};
    private static final String[] monthFields = new String[]{"MM", "MMM", "MMMM"};
    private static final String timeInAmpmFields = "K:m:s";
    private static final String timeInDayFields = "H:m:s";
    private static final String ampmFields = "aa";
    private static final String dayFields = "dd";
    private static final String defaultPattern = "EEE yy MM dd HH:mm:ss";
    private static final int[][] mix = new int[][]{{0, 1, 2}, {0, 2, 1}, {1, 2, 0}, {2, 1, 0}, {1, 0, 2}, {2, 0, 1}};
    private static final String[] dateWeekPatterns = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
    private static final String[] datePatterns = new String[]{"", "", "", ""};
    private static final String[] timeField = new String[]{"K:m:s aa", "H:m:s", "aaK:m:s"};

    Util() {
    }

    protected static int booleanToInt(boolean val) {
        if (val) {
            return 1;
        }
        return 0;
    }

    protected static char booleanToChar(boolean val) {
        if (val) {
            return 'T';
        }
        return 'F';
    }

    protected static String booleanToString(boolean val) {
        if (val) {
            return "true";
        }
        return "false";
    }

    protected static Number stringToNumber(String val) throws SyntaxErrorException {
        DecimalFormatSymbols symbols = CtrlFormatUtilities.getDecimalFormatSymbols();
        NumberFormat nf = NumberFormat.getInstance();
        if (nf instanceof DecimalFormat) {
            ((DecimalFormat)nf).setDecimalFormatSymbols(symbols);
        }
        ParsePosition pos = new ParsePosition(0);
        Number ret = nf.parse(val, pos);
        if (pos.getIndex() == 0 || pos.getIndex() < val.length()) {
            ExprError.goError(64L, CtrlCommonMessages.getMLS("parseError", "\u89e3\u6790\u9519\u8bef"));
        } else {
            char decimalSeparator = symbols.getDecimalSeparator();
            char groupingSeparator = symbols.getGroupingSeparator();
            int dotIndex = val.indexOf(decimalSeparator);
            String temp = val;
            if (dotIndex >= 0) {
                temp = temp.substring(0, dotIndex);
            }
            int len = temp.length();
            int kioIndex = temp.lastIndexOf(groupingSeparator);
            while (kioIndex >= 0 && (len - kioIndex) % 4 == 0) {
                kioIndex = temp.lastIndexOf(groupingSeparator, kioIndex - 1);
            }
            if (kioIndex >= 0) {
                throw new SyntaxErrorException(64L);
            }
        }
        return ret;
    }

    protected static boolean stringToBoolean(String val) throws SyntaxErrorException {
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        ExprError.goError(64L, CtrlCommonMessages.getMLS("cannotConvertToBoolean", "\u65e0\u6cd5\u8f6c\u6362\u4e3aBoolean\u7c7b\u578b"));
        return false;
    }

    protected static String stringReplace(String source, String substring, String replacement) {
        int sublen = substring.length();
        int srclen = source.length();
        if (sublen == 0 || srclen < sublen) {
            return source;
        }
        int index = source.indexOf(substring);
        if (index == -1) {
            return source;
        }
        return source.substring(0, index) + replacement + source.substring(index + sublen, srclen);
    }

    protected static String stringReplaceAll(String source, String substring, String replacement) {
        int sublen = substring.length();
        int srclen = source.length();
        int rpllen = replacement.length();
        if (sublen == 0 || srclen < sublen) {
            return source;
        }
        StringBuffer sb = new StringBuffer(source);
        int index = sb.indexOf(substring);
        while (index != -1) {
            sb = sb.replace(index, index + sublen, replacement);
            index = sb.indexOf(substring, index + rpllen);
        }
        return sb.toString();
    }

    private static Date stringToDate(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                df = DateFormat.getDateInstance(styles[j], locales[i]);
                df.setLenient(false);
                try {
                    ret = df.parse(src);
                    break block2;
                }
                catch (Exception e) {
                    ret = null;
                    continue;
                }
            }
        }
        return ret;
    }

    private static Date stringToTime(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                df = DateFormat.getTimeInstance(styles[j], locales[i]);
                df.setLenient(false);
                try {
                    ret = df.parse(src);
                    break block2;
                }
                catch (Exception e) {
                    ret = null;
                    continue;
                }
            }
        }
        return ret;
    }

    private static Date stringToDateTime(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                for (int k = 0; k < styles.length; ++k) {
                    df = DateFormat.getDateTimeInstance(styles[j], styles[k], locales[i]);
                    df.setLenient(false);
                    try {
                        ret = df.parse(src);
                        break block2;
                    }
                    catch (Exception e) {
                        ret = null;
                        continue;
                    }
                }
            }
        }
        return ret;
    }

    private static String[] getDateWeekPatterns(int dateStyle, int weekStyle) {
        String[] patterns = dateWeekPatterns;
        String[] dates = new String[]{monthFields[dateStyle] + " " + dayFields, "dd " + monthFields[dateStyle]};
        for (int idates = 0; idates < 2; ++idates) {
            String[] fields = new String[]{weekFields[weekStyle], yearFields[dateStyle], dates[idates]};
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int n = idates * 6 + i;
                    patterns[n] = patterns[n] + fields[mix[i][j]];
                    if (j >= 2) continue;
                    int n2 = idates * 6 + i;
                    patterns[n2] = patterns[n2] + " ";
                }
            }
        }
        return patterns;
    }

    private static String[] getDatePatterns(int dateStyle) {
        String[] patterns = datePatterns;
        String[] dates = new String[]{monthFields[dateStyle] + " " + dayFields, "dd " + monthFields[dateStyle]};
        for (int idates = 0; idates < 2; ++idates) {
            String[] fields = new String[]{null, yearFields[dateStyle], dates[idates]};
            for (int i = 0; i < 2; ++i) {
                for (int j = 1; j < 3; ++j) {
                    int n = idates * 2 + i;
                    patterns[n] = patterns[n] + fields[mix[i][j]];
                    if (j >= 2) continue;
                    int n2 = idates * 2 + i;
                    patterns[n2] = patterns[n2] + " ";
                }
            }
        }
        return patterns;
    }

    protected static Date stringToDateByPattern(String src) {
        int dateStyle;
        String str = src.replace('.', ' ');
        str = str.replace('-', ' ');
        str = str.replace('/', ' ');
        str = str.replace(',', ' ');
        while (-1 != str.indexOf("  ")) {
            str = str.replaceAll("  ", " ");
        }
        boolean isIncludeTime = false;
        if (-1 != str.indexOf(58, 10)) {
            isIncludeTime = true;
        }
        Date ret = null;
        String[][] ps = new String[9][];
        for (dateStyle = 0; dateStyle < 3; ++dateStyle) {
            ps[dateStyle] = Util.getDatePatterns(dateStyle);
        }
        for (dateStyle = 0; dateStyle < 3; ++dateStyle) {
            for (int weeekStyle = 0; weeekStyle < 2; ++weeekStyle) {
                ps[dateStyle * 2 + weeekStyle + 3] = Util.getDateWeekPatterns(dateStyle, weeekStyle);
            }
        }
        ParsePosition pos = new ParsePosition(0);
        if (isIncludeTime) {
            int i;
            String[] timeFields = timeField;
            String[][] psTime = new String[27][];
            for (i = 0; i < 3; ++i) {
                int k;
                for (k = 0; k < 3; ++k) {
                    psTime[i * 9 + k] = new String[4];
                }
                for (k = 3; k < 9; ++k) {
                    psTime[i * 9 + k] = new String[12];
                }
            }
            for (int k = 0; k < timeFields.length; ++k) {
                for (int i2 = 0; i2 < ps.length; ++i2) {
                    for (int j = 0; j < ps[i2].length; ++j) {
                        psTime[9 * k + i2][j] = ps[i2][j] + " " + timeFields[k];
                    }
                }
            }
            for (i = 0; i < locales.length && (ret = Util.stringToDateByPattern(str, psTime, locales[i], pos)) == null; ++i) {
            }
        } else {
            for (int i = 0; i < locales.length && (ret = Util.stringToDateByPattern(str, ps, locales[i], pos)) == null; ++i) {
            }
        }
        return ret;
    }

    private static Date stringToDateByPattern(String src, String[][] patterns, Locale loc, ParsePosition pos) {
        Date ret = null;
        SimpleDateFormat sdf = new SimpleDateFormat(defaultPattern, loc);
        sdf.setLenient(false);
        ret = sdf.parse(src, pos);
        if (ret != null) {
            return ret;
        }
        int i = 0;
        int j = 0;
        block0: for (i = 0; i < patterns.length; ++i) {
            for (j = 0; j < patterns[i].length; ++j) {
                sdf.applyPattern(patterns[i][j]);
                ret = sdf.parse(src, pos);
                if (ret != null) break block0;
            }
        }
        return ret;
    }

    protected static Date stringToDateEx(String src) {
        DateFormatSymbols dfs = null;
        String[] weekdays = null;
        String str = src.toUpperCase(Locale.ENGLISH);
        String token = null;
        block0: for (int i = 0; i < locales.length; ++i) {
            int k;
            dfs = new DateFormatSymbols(locales[i]);
            weekdays = dfs.getShortWeekdays();
            for (k = 1; k < weekdays.length; ++k) {
                token = weekdays[k].toUpperCase(Locale.ENGLISH);
                if (-1 == str.indexOf(token)) continue;
                str = Util.stringReplace(str, token, "");
                str = str.trim();
                break block0;
            }
            weekdays = dfs.getWeekdays();
            for (k = 1; k < weekdays.length; ++k) {
                token = weekdays[k].toUpperCase(Locale.ENGLISH);
                if (-1 == str.indexOf(token)) continue;
                str = Util.stringReplace(str, token, "");
                str = str.trim();
                break block0;
            }
        }
        Date ret = null;
        if (src.length() > 10) {
            ret = Util.stringToDateTime(src, 0);
            if (ret == null) {
                ret = Util.stringToDateTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDate(src, 0)) == null) {
                ret = Util.stringToTime(src, 0);
            }
            if (ret == null && (ret = Util.stringToDate(src, 2)) == null) {
                ret = Util.stringToTime(src, 2);
            }
        } else {
            ret = Util.stringToDate(src, 0);
            if (ret == null) {
                ret = Util.stringToDate(src, 2);
            }
            if (ret == null && (ret = Util.stringToTime(src, 0)) == null) {
                ret = Util.stringToTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDateTime(src, 0)) == null) {
                ret = Util.stringToDateTime(src, 2);
            }
        }
        return ret;
    }

    protected static Date stringToDate(String src) {
        Date ret = null;
        if (src.length() > 10) {
            ret = Util.stringToDateTime(src, 0);
            if (ret == null) {
                ret = Util.stringToDateTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDate(src, 0)) == null) {
                ret = Util.stringToTime(src, 0);
            }
            if (ret == null && (ret = Util.stringToDate(src, 2)) == null) {
                ret = Util.stringToTime(src, 2);
            }
            if (ret == null) {
                ret = Util.stringToDateByPattern(src);
            }
        } else {
            ret = Util.stringToDate(src, 0);
            if (ret == null) {
                ret = Util.stringToDate(src, 2);
            }
            if (ret == null && (ret = Util.stringToTime(src, 0)) == null) {
                ret = Util.stringToTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDateTime(src, 0)) == null) {
                ret = Util.stringToDateTime(src, 2);
            }
            if (ret == null) {
                ret = Util.stringToDateByPattern(src);
            }
        }
        return ret;
    }

    private static int maxBit(long val) {
        int ret = 0;
        if (val < 0L) {
            if (val == Long.MIN_VALUE) {
                return 64;
            }
            val = -val;
        }
        long sect = 0xFFFFFFFFL;
        int k = 32;
        do {
            if (val > sect) {
                ret += k;
                val >>= k;
            }
            sect >>= (k /= 2);
        } while (k > 0);
        if (val > 0L) {
            ++ret;
        }
        return ret;
    }

    protected static void add(byte left, byte right, Variant result) {
        int ret = left + right;
        if (ret != (byte)ret) {
            result.setShort((short)ret);
        } else {
            result.setByte((byte)ret);
        }
    }

    protected static void add(short left, short right, Variant result) {
        int ret = left + right;
        if (ret != (short)ret) {
            result.setInt(ret);
        } else {
            result.setShort((short)ret);
        }
    }

    protected static void add(int left, int right, Variant result) {
        long ret = (long)left + (long)right;
        if (ret != (long)((int)ret)) {
            result.setLong(ret);
        } else {
            result.setInt((int)ret);
        }
    }

    protected static void add(long left, long right, Variant result) {
        long ret = left + right;
        if ((left ^ right) >= 0L) {
            if (left > 0L && ret < 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = 0;
                result.setObject(new BigInteger(bta), 9);
            } else if (left < 0L && ret >= 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = -1;
                result.setObject(new BigInteger(bta), 9);
            } else {
                result.setLong(ret);
            }
        } else {
            result.setLong(ret);
        }
    }

    protected static void add(float left, float right, Variant result) {
        Util.add((double)left, (double)right, result);
    }

    protected static void add(double left, double right, Variant result) {
        BigDecimal reD = new BigDecimal(Double.toString(left));
        reD = reD.add(new BigDecimal(Double.toString(right)));
        result.setObject(reD, 10);
    }

    protected static void subtract(byte left, byte right, Variant result) {
        int ret = left - right;
        if (ret != (byte)ret) {
            result.setShort((short)ret);
        } else {
            result.setByte((byte)ret);
        }
    }

    protected static void subtract(short left, short right, Variant result) {
        int ret = left - right;
        if (ret != (short)ret) {
            result.setInt(ret);
        } else {
            result.setShort((short)ret);
        }
    }

    protected static void subtract(int left, int right, Variant result) {
        long ret = (long)left - (long)right;
        if (ret != (long)((int)ret)) {
            result.setLong(ret);
        } else {
            result.setInt((int)ret);
        }
    }

    protected static void subtract(long left, long right, Variant result) {
        right = -right;
        long ret = left + right;
        if ((left ^ right) >= 0L) {
            if (left > 0L && ret < 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = 0;
                result.setObject(new BigInteger(bta), 9);
            } else if (left < 0L && ret >= 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = -1;
                result.setObject(new BigInteger(bta), 9);
            } else {
                result.setLong(ret);
            }
        } else {
            result.setLong(ret);
        }
    }

    protected static void subtract(float left, float right, Variant result) {
        Util.subtract((double)left, (double)right, result);
    }

    protected static void subtract(double left, double right, Variant result) {
        BigDecimal ret = new BigDecimal(Double.toString(left)).subtract(new BigDecimal(Double.toString(right)));
        result.setObject(ret, 10);
    }

    protected static void multiply(byte left, byte right, Variant result) {
        int ret = left * right;
        if (ret != (byte)ret) {
            result.setShort((short)ret);
        } else {
            result.setByte((byte)ret);
        }
    }

    protected static void multiply(short left, short right, Variant result) {
        int ret = left * right;
        if (ret != (short)ret) {
            result.setInt(ret);
        } else {
            result.setShort((short)ret);
        }
    }

    protected static void multiply(int left, int right, Variant result) {
        long ret = (long)left * (long)right;
        if (ret != (long)((int)ret)) {
            result.setLong(ret);
        } else {
            result.setInt((int)ret);
        }
    }

    protected static void multiply(long left, long right, Variant result) {
        if (left == 1L) {
            result.setLong(right);
        } else if (right == 1L) {
            result.setLong(left);
        } else if (Util.maxBit(left) + Util.maxBit(right) > 64) {
            result.setDouble((double)left * (double)right);
        } else {
            result.setLong(left * right);
        }
    }

    protected static void multiply(float left, float right, Variant result) {
        BigDecimal ret = new BigDecimal(Float.toString(left)).multiply(new BigDecimal(Float.toString(right)));
        result.setObject(ret, 10);
    }

    protected static void multiply(double left, double right, Variant result) {
        BigDecimal ret = new BigDecimal(Double.toString(left)).multiply(new BigDecimal(Double.toString(right)));
        result.setObject(ret, 10);
    }

    protected static void divide(byte left, byte right, Variant result) {
        int ret = left / right;
        result.setByte((byte)ret);
    }

    protected static void divide(short left, short right, Variant result) {
        int ret = left / right;
        result.setShort((short)ret);
    }

    protected static void divide(int left, int right, Variant result) {
        int ret = left / right;
        result.setInt(ret);
    }

    protected static void divide(long left, long right, Variant result) {
        long ret = left / right;
        result.setLong(ret);
    }

    protected static void divide(float left, float right, Variant result) {
        BigDecimal ret = new BigDecimal(Float.toString(left)).divide(new BigDecimal(Float.toString(right)), 10, 4);
        result.setObject(ret, 10);
    }

    protected static void divide(double left, double right, Variant result) {
        BigDecimal ret = new BigDecimal(Double.toString(left)).divide(new BigDecimal(Double.toString(right)), 10, 4);
        result.setObject(ret, 10);
    }

    protected static void mod(byte left, byte right, Variant result) {
        result.setByte((byte)(left % right));
    }

    protected static void mod(short left, short right, Variant result) {
        result.setShort((short)(left % right));
    }

    protected static void mod(int left, int right, Variant result) {
        result.setInt(left % right);
    }

    protected static void mod(long left, long right, Variant result) {
        result.setLong(left % right);
    }

    protected static void mod(float left, float right, Variant result) {
        result.setFloat(left % right);
    }

    protected static void mod(double left, double right, Variant result) {
        result.setDouble(left % right);
    }

    protected static void and(byte left, byte right, Variant result) {
        result.setByte((byte)(left & right));
    }

    protected static void and(short left, short right, Variant result) {
        result.setShort((short)(left & right));
    }

    protected static void and(int left, int right, Variant result) {
        result.setInt(left & right);
    }

    protected static void and(long left, long right, Variant result) {
        result.setLong(left & right);
    }

    protected static void and(float left, float right, Variant result) {
        result.setLong((long)left & (long)right);
    }

    protected static void and(double left, double right, Variant result) {
        result.setLong((long)left & (long)right);
    }

    protected static void or(byte left, byte right, Variant result) {
        result.setByte((byte)(left | right));
    }

    protected static void or(short left, short right, Variant result) {
        result.setShort((short)(left | right));
    }

    protected static void or(int left, int right, Variant result) {
        result.setInt(left | right);
    }

    protected static void or(long left, long right, Variant result) {
        result.setLong(left | right);
    }

    protected static void or(float left, float right, Variant result) {
        result.setLong((long)left | (long)right);
    }

    protected static void or(double left, double right, Variant result) {
        result.setLong((long)left | (long)right);
    }

    protected static void xor(byte left, byte right, Variant result) {
        result.setByte((byte)(left ^ right));
    }

    protected static void xor(short left, short right, Variant result) {
        result.setShort((short)(left ^ right));
    }

    protected static void xor(int left, int right, Variant result) {
        result.setInt(left ^ right);
    }

    protected static void xor(long left, long right, Variant result) {
        result.setLong(left ^ right);
    }

    protected static void xor(float left, float right, Variant result) {
        result.setLong((long)left ^ (long)right);
    }

    protected static void xor(double left, double right, Variant result) {
        result.setLong((long)left ^ (long)right);
    }
}

