/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.expr;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.kdf.expr.ExprError;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.Util;
import com.kingdee.cosmic.ctrl.kdf.expr.VarBase;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;

class VarString
extends VarBase {
    VarString() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Variant vleft = new Variant();
        Variant vright = new Variant();
        if (left.isNumeric(vleft) && right.isNumeric(vright)) {
            result.setVariant(vleft.add(vright));
        } else if (right.getVt() == 11) {
            result.setObject(((String)left.getValue()).concat((String)right.getValue()), 11);
        } else {
            result.setObject(((String)left.getValue()).concat(right.toString()), 11);
        }
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Variant vleft = new Variant();
        Variant vright = new Variant();
        if (left.isNumeric(vleft) && right.isNumeric(vright)) {
            result.setVariant(vleft.subtract(vright));
        } else if (right.getVt() == 11) {
            result.setObject(Util.stringReplaceAll((String)left.getValue(), (String)right.getValue(), ""), 11);
        } else {
            result.setObject(Util.stringReplaceAll((String)left.getValue(), right.toString(), ""), 11);
        }
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Variant vleft = new Variant();
        Variant vright = new Variant();
        if (left.isNumeric(vleft) && right.isNumeric(vright)) {
            result.setVariant(vleft.multiply(vright));
        } else {
            ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Variant vleft = new Variant();
        Variant vright = new Variant();
        if (left.isNumeric(vleft) && right.isNumeric(vright)) {
            result.setVariant(vleft.divide(vright));
        } else {
            ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
        }
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Variant vleft = new Variant();
        Variant vright = new Variant();
        if (left.isNumeric(vleft) && right.isNumeric(vright)) {
            result.setVariant(vleft.mod(vright));
        } else {
            ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
        }
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Variant vleft = new Variant();
        Variant vright = new Variant();
        if (left.isNumeric(vleft) && right.isNumeric(vright)) {
            result.setVariant(vleft.and(vright));
        } else {
            ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
        }
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Variant vleft = new Variant();
        Variant vright = new Variant();
        if (left.isNumeric(vleft) && right.isNumeric(vright)) {
            result.setVariant(vleft.or(vright));
        } else {
            ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
        }
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Variant vleft = new Variant();
        Variant vright = new Variant();
        if (left.isNumeric(vleft) && right.isNumeric(vright)) {
            result.setVariant(vleft.xor(vright));
        } else {
            ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
        }
    }
}

