/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.script.miniscript;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.script.miniscript.MiniScriptParseException;
import com.kingdee.cosmic.ctrl.script.miniscript.MiniScriptRuntimeException;
import com.kingdee.cosmic.ctrl.script.miniscript.ScriptContext;
import com.kingdee.cosmic.ctrl.script.miniscript.ScriptResult;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.ExecutorVisitor;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.ICreateObjectListener;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.IDebugListener;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.IMiniScriptEngineListener;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.IVarRequestor;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.MiniScriptParser;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.MiniScript;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.NodeToken;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.visitor.TreeDumper;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.visitor.TreeFormatter;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.log4j.Logger;

public class MiniScriptEngine {
    private static final Logger logger = LogUtil.getPackageLogger(MiniScriptEngine.class);
    private ScriptContext ctx;
    private boolean debug = false;
    private int[] stopLines = null;
    private Runner runner = null;
    private IMiniScriptEngineListener me = null;
    private IDebugListener debugListener = null;
    private ICreateObjectListener createObjectListener = null;
    private IVarRequestor varRequestor = null;

    public MiniScriptEngine() {
        this(new ScriptContext());
    }

    public MiniScriptEngine(ScriptContext ctx) {
        this.ctx = ctx;
    }

    public void setVarRequestor(IVarRequestor varRequestor) {
        this.varRequestor = varRequestor;
    }

    public static ScriptResult exec(String script, Map varMap) throws MiniScriptParseException {
        return MiniScriptEngine.exec(script, varMap, null);
    }

    public static ScriptResult exec(String script, Map varMap, IVarRequestor varRequestor) throws MiniScriptParseException {
        MiniScriptEngine se = MiniScriptEngine.exec(script, varMap, varRequestor, null, false, null, null);
        ScriptResult re = se.getScriptContext().getScriptResult();
        if (re.withException()) {
            throw re.getRuntimeException();
        }
        return re;
    }

    public void setCreateObjectListener(ICreateObjectListener createObjectListener) {
        this.createObjectListener = createObjectListener;
    }

    public static MiniScriptEngine exec(String script, Map varMap, IVarRequestor varRequestor, int[] stopLines, boolean debug, IMiniScriptEngineListener me, IDebugListener debugListener) throws MiniScriptParseException {
        MiniScriptEngine se = new MiniScriptEngine();
        se.varRequestor = varRequestor;
        se.stopLines = stopLines;
        se.debug = debug;
        se.me = me;
        se.debugListener = debugListener;
        se.parseScript(script);
        se.execute(varMap);
        ScriptResult re = se.getScriptContext().getScriptResult();
        if (re.withException()) {
            throw re.getRuntimeException();
        }
        return se;
    }

    public void resume() {
        if (this.runner != null) {
            this.runner.resume();
        }
    }

    public void stepOver() {
        if (this.runner != null) {
            this.runner.stepOver();
        }
    }

    public void stop() {
        if (this.runner != null && this.runner.isAlive()) {
            this.runner.stop();
        }
    }

    public void parseScript(String script) throws MiniScriptParseException {
        ByteArrayInputStream instm;
        this.ctx.getScriptResult().setRuntimeException(null);
        this.ctx.setScript(script);
        try {
            instm = new ByteArrayInputStream(script.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new MiniScriptParseException(ex);
        }
        this.ctx.setMiniScript(new MiniScriptParser(instm, "utf-8").parse());
    }

    public void execute(Map varMap) {
        this.runner = new Runner(varMap);
        this.runner.start();
    }

    public void executeSync(Map varMap) {
        this.runner = new Runner(varMap);
        this.runner.run();
        if (this.ctx.getScriptResult().withException()) {
            throw this.ctx.getScriptResult().getRuntimeException();
        }
    }

    public ScriptContext getScriptContext() {
        return this.ctx;
    }

    public void dumpScriptTree() {
        System.out.println("----dump script source----");
        TreeDumper dumper = new TreeDumper();
        TreeFormatter tf = new TreeFormatter(4, 80);
        this.ctx.getMiniScript().accept(tf);
        this.ctx.getMiniScript().accept(dumper);
        System.out.println('\n');
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int[] getStopLines() {
        return this.stopLines;
    }

    public void setStopLines(int[] stopLines) {
        this.stopLines = stopLines;
    }

    class Runner
    extends Thread {
        private boolean terminited = false;
        private ExecutorVisitor visitor;

        public Runner(Map varMap) {
            MiniScriptEngine.this.ctx.setInputVar(varMap);
            this.terminited = false;
        }

        public void stepOver() {
            this.visitor.setOneOver(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MiniScript ms = MiniScriptEngine.this.ctx.getMiniScript();
                MiniScriptEngine.this.ctx.setVarRequestor(MiniScriptEngine.this.varRequestor);
                this.visitor = new ExecutorVisitor(MiniScriptEngine.this.ctx, MiniScriptEngine.this.debug, MiniScriptEngine.this.stopLines, MiniScriptEngine.this.debugListener, MiniScriptEngine.this.createObjectListener);
                ms.accept(this.visitor, null);
            }
            catch (Exception e) {
                Throwable t = e;
                if (t instanceof RuntimeException && t.getCause() != null) {
                    t = ((RuntimeException)t).getCause();
                }
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                logger.error((Object)"err", (Throwable)e);
                NodeToken n = this.visitor.getCurrentNodeToken();
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                String s = sw.toString();
                int i = s.indexOf(10);
                if (i > 0) {
                    s = s.substring(0, i);
                }
                String msg = "@Line=" + n.beginLine + "\n" + s;
                MiniScriptEngine.this.ctx.getScriptResult().setRuntimeException(new MiniScriptRuntimeException(msg, t));
            }
            finally {
                this.terminited = true;
                if (MiniScriptEngine.this.me != null) {
                    MiniScriptEngine.this.me.execFinished();
                }
            }
        }

        public boolean isTerminited() {
            return this.terminited;
        }
    }
}

