/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;

public class ScrollBarDrawData
extends RangeDrawData {
    public int thumb;
    public int increment;
    public int pageIncrement;

    public ScrollBarDrawData() {
        this.state = new int[6];
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l = OS.OpenThemeData(0L, this.getClassId());
            RECT rECT = new RECT();
            if ((this.style & 0x200) != 0) {
                int n = OS.GetThemeSysSize(l, 2);
                rECT.left = rectangle.x;
                rECT.right = rECT.left + rectangle.width;
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + n;
                int[] nArray = this.getPartId(1);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.bottom = rectangle.y + rectangle.height;
                rECT.top = rECT.bottom - n;
                nArray = this.getPartId(2);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                int n2 = rectangle.height - 2 * n;
                int n3 = Math.max(n / 2, n2 * this.thumb / Math.max(1, this.maximum - this.minimum));
                int n4 = rectangle.y + n + Math.max(0, n2 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.top = rectangle.y + n;
                rECT.bottom = n4;
                nArray = this.getPartId(3);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.top = rECT.bottom;
                rECT.bottom = rECT.top + n3;
                nArray = this.getPartId(5);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                OS.DrawThemeBackground(l, gC.handle, 9, nArray[1], rECT, null);
                rECT.top = rECT.bottom;
                rECT.bottom = rectangle.y + rectangle.height - n;
                nArray = this.getPartId(4);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
            } else {
                int n = OS.GetThemeSysSize(l, 2);
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + rectangle.height;
                rECT.left = rectangle.x;
                rECT.right = rECT.left + n;
                int[] nArray = this.getPartId(1);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.right = rectangle.x + rectangle.width;
                rECT.left = rECT.right - n;
                nArray = this.getPartId(2);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                int n5 = rectangle.width - 2 * n;
                int n6 = Math.max(n / 2, n5 * this.thumb / (this.maximum - this.minimum));
                int n7 = rectangle.x + n + Math.max(0, n5 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.left = rectangle.x + n;
                rECT.right = n7;
                nArray = this.getPartId(3);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.left = rECT.right;
                rECT.right = rECT.left + n6;
                nArray = this.getPartId(5);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                OS.DrawThemeBackground(l, gC.handle, 8, nArray[1], rECT, null);
                rECT.left = rECT.right;
                rECT.right = rectangle.x + rectangle.width - n;
                nArray = this.getPartId(4);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
            }
            OS.CloseThemeData(l);
        }
    }

    char[] getClassId() {
        return SCROLLBAR;
    }

    int[] getPartId(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.state[n];
        switch (n) {
            case 1: {
                n2 = 1;
                if ((this.style & 0x200) != 0) {
                    n3 = 1;
                    if ((n4 & 0x40) != 0) {
                        n3 = 2;
                    }
                    if ((n4 & 8) != 0) {
                        n3 = 3;
                    }
                    if ((n4 & 0x20) == 0) break;
                    n3 = 4;
                    break;
                }
                n3 = 9;
                if ((n4 & 0x40) != 0) {
                    n3 = 10;
                }
                if ((n4 & 8) != 0) {
                    n3 = 11;
                }
                if ((n4 & 0x20) == 0) break;
                n3 = 12;
                break;
            }
            case 2: {
                n2 = 1;
                if ((this.style & 0x200) != 0) {
                    n3 = 5;
                    if ((n4 & 0x40) != 0) {
                        n3 = 6;
                    }
                    if ((n4 & 8) != 0) {
                        n3 = 7;
                    }
                    if ((n4 & 0x20) == 0) break;
                    n3 = 8;
                    break;
                }
                n3 = 13;
                if ((n4 & 0x40) != 0) {
                    n3 = 14;
                }
                if ((n4 & 8) != 0) {
                    n3 = 15;
                }
                if ((n4 & 0x20) == 0) break;
                n3 = 16;
                break;
            }
            case 0: 
            case 5: {
                if ((this.style & 0x200) != 0) {
                    n2 = 3;
                    break;
                }
                n2 = 2;
                break;
            }
            case 3: {
                if ((this.style & 0x200) != 0) {
                    n2 = 7;
                    break;
                }
                n2 = 5;
                break;
            }
            case 4: {
                n2 = (this.style & 0x200) != 0 ? 6 : 4;
            }
        }
        if (n != 2 && n != 1) {
            n3 = 1;
            if ((n4 & 0x40) != 0) {
                n3 = 2;
            }
            if ((n4 & 8) != 0) {
                n3 = 3;
            }
            if ((n4 & 0x20) != 0) {
                n3 = 4;
            }
        }
        return new int[]{n2, n3};
    }

    Rectangle getBounds(int n, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l = OS.OpenThemeData(0L, this.getClassId());
            if ((this.style & 0x200) != 0) {
                int n2 = OS.GetThemeSysSize(l, 2);
                int n3 = rectangle.height - 2 * n2;
                int n4 = Math.max(n2 / 2, n3 * this.thumb / Math.max(1, this.maximum - this.minimum));
                int n5 = rectangle.y + n2 + Math.max(0, n3 * this.selection / Math.max(1, this.maximum - this.minimum));
                switch (n) {
                    case 2: {
                        return new Rectangle(rectangle.x, rectangle.y + rectangle.height - n2, rectangle.width, n2);
                    }
                    case 1: {
                        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, n2);
                    }
                    case 3: {
                        return new Rectangle(rectangle.x, rectangle.y + n2, rectangle.width, n5 - rectangle.y - n2);
                    }
                    case 5: {
                        return new Rectangle(rectangle.x, n5, rectangle.width, n4);
                    }
                    case 4: {
                        return new Rectangle(rectangle.x, n5 + n4, rectangle.width, rectangle.y + rectangle.height - n2 - n5 - n4);
                    }
                }
            }
            OS.CloseThemeData(l);
        }
        return super.getBounds(n, rectangle);
    }

    int getSelection(Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l = OS.OpenThemeData(0L, this.getClassId());
            if ((this.style & 0x200) != 0) {
                int n = OS.GetThemeSysSize(l, 2);
                int n2 = rectangle.height - 2 * n;
                int n3 = rectangle.y + n + Math.max(0, n2 * this.selection / Math.max(1, this.maximum - this.minimum));
                int n4 = ((n3 += point.y) - rectangle.y - n) * (this.maximum - this.minimum) / n2;
                return Math.max(0, Math.min(n4, this.maximum - this.thumb));
            }
            OS.CloseThemeData(l);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int hit(Theme theme, Point point, Rectangle rectangle) {
        long l;
        block16: {
            int n;
            block22: {
                int n2;
                block21: {
                    int n3;
                    block20: {
                        int n4;
                        block19: {
                            int n5;
                            block18: {
                                int n6;
                                block17: {
                                    int n7;
                                    block15: {
                                        int n8;
                                        block14: {
                                            int n9;
                                            block13: {
                                                int n10;
                                                block12: {
                                                    if (OS.COMCTL32_MAJOR < 6) return -1;
                                                    if (!OS.IsAppThemed()) {
                                                        return -1;
                                                    }
                                                    l = OS.OpenThemeData(0L, this.getClassId());
                                                    int n11 = 0;
                                                    RECT rECT = new RECT();
                                                    POINT pOINT = new POINT();
                                                    pOINT.x = point.x;
                                                    pOINT.y = point.y;
                                                    short[] sArray = new short[1];
                                                    try {
                                                        if ((this.style & 0x200) != 0) {
                                                            int n12 = OS.GetThemeSysSize(l, 2);
                                                            rECT.left = rectangle.x;
                                                            rECT.right = rECT.left + rectangle.width;
                                                            rECT.top = rectangle.y;
                                                            rECT.bottom = rECT.top + n12;
                                                            int[] nArray = this.getPartId(1);
                                                            OS.HitTestThemeBackground(l, n11, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                                                            if (sArray[0] != 0) {
                                                                n10 = 1;
                                                                Object var17_19 = null;
                                                                break block12;
                                                            }
                                                            rECT.bottom = rectangle.y + rectangle.height;
                                                            rECT.top = rECT.bottom - n12;
                                                            nArray = this.getPartId(2);
                                                            OS.HitTestThemeBackground(l, n11, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                                                            if (sArray[0] != 0) {
                                                                n9 = 2;
                                                                break block13;
                                                            }
                                                            int n13 = rectangle.height - 2 * n12;
                                                            int n14 = Math.max(n12 / 2, n13 * this.thumb / Math.max(1, this.maximum - this.minimum));
                                                            int n15 = rectangle.y + n12 + Math.max(0, n13 * this.selection / Math.max(1, this.maximum - this.minimum));
                                                            rECT.top = rectangle.y + n12;
                                                            rECT.bottom = n15;
                                                            nArray = this.getPartId(5);
                                                            OS.HitTestThemeBackground(l, n11, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                                                            if (sArray[0] != 0) {
                                                                n8 = 3;
                                                                break block14;
                                                            }
                                                            rECT.top = rECT.bottom;
                                                            rECT.bottom = rECT.top + n14;
                                                            nArray = this.getPartId(3);
                                                            OS.HitTestThemeBackground(l, n11, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                                                            if (sArray[0] != 0) {
                                                                n7 = 5;
                                                                break block15;
                                                            }
                                                            rECT.top = rECT.bottom;
                                                            rECT.bottom = rectangle.y + rectangle.height - n12;
                                                            nArray = this.getPartId(4);
                                                            OS.HitTestThemeBackground(l, n11, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                                                            if (sArray[0] == 0) break block16;
                                                            n6 = 4;
                                                            break block17;
                                                        }
                                                        int n16 = OS.GetThemeSysSize(l, 2);
                                                        rECT.top = rectangle.y;
                                                        rECT.bottom = rECT.top + rectangle.height;
                                                        rECT.left = rectangle.x;
                                                        rECT.right = rECT.left + n16;
                                                        int[] nArray = this.getPartId(1);
                                                        OS.HitTestThemeBackground(l, n11, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                                                        if (sArray[0] != 0) {
                                                            n5 = 1;
                                                            break block18;
                                                        }
                                                        rECT.right = rectangle.x + rectangle.width;
                                                        rECT.left = rECT.right - n16;
                                                        nArray = this.getPartId(2);
                                                        OS.HitTestThemeBackground(l, n11, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                                                        if (sArray[0] != 0) {
                                                            n4 = 2;
                                                            break block19;
                                                        }
                                                        int n17 = rectangle.width - 2 * n16;
                                                        int n18 = Math.max(n16 / 2, n17 * this.thumb / (this.maximum - this.minimum));
                                                        int n19 = rectangle.x + n16 + Math.max(0, n17 * this.selection / Math.max(1, this.maximum - this.minimum));
                                                        rECT.left = rectangle.x + n16;
                                                        rECT.right = n19;
                                                        nArray = this.getPartId(3);
                                                        OS.HitTestThemeBackground(l, n11, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                                                        if (sArray[0] != 0) {
                                                            n3 = 3;
                                                            break block20;
                                                        }
                                                        rECT.left = rECT.right;
                                                        rECT.right = rECT.left + n18;
                                                        nArray = this.getPartId(5);
                                                        OS.HitTestThemeBackground(l, n11, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                                                        if (sArray[0] != 0) {
                                                            n2 = 5;
                                                            break block21;
                                                        }
                                                        rECT.left = rECT.right;
                                                        rECT.right = rectangle.x + rectangle.width - n16;
                                                        nArray = this.getPartId(4);
                                                        OS.HitTestThemeBackground(l, n11, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                                                        if (sArray[0] == 0) break block16;
                                                        n = 4;
                                                        break block22;
                                                    }
                                                    catch (Throwable throwable) {
                                                        Object var17_30 = null;
                                                        OS.CloseThemeData(l);
                                                        throw throwable;
                                                    }
                                                }
                                                OS.CloseThemeData(l);
                                                return n10;
                                            }
                                            Object var17_20 = null;
                                            OS.CloseThemeData(l);
                                            return n9;
                                        }
                                        Object var17_21 = null;
                                        OS.CloseThemeData(l);
                                        return n8;
                                    }
                                    Object var17_22 = null;
                                    OS.CloseThemeData(l);
                                    return n7;
                                }
                                Object var17_23 = null;
                                OS.CloseThemeData(l);
                                return n6;
                            }
                            Object var17_24 = null;
                            OS.CloseThemeData(l);
                            return n5;
                        }
                        Object var17_25 = null;
                        OS.CloseThemeData(l);
                        return n4;
                    }
                    Object var17_26 = null;
                    OS.CloseThemeData(l);
                    return n3;
                }
                Object var17_27 = null;
                OS.CloseThemeData(l);
                return n2;
            }
            Object var17_28 = null;
            OS.CloseThemeData(l);
            return n;
        }
        Object var17_29 = null;
        OS.CloseThemeData(l);
        return -1;
    }
}

