/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.event;

import java.util.EventObject;
import java.util.HashMap;

public final class RequestDataEvent
extends EventObject {
    private static final long serialVersionUID = 425412991611873236L;
    private static final String[] NULL_STRING_ARRAY = new String[0];
    private String query;
    private HashMap filterMap = new HashMap();
    private String[] filter;

    private void searchFilter(String query) {
        String source = query;
        String prefix = ":{";
        String postfix = "}";
        this.filterMap.clear();
        int fromIndex = 0;
        int start = 0;
        int end = 0;
        int start2 = 0;
        while ((start = source.indexOf(prefix, fromIndex)) >= 0 && (end = source.indexOf(postfix, fromIndex = start + 3)) >= 0) {
            start2 = source.indexOf(prefix, fromIndex);
            if (start2 >= 0 && end > start2) {
                fromIndex = start2;
            } else {
                fromIndex = end + 1;
                this.filterMap.put(source.substring(start + 2, end), null);
            }
            if (start >= 0) continue;
        }
    }

    public RequestDataEvent(Object source, String query) {
        super(source);
        this.parseQuery(query);
    }

    private void parseQuery(String query) {
        if (null == query) {
            this.query = "";
            this.filter = NULL_STRING_ARRAY;
        } else {
            this.query = query;
            this.searchFilter(this.query);
            this.filter = this.filterMap.keySet().toArray(NULL_STRING_ARRAY);
        }
    }

    public String getRawQuery() {
        return this.query;
    }

    public String getQuery() {
        StringBuilder sb = new StringBuilder(this.query);
        for (int i = 0; i < this.filter.length; ++i) {
            Object value = this.filterMap.get(this.filter[i]);
            if (value == null) continue;
            String subStr = ":{" + this.filter[i] + "}";
            int start = sb.indexOf(subStr);
            sb.replace(start, start + subStr.length(), value.toString());
        }
        return sb.toString();
    }

    public void setQuery(String query) {
        this.parseQuery(query);
    }

    public String[] getFilterList() {
        return this.filter;
    }

    public String getFilter(String filter) {
        Object value = this.filterMap.get(filter);
        if (value != null) {
            return (String)value;
        }
        return "";
    }

    public void setFilter(String filter, String value) {
        this.filterMap.put(filter, value);
    }
}

