/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.cosmic.ctrl.common.GlobalLocator;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.SystemPropertyUtil;
import com.kingdee.cosmic.ctrl.kdf.data.config.BOSConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

final class BOSConnection {
    private static final Logger logger = LogUtil.getPackageLogger(BOSConnection.class);
    private static BOSConnection instance;
    private ArrayList clients;
    private ArrayList conn;
    private HashMap nameMap;
    private BOSConfig boscfg;
    private static HashMap localeMap;

    private BOSConnection(BOSConfig cfg) {
        this.boscfg = cfg;
        this.nameMap = new HashMap();
        int size = cfg.getBOSInfoSize();
        this.clients = new ArrayList(size);
        this.conn = new ArrayList(size);
    }

    public static BOSConnection instance() {
        if (instance == null) {
            File f = GlobalLocator.getInstance().locateResourceFile("/server/BOSConfig.xml");
            BOSConfig boscfg = new BOSConfig(f.getPath());
            instance = new BOSConnection(boscfg);
        }
        return instance;
    }

    public static Locale getLocale(String locale) {
        if (locale != null) {
            return (Locale)localeMap.get(locale.toLowerCase());
        }
        return (Locale)localeMap.get(locale);
    }

    public static void main(String[] args) {
        try {
            BOSConnection ins = BOSConnection.instance();
            SystemPropertyUtil.setString((String)"user.dir", (String)"C:\\Documents and Settings\\hibor");
            LoginContext loginContext = ins.getConnection("0");
        }
        catch (Exception ex) {
            logger.error((Object)"err", (Throwable)ex);
        }
    }

    public LoginContext getConnection(String id) throws BOSException {
        Integer index = (Integer)this.nameMap.get(id);
        if (index != null) {
            int idx = index;
            this.clients.set(idx, (Integer)this.clients.get(idx) + 1);
            return (LoginContext)this.conn.get(idx);
        }
        BOSConfig.BOSInfo bosi = this.boscfg.getBOSInfo(id);
        if (bosi == null && id == null && this.boscfg.getBOSInfoSize() > 0) {
            bosi = this.boscfg.getBOSInfo(0);
        }
        if (bosi != null) {
            LoginContext ctx = new LoginContext(bosi.user, bosi.pwd, bosi.solution, bosi.ais, new Locale(bosi.locale, ""));
            ORMRPCServiceLocator.setCurrentServiceURL((String)bosi.url);
            ILoginModule login = LoginModuleFactory.getRemoteInstance();
            try {
                login.login(ctx);
            }
            catch (BOSLoginException e) {
                logger.error((Object)"err", (Throwable)e);
            }
            this.clients.add(1);
            this.conn.add(ctx);
            this.nameMap.put(id, this.clients.size() - 1);
            return ctx;
        }
        return null;
    }

    static {
        localeMap = new HashMap();
        localeMap.put("en", Locale.ENGLISH);
        localeMap.put("fr", Locale.FRENCH);
        localeMap.put("de", Locale.GERMAN);
        localeMap.put("it", Locale.ITALIAN);
        localeMap.put("ja", Locale.JAPANESE);
        localeMap.put("ko", Locale.KOREAN);
        localeMap.put("zh", Locale.CHINESE);
        localeMap.put("zh-cn", Locale.SIMPLIFIED_CHINESE);
        localeMap.put("zh-tw", Locale.TRADITIONAL_CHINESE);
        localeMap.put("fr-fr", Locale.FRANCE);
        localeMap.put("de-de", Locale.GERMANY);
        localeMap.put("it-it", Locale.ITALY);
        localeMap.put("ja-jp", Locale.JAPAN);
        localeMap.put("ko-kr", Locale.KOREA);
        localeMap.put("en-gb", Locale.UK);
        localeMap.put("en-us", Locale.US);
        localeMap.put("en-ca", Locale.CANADA);
        localeMap.put("fr-ca", Locale.CANADA_FRENCH);
    }
}

