/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.impl;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.data.impl.XmlDynamicRowSet;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.Base64;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXHandler
extends DefaultHandler {
    private static final Logger logger = LogUtil.getPackageLogger(SAXHandler.class);
    public static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private boolean metadataTag = false;
    private boolean rowTag = false;
    private ArrayList fields;
    private ArrayList colTypes;
    private int colCount = 0;
    private int colPosition = 0;
    private ArrayList rowset;
    private ArrayList values = null;
    private String value;
    private int rowPosition;
    private XmlDynamicRowSet xmlRowSet;

    public SAXHandler(XmlDynamicRowSet xmlRowSet) {
        this.xmlRowSet = xmlRowSet;
    }

    @Override
    public void startDocument() throws SAXException {
        this.fields = new ArrayList();
        this.colTypes = new ArrayList();
        this.rowset = new ArrayList(100);
        this.rowPosition = 0;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.xmlRowSet != null) {
            this.xmlRowSet.values = this.rowset;
            this.xmlRowSet.fields = this.fields;
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        this.value = "";
        if (!eName.equalsIgnoreCase("Table")) {
            if (eName.equalsIgnoreCase("MetaData")) {
                if (this.fields != null) {
                    this.fields.clear();
                }
                if (this.colTypes != null) {
                    this.colTypes.clear();
                }
                this.metadataTag = true;
            } else if (!eName.equalsIgnoreCase("Column") && !eName.equalsIgnoreCase("Content") && eName.equalsIgnoreCase("Row")) {
                if (this.colCount > 0) {
                    this.values = new ArrayList(this.colCount);
                    this.colPosition = 0;
                }
                ++this.rowPosition;
                this.rowTag = true;
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (!eName.equalsIgnoreCase("Table")) {
            if (eName.equalsIgnoreCase("MetaData")) {
                this.metadataTag = false;
            } else if (!eName.equalsIgnoreCase("Column")) {
                if (eName.equalsIgnoreCase("Name")) {
                    String col = this.value.trim();
                    ++this.colCount;
                    if (col.length() > 0) {
                        this.fields.add(col);
                    } else {
                        this.fields.add("COL" + this.colCount);
                    }
                } else if (eName.equalsIgnoreCase("Type")) {
                    String type = this.value.trim();
                    if (type.length() > 0) {
                        this.colTypes.add(type);
                    } else {
                        this.fields.add("String");
                    }
                } else if (!eName.equalsIgnoreCase("Content")) {
                    if (eName.equalsIgnoreCase("Row")) {
                        this.rowTag = false;
                        this.rowset.add(this.values);
                    } else if (eName.equalsIgnoreCase("Data") && this.rowTag) {
                        int index = this.colPosition++;
                        String coltype = (String)this.colTypes.get(index);
                        this.values.add(this.getField(coltype, this.value));
                    }
                }
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.metadataTag || this.rowTag) {
            this.value = this.value + String.valueOf(buf, offset, len);
        }
    }

    private Variant getField(String coltype, String s) {
        Variant var = new Variant();
        if (coltype.equalsIgnoreCase("String")) {
            var.setObject((Object)s, 11);
        } else if (coltype.equalsIgnoreCase("Integer")) {
            try {
                int val = Integer.parseInt(s);
                var.setInt(val);
            }
            catch (NumberFormatException nfe) {
                var.setInt(0);
                logger.error((Object)"err", (Throwable)nfe);
            }
        } else if (coltype.equalsIgnoreCase("Float")) {
            try {
                float val = Float.parseFloat(s);
                var.setFloat(val);
            }
            catch (NumberFormatException nfe) {
                var.setFloat(0.0f);
                logger.error((Object)"err", (Throwable)nfe);
            }
        } else if (coltype.equalsIgnoreCase("Double")) {
            try {
                double val = Double.parseDouble(s);
                var.setDouble(val);
            }
            catch (NumberFormatException nfe) {
                var.setDouble(0.0);
                logger.error((Object)"err", (Throwable)nfe);
            }
        } else if (coltype.equalsIgnoreCase("Decimal")) {
            try {
                BigDecimal val = new BigDecimal(s);
                var.setObject((Object)val, 10);
            }
            catch (NumberFormatException nfe) {
                var.setObject((Object)BigDecimal.valueOf(0.0), 10);
                logger.error((Object)"err", (Throwable)nfe);
            }
        } else if (coltype.equalsIgnoreCase("Numeric")) {
            try {
                BigDecimal val = new BigDecimal(s);
                var.setObject((Object)val, 10);
            }
            catch (NumberFormatException nfe) {
                var.setObject((Object)BigDecimal.valueOf(0.0), 10);
                logger.error((Object)"err", (Throwable)nfe);
            }
        } else if (coltype.equalsIgnoreCase("Date")) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat();
                Date val = dateFormat.parse(s);
                var.setObject((Object)val, 12);
            }
            catch (ParseException pe) {
                var.setObject((Object)new Date(), 12);
                logger.error((Object)"err", (Throwable)pe);
            }
        } else if (coltype.equalsIgnoreCase("Binary")) {
            try {
                byte[] bs = Base64.decode((String)s);
                var.setObject((Object)bs, 512);
            }
            catch (Exception e) {
                var.setObject((Object)new byte[0], 512);
                logger.error((Object)"err", (Throwable)e);
            }
        } else {
            var.setObject((Object)s, 11);
        }
        return var;
    }
}

