/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.wizard;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.data.query.KDBasicQuery;
import com.kingdee.cosmic.ctrl.kdf.data.query.KDQuery;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryDir;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryTable;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.IKDMAdapter;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.ISQLGenerator;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.KDDataWizard;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.KDDataWizardQry2DirPath;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.KDDataWizardSQLGenerator;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.event.DataManipulationListener;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.event.DeleteEvent;
import com.kingdee.cosmic.ctrl.kdf.util.SimpleQueue;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public final class KDDataManager {
    private HashMap querys;
    private HashMap customQuerys;
    private QueryDir dirRoot;
    private QueryDir dirSystem;
    private QueryDir dirCustomer;
    private static HashMap dbImport;
    private IKDMAdapter kdmAdapter;
    private ISQLGenerator sqlGenerator;
    private KDDataWizard dataWizard;
    private ArrayList dataEventListeners;
    private static long ID_SEED;
    protected static final String DEFAULTTABLENAME = "queryTable";
    protected static final String DEFAULTCOLUMNNAME = "queryColumn";
    private static final String METAPATH;
    private static Logger logger;

    protected void fireDataEvent(DeleteEvent evt) {
        for (DataManipulationListener listener : this.dataEventListeners) {
            listener.fireDeleteEvent(evt);
        }
    }

    public ISQLGenerator getSqlGenerator() {
        if (this.sqlGenerator == null) {
            this.sqlGenerator = new KDDataWizardSQLGenerator();
        }
        return this.sqlGenerator;
    }

    public void setSqlGenerator(ISQLGenerator sqlGenerator) {
        this.sqlGenerator = sqlGenerator;
    }

    public KDBasicQuery getQuery(String queryID) {
        return (KDBasicQuery)this.getQuerys().get(queryID);
    }

    public KDBasicQuery removeQuery(String queryID) {
        return (KDBasicQuery)this.getQuerys().remove(queryID);
    }

    public Object addQuery(KDBasicQuery query, QueryDir dir) {
        this.getCustomQuerys().put(query.getID(), query);
        dir.add(query);
        this.getQuerys().put(query.getID(), query);
        return null;
    }

    public HashMap getQuerys() {
        return this.querys;
    }

    public HashMap getCustomQuerys() {
        return this.customQuerys;
    }

    protected void setQuerys(HashMap querys) {
        this.querys = querys;
    }

    public void showWizard(Frame parent) {
        if (this.dataWizard == null) {
            this.dataWizard = new KDDataWizard(parent, this);
        }
        this.dataWizard.setVisible(true);
        this.dataWizard.setModal(true);
    }

    public void showWizard(Dialog parent) {
        if (this.dataWizard == null) {
            this.dataWizard = new KDDataWizard(parent, this);
        }
        this.dataWizard.setVisible(true);
        this.dataWizard.setModal(true);
    }

    public boolean checkHasBeenRefered(KDQuery kdQry) {
        Iterator it = this.getQuerys().values().iterator();
        Iterator itQry = null;
        Object objTemp = null;
        QueryTable QryTab2 = null;
        while (it.hasNext()) {
            objTemp = it.next();
            if (!(objTemp instanceof KDQuery) || kdQry.equals(objTemp)) continue;
            for (QueryTable QryTab2 : ((KDQuery)objTemp).getSubQueryList()) {
                if (!(QryTab2.getBasicQuery() instanceof KDQuery) || !QryTab2.getBasicQuery().getID().equals(kdQry.getID())) continue;
                return true;
            }
        }
        return false;
    }

    public int getReferedQry(QueryDir dir, KDBasicQuery kdQry, String path, SimpleQueue queDelQry, SimpleQueue queDelQryPath, int delCount) {
        Iterator iter = dir.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof QueryDir) {
                delCount += this.getReferedQry((QueryDir)obj, kdQry, path + "/" + ((QueryDir)obj).getName(), queDelQry, queDelQryPath, delCount);
                continue;
            }
            if (!(obj instanceof KDQuery) || queDelQry.contains(obj) || kdQry.equals(obj)) continue;
            for (QueryTable QryTab : ((KDQuery)obj).getSubQueryList()) {
                if (!QryTab.getBasicQuery().getID().equals(kdQry.getID())) continue;
                KDDataWizardQry2DirPath qry2path = new KDDataWizardQry2DirPath((KDQuery)obj, dir, path + "/" + ((KDQuery)obj).getName());
                queDelQryPath.put(qry2path);
                queDelQry.put(obj);
                ++delCount;
            }
        }
        return delCount;
    }

    public String getUniqueID(String prefix, String postfix) {
        String id = KDDataManager.getID(prefix, postfix);
        while (this.getCustomQuerys().containsKey(id)) {
            id = KDDataManager.getID(prefix, postfix);
        }
        return id;
    }

    public static synchronized String getID(String prefix, String postfix) {
        ++ID_SEED;
        if (prefix == null) {
            prefix = "";
        }
        if (postfix == null) {
            postfix = "";
        }
        return prefix + ID_SEED + postfix;
    }

    public QueryDir getDirRoot() {
        if (this.dirRoot == null) {
            this.dirRoot = new QueryDir("Root", CtrlKDFMessages.getMLS("root", "\u6839\u76ee\u5f55"));
        }
        return this.dirRoot;
    }

    public void setDirRoot(QueryDir dirRoot) {
        this.dirRoot = dirRoot;
    }

    public QueryDir getDirCustomer() {
        if (this.dirCustomer == null) {
            this.dirCustomer = new QueryDir("dirCustomer", CtrlKDFMessages.getMLS("dirCustomer", "\u7528\u6237\u67e5\u8be2\u5bf9\u8c61"));
        }
        return this.dirCustomer;
    }

    public QueryDir getDirSystem() {
        if (this.dirSystem == null) {
            this.dirSystem = new QueryDir("dirSystem", CtrlKDFMessages.getMLS("dirSystem", "\u7cfb\u7edf\u67e5\u8be2\u5bf9\u8c61"));
        }
        return this.dirSystem;
    }

    protected void setDirSystem(QueryDir dirSystem) {
        this.dirSystem = dirSystem;
    }

    public synchronized HashMap getDbImport() {
        if (dbImport == null) {
            dbImport = new HashMap();
        }
        return dbImport;
    }

    static {
        ID_SEED = 1L;
        METAPATH = System.getProperty("user.dir") + File.separator + "conf" + File.separator + "meta";
        logger = LogUtil.getLogger(KDDataManager.class);
    }
}

