/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.excel;

import com.kingdee.cosmic.ctrl.kdf.excel.AbstractDataWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MultiPartMergeData {
    private static final String FROMATE_COL_STRING = "col=%d;col2=%d";
    private static final ThreadLocal<MultiPartMergeData> LOCAL = new ThreadLocal<MultiPartMergeData>(){

        @Override
        public MultiPartMergeData initialValue() {
            return new MultiPartMergeData();
        }
    };
    private Map<String, List<AbstractDataWrapper.MergeBlock>> blockMap = new LinkedHashMap<String, List<AbstractDataWrapper.MergeBlock>>();
    private List<AbstractDataWrapper.MergeBlock> excludeList = new ArrayList<AbstractDataWrapper.MergeBlock>();

    public static final MultiPartMergeData getData() {
        return LOCAL.get();
    }

    public String getKey(AbstractDataWrapper.MergeBlock b) {
        return this.getColKey(b.getCol(), b.getCol2());
    }

    private String getColKey(int col, int col2) {
        return String.format(FROMATE_COL_STRING, col, col2);
    }

    public AbstractDataWrapper.MergeBlock merge(AbstractDataWrapper.MergeBlock block) {
        AbstractDataWrapper.MergeBlock b = block;
        if (null != b) {
            List<AbstractDataWrapper.MergeBlock> blocks = this.blockMap.get(this.getKey(b));
            if (null != blocks) {
                AbstractDataWrapper.MergeBlock tail;
                if (!blocks.isEmpty() && this.checkCanMerge(tail = blocks.get(blocks.size() - 1), b)) {
                    b = tail.merge(b);
                    blocks.remove(blocks.size() - 1);
                }
                blocks.add(b);
            } else {
                this.addBlock(b);
            }
        }
        return b;
    }

    public List<AbstractDataWrapper.MergeBlock> getBlocks(AbstractDataWrapper.MergeBlock b) {
        if (null == b) {
            return new ArrayList<AbstractDataWrapper.MergeBlock>();
        }
        return this.blockMap.get(this.getKey(b));
    }

    public AbstractDataWrapper.MergeBlock getMergeBlockContains(int row1, int col1, int row2, int col2) {
        List<AbstractDataWrapper.MergeBlock> blocks = this.blockMap.get(this.getColKey(col1, col2));
        if (null != blocks && !blocks.isEmpty()) {
            for (int i = blocks.size() - 1; i >= 0; --i) {
                AbstractDataWrapper.MergeBlock block = blocks.get(i);
                if (!block.contains(row1, col1, row2, col2)) continue;
                return blocks.get(i);
            }
        }
        return null;
    }

    public List<AbstractDataWrapper.MergeBlock> getBlocks(int col1, int col2) {
        return this.blockMap.get(this.getColKey(col1, col2));
    }

    public AbstractDataWrapper.MergeBlock getLastBlock(int col1, int col2) {
        List<AbstractDataWrapper.MergeBlock> mergeBlocks = this.getBlocks(col1, col2);
        if (null != mergeBlocks && !mergeBlocks.isEmpty()) {
            return mergeBlocks.get(mergeBlocks.size() - 1);
        }
        return null;
    }

    public void mergeAll() {
        AbstractDataWrapper.MergeBlock last = null;
        AbstractDataWrapper.MergeBlock pre = null;
        ArrayList<AbstractDataWrapper.MergeBlock> tempBlocks = null;
        for (Map.Entry<String, List<AbstractDataWrapper.MergeBlock>> entry : this.blockMap.entrySet()) {
            List<AbstractDataWrapper.MergeBlock> blocks = entry.getValue();
            if (null != blocks && !blocks.isEmpty()) {
                tempBlocks = new ArrayList<AbstractDataWrapper.MergeBlock>();
                tempBlocks.add(blocks.get(blocks.size() - 1));
                for (int i = blocks.size() - 1; i > 0; --i) {
                    last = (AbstractDataWrapper.MergeBlock)tempBlocks.remove(tempBlocks.size() - 1);
                    pre = blocks.get(i - 1);
                    if (this.checkCanMerge(pre, last)) {
                        pre = pre.merge(last);
                        tempBlocks.add(pre);
                        continue;
                    }
                    tempBlocks.add(last);
                    tempBlocks.add(pre);
                }
            }
            Collections.reverse(tempBlocks);
            entry.setValue(tempBlocks);
        }
    }

    private boolean checkCanMerge(AbstractDataWrapper.MergeBlock a, AbstractDataWrapper.MergeBlock b) {
        boolean flag = false;
        if (!this.isExculdeRowContains(b)) {
            if (b.getRow2() < a.getRow2()) {
                AbstractDataWrapper.MergeBlock temp = a;
                a = b;
                b = temp;
            }
            if (a.getRow2() == b.getRow() - 1 || a.getRow2() == b.getRow()) {
                if (a.getGroup().equals(b.getGroup())) {
                    flag = true;
                } else {
                    this.excludeList.add(b);
                }
            }
        }
        return flag;
    }

    public boolean isExculdeRowContains(AbstractDataWrapper.MergeBlock b) {
        for (int i = this.excludeList.size() - 1; i >= 0; --i) {
            if (this.excludeList.get(i).getRow() > b.getRow() || this.excludeList.get(i).getRow2() < b.getRow2()) continue;
            return true;
        }
        return false;
    }

    public AbstractDataWrapper.MergeBlock getMergeBlock(int row, int col, int row2, int col2, String group) {
        AbstractDataWrapper.MergeBlock block = AbstractDataWrapper.getMergeBlock(row, col, row2, col2);
        block.setGroup(group);
        return new AbstractDataWrapper.MergeBlock(block);
    }

    public void addBlock(AbstractDataWrapper.MergeBlock b) {
        if (null == b) {
            return;
        }
        List<AbstractDataWrapper.MergeBlock> blcoks = this.blockMap.get(this.getKey(b));
        if (null == blcoks) {
            blcoks = new ArrayList<AbstractDataWrapper.MergeBlock>();
            this.blockMap.put(this.getKey(b), blcoks);
        }
        blcoks.add(b);
    }

    public List<AbstractDataWrapper.MergeBlock> getAllBlocks() {
        ArrayList<AbstractDataWrapper.MergeBlock> result = new ArrayList<AbstractDataWrapper.MergeBlock>();
        for (Map.Entry<String, List<AbstractDataWrapper.MergeBlock>> entry : this.blockMap.entrySet()) {
            for (AbstractDataWrapper.MergeBlock block : entry.getValue()) {
                result.add(block);
            }
        }
        return result;
    }

    public void clear() {
        this.blockMap.clear();
        this.excludeList.clear();
        LOCAL.remove();
    }
}

