/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.excel.wrapper;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.cosmic.ctrl.kdf.excel.MultiPartMergeData;
import com.kingdee.cosmic.ctrl.kdf.excel.ui.EventQueue;
import com.kingdee.cosmic.ctrl.kdf.excel.ui.ExportEvent;
import com.kingdee.cosmic.ctrl.kdf.excel.wrapper.IExportWrapper;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheetPrintSetup;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.DigitFormatPane;
import com.kingdee.cosmic.ctrl.print.printjob.table.ITableForPrint;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class SXSSFExportWrapper
implements IExportWrapper {
    private static final Logger logger = LogUtil.getPackageLogger(SXSSFExportWrapper.class);
    private AbstractDataWrapper dataSource;
    private SXSSFWorkbook workbook;
    private Sheet currentSheet;
    private boolean notify = true;
    private EventQueue queue;
    private CellStyle dateStyle;
    private CellStyle dateTimeStyle;
    private CellStyle emptyStyle;
    private DataFormat format;
    private HashMap<Integer, Object> stylesMap;
    private HashMap<Integer, Object> fontsMap;
    private MultiPartMergeData mutiPartMergeData;
    private int topGroupIndex;
    private int lastGroupIndex;
    private static int DEFAULT_KEEP_ROWS = 500;
    private boolean isHorizontal = false;
    private int mergeBlockStart = 1;

    public SXSSFExportWrapper(AbstractDataWrapper dataSource) {
        this.dataSource = dataSource;
        this.workbook = new SXSSFWorkbook(DEFAULT_KEEP_ROWS);
        this.emptyStyle = this.workbook.createCellStyle();
        this.format = this.workbook.createDataFormat();
        this.stylesMap = new HashMap();
        this.fontsMap = new HashMap();
        this.mutiPartMergeData = MultiPartMergeData.getData();
        this.topGroupIndex = dataSource.getTopGroupColIndex();
        this.lastGroupIndex = dataSource.getLastGroupColIndex();
    }

    public void setNOTIFY(boolean nOTIFY) {
        this.notify = nOTIFY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(OutputStream out) {
        boolean flag = false;
        long startTimeAll = System.currentTimeMillis();
        try {
            if (this.queue != null && this.notify) {
                this.queue.enQueue(new ExportEvent("export workbook", "add embedObjects"));
            }
            this.dataSource.configSourceRepaint(false);
            int sheetCount = this.dataSource.getSheetCount();
            int j = 0;
            for (int i = 0; i < sheetCount; ++i) {
                String sheetName = this.dataSource.sheetName(i);
                if (StringUtil.isEmptyString((String)sheetName)) {
                    ++j;
                    continue;
                }
                this.dataSource.setCurrentSheetIndex(i);
                this.currentSheet = this.workbook.createSheet(sheetName);
                this.workbook.setSheetHidden(i - j, this.dataSource.isHideSheet(i));
                this.fillSheet(this.currentSheet);
                this.addProtection(this.currentSheet);
                for (AbstractDataWrapper.MergeBlock merge : this.mutiPartMergeData.getAllBlocks()) {
                    if (merge.getCol() == -1 || merge.getRow() == merge.getRow2() && merge.getCol() == merge.getCol2()) continue;
                    CellRangeAddress cra = new CellRangeAddress(merge.getRow(), merge.getRow2(), merge.getCol(), merge.getCol2());
                    this.currentSheet.addMergedRegion(cra);
                }
                this.mutiPartMergeData.clear();
                this.addFreezeLine(this.currentSheet);
                this.printSetup(this.currentSheet);
                this.addEmbed(this.currentSheet);
                this.addGridLine(this.currentSheet);
                this.addGroupInfo(this.currentSheet);
            }
            this.workbook.write(out);
            out.flush();
            this.dataSource.configSourceRepaint(true);
            if (this.queue != null && this.notify) {
                this.queue.complete(new ExportEvent("export workbook", "(" + (System.currentTimeMillis() - startTimeAll) + " ms consumed)!"));
            }
            flag = true;
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
            if (this.queue != null) {
                this.queue.complete(new ExportEvent("export workbook", "exception occur:" + e.getMessage()));
            }
        }
        finally {
            if (null != this.workbook) {
                try {
                    this.workbook.close();
                }
                catch (IOException e) {
                    logger.error((Object)"err", (Throwable)e);
                }
            }
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error((Object)"err", (Throwable)e);
                }
            }
        }
        return flag;
    }

    @Override
    public boolean write(String filePath) {
        try {
            FileOutputStream out = new FileOutputStream(FilenameUtils.normalize((String)filePath));
            return this.write(out);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"err", (Throwable)e);
            this.queue.complete(new ExportEvent("export workbook", "exception occur:" + e.getMessage()));
            return false;
        }
    }

    private void fillSheet(Sheet currentSheet) throws IOException {
        int rowNum = 0;
        int excelRowNum = 0;
        int rowIndex = 0;
        if (currentSheet instanceof SXSSFSheet) {
            ((SXSSFSheet)currentSheet).setRandomAccessWindowSize(-1);
        }
        boolean isMergeHeadRowsExport = this.dataSource.isMergeHeadRowsExport();
        while (!this.dataSource.isRowEnd(rowNum)) {
            if (this.dataSource.isHideRow(rowNum) || this.dataSource.isExportHeadRow(rowNum) && rowNum == 1 && isMergeHeadRowsExport) {
                ++rowNum;
                continue;
            }
            if (excelRowNum > 1048575) {
                throw new IllegalArgumentException("too much rows!");
            }
            Row row = currentSheet.createRow(rowIndex++);
            this.fillRow(row, rowNum, excelRowNum);
            ++excelRowNum;
            ++rowNum;
        }
    }

    public String getSheetName() {
        return this.currentSheet.getSheetName();
    }

    private void fillRow(Row row, int rowNum, int excelRowNum) throws IOException {
        if (this.queue != null && this.notify) {
            ExportEvent event = new ExportEvent("export sheet(" + this.getSheetName() + ")", "filling data(" + excelRowNum + ")");
            event.setRow(rowNum);
            this.queue.enQueue(event);
        }
        int colNum = 0;
        int excelColNum = 0;
        int cellIndex = 0;
        boolean isMergeHeadRowsExport = this.dataSource.isMergeHeadRowsExport();
        if (this.dataSource.rowHeightAt(rowNum) != 19) {
            row.setHeight((short)((double)this.dataSource.rowHeightAt(rowNum) / 19.0 * 14.25 * 20.0));
        }
        while (!this.dataSource.isColEnd(colNum)) {
            int valueType;
            Object value;
            if (this.dataSource.isHideCol(colNum)) {
                ++colNum;
                continue;
            }
            Cell cell = row.createCell(cellIndex++);
            if (row.getRowNum() == 0) {
                this.currentSheet.setColumnWidth(colNum, this.dataSource.colWidthAt(colNum) * 33);
            }
            if (this.dataSource.isExportHeadRow(rowNum) && rowNum == 0 && isMergeHeadRowsExport) {
                value = this.reSetHeadValue(rowNum, colNum);
                valueType = 1;
            } else {
                value = this.dataSource.valueAt(rowNum, colNum);
                valueType = this.dataSource.valueTypeAt(rowNum, colNum);
            }
            String formula = this.dataSource.formulaAt(rowNum, colNum);
            if (excelColNum > 16383) {
                throw new IOException("too much columns!");
            }
            if (this.dataSource.isExportMergeBlocks() || this.dataSource.isExportHeadRow(rowNum)) {
                AbstractDataWrapper.MergeBlock block;
                this.addOrWriteMergeData(rowNum, colNum, excelRowNum, excelColNum);
                if (colNum <= this.lastGroupIndex && this.isCrossNextPage(rowNum, rowNum) && null != (block = this.mutiPartMergeData.getMergeBlockContains(excelRowNum, excelColNum, excelRowNum, excelColNum)) && block.getRow() != block.getRow2() && !this.mutiPartMergeData.isExculdeRowContains(block)) {
                    valueType = 3;
                }
            }
            switch (valueType) {
                case 3: {
                    break;
                }
                case 4: {
                    value = this.dataSource.booleanValue((Boolean)value);
                    cell.setCellValue((String)value);
                    break;
                }
                case 2: {
                    if (!StringUtil.isEmptyString((String)formula) && formula.charAt(0) == '=') {
                        formula = formula.substring(1, formula.length());
                    }
                    try {
                        boolean emptyFormula = StringUtil.isEmptyString((String)formula);
                        if (value == null) {
                            if (!emptyFormula) {
                                cell.setCellFormula(formula);
                            }
                            value = BigDecimal.valueOf(0.0);
                            break;
                        }
                        if (value instanceof Number) {
                            cell.setCellValue(((Number)value).doubleValue());
                            if (emptyFormula) {
                                cell.setCellType(CellType.NUMERIC);
                                break;
                            }
                            cell.setCellFormula(formula);
                            break;
                        }
                        if (value instanceof String) {
                            try {
                                cell.setCellValue(Double.parseDouble((String)value));
                                if (emptyFormula) {
                                    cell.setCellType(CellType.NUMERIC);
                                    break;
                                }
                                cell.setCellFormula(formula);
                            }
                            catch (NumberFormatException nfe) {
                                if (StringUtil.isEmptyString((String)((String)value))) {
                                    cell.setCellValue((String)null);
                                    if (emptyFormula) {
                                        cell.setCellType(CellType.BLANK);
                                        break;
                                    }
                                    cell.setCellFormula(formula);
                                    break;
                                }
                                cell.setCellType(CellType.STRING);
                                if (emptyFormula) {
                                    cell.setCellValue((String)value);
                                    break;
                                }
                                cell.setCellFormula(formula);
                            }
                            break;
                        }
                        if (!emptyFormula) {
                            cell.setCellFormula(formula);
                        }
                        if (value instanceof Date) {
                            cell.setCellValue((Date)value);
                            valueType = 6;
                            break;
                        }
                        if (value instanceof Calendar) {
                            cell.setCellValue((Calendar)value);
                            valueType = 6;
                            break;
                        }
                        if (!emptyFormula) break;
                        cell.setCellValue(value == null ? "" : value.toString());
                    }
                    catch (RuntimeException ex) {
                        if (value == null) {
                            value = BigDecimal.valueOf(0.0);
                        }
                        if (value instanceof Number) {
                            cell.setCellValue(((Number)value).doubleValue());
                            cell.setCellType(CellType.NUMERIC);
                            break;
                        }
                        if (value instanceof String) {
                            cell.setCellValue((String)value);
                        } else {
                            cell.setCellValue(value.toString());
                        }
                        cell.setCellType(CellType.STRING);
                    }
                    break;
                }
                case 0: {
                    if (value == null) {
                        value = new Double(0.0);
                    }
                    if (value instanceof Number) {
                        cell.setCellValue(Double.parseDouble(value.toString()));
                        break;
                    }
                    if (value instanceof Date) {
                        cell.setCellValue((Date)value);
                        valueType = 6;
                        break;
                    }
                    if (value instanceof Calendar) {
                        Calendar calendar = (Calendar)value;
                        GregorianCalendar newCalendar = new GregorianCalendar(1900, 0, 1);
                        if (calendar.before(newCalendar)) {
                            cell.setCellValue(calendar.getTime().toLocaleString());
                            cell.setCellType(CellType.STRING);
                            break;
                        }
                        cell.setCellValue((Calendar)value);
                        valueType = 6;
                        break;
                    }
                    if (!(value instanceof String)) break;
                    cell.setCellValue(value.toString());
                    cell.setCellType(CellType.STRING);
                    break;
                }
                case 1: {
                    String str;
                    if (value == null) {
                        value = "";
                    }
                    if (StringUtil.isEmptyString((String)(str = value.toString()))) {
                        cell.setCellValue("");
                        cell.setCellType(CellType.STRING);
                        break;
                    }
                    cell.setCellValue(str);
                    cell.setCellType(CellType.STRING);
                    break;
                }
                case 5: {
                    if (value == null) {
                        value = "error";
                    }
                    cell.setCellValue(value.toString());
                    break;
                }
                default: {
                    cell.setCellValue("");
                    cell.setCellType(CellType.STRING);
                }
            }
            if (value == null) {
                value = "";
            }
            this.addStyle(rowNum, colNum, (short)valueType, cell, value);
            this.addHyperLink(rowNum, colNum, cell);
            value = null;
            ++excelColNum;
            ++colNum;
        }
    }

    private void addFreezeLine(Sheet currentSheet) {
        this.dataSource.addFreezeLine(currentSheet);
    }

    private void addMerge(int rowNum, int colNum, int excelRowNum, int excelColNum) {
        AbstractDataWrapper.MergeBlock merge = this.dataSource.getMergeBlock(rowNum, colNum);
        if (merge == null) {
            return;
        }
        CellRangeAddress cra = new CellRangeAddress(excelRowNum, excelRowNum + (merge.getRow2() - merge.getRow()), excelColNum, excelColNum + (merge.getCol2() - merge.getCol()));
        this.currentSheet.addMergedRegion(cra);
    }

    private int getDefaultRealLength(String str) {
        java.awt.Font font = new java.awt.Font(CtrlCommonMessages.getMLS((String)"songti", (String)"\u5b8b\u4f53"), 0, 9);
        FontMetrics metrics = new FontMetrics(font){};
        Rectangle2D bounds = metrics.getStringBounds(str, null);
        return (int)bounds.getWidth();
    }

    private int getDefaultRealHeigh() {
        java.awt.Font font = new java.awt.Font(CtrlCommonMessages.getMLS((String)"songti", (String)"\u5b8b\u4f53"), 0, 9);
        FontMetrics metrics = new FontMetrics(font){};
        return metrics.getHeight();
    }

    private int getDefaultLeading() {
        java.awt.Font font = new java.awt.Font(CtrlCommonMessages.getMLS((String)"songti", (String)"\u5b8b\u4f53"), 0, 9);
        FontMetrics metrics = new FontMetrics(font){};
        return metrics.getLeading();
    }

    private int getLineNumber(String str, int length) {
        int index;
        int count = 1;
        String subString = str;
        while ((index = this.getSubStringLengthLargeThanGive(subString, length)) != -1 && index != subString.length()) {
            ++count;
            subString = subString.substring(index);
        }
        return count;
    }

    private int getSubStringLengthLargeThanGive(String str, int length) {
        if ("".equals(str)) {
            return -1;
        }
        int start = 0;
        int end = str.length() - 1;
        int flag = end / 2;
        String subString = str.substring(0, end);
        if (this.getDefaultRealLength(subString) == length) {
            return end;
        }
        if (this.getDefaultRealLength(subString) < length) {
            return -1;
        }
        while (this.getDefaultRealLength(subString = str.substring(0, flag)) != length) {
            if (this.getDefaultRealLength(subString) > length) {
                end = flag;
            } else {
                start = flag;
            }
            if (end - start == 1) {
                return start;
            }
            flag = (start + end) / 2;
        }
        return flag;
    }

    private Object reSetHeadValue(int rowNum, int colNum) {
        int headNumber = this.dataSource.getHeadNumber();
        Object value = null;
        for (int rowIndex = 0; rowIndex < headNumber; ++rowIndex) {
            AbstractDataWrapper.MergeBlock block = this.dataSource.getMergeBlock(rowIndex, colNum);
            if (block != null) {
                int col2;
                int col = block.getCol();
                this.isHorizontal = col != (col2 = block.getCol2());
                Object tempVal = this.getFirstVisibleCellValue(rowIndex, colNum, this.isHorizontal);
                value = value == null ? tempVal : (String)value + (String)tempVal;
                continue;
            }
            Object tempVal = null;
            tempVal = this.isHorizontal ? this.getFirstVisibleCellValue(rowIndex, colNum, this.isHorizontal) : this.dataSource.valueAt(rowIndex, colNum);
            if (null == tempVal) continue;
            value = value == null ? tempVal : (String)value + (String)tempVal;
        }
        return value;
    }

    private Object getFirstVisibleCellValue(int rowNum, int colNum, boolean isHorizontal) {
        Object value = this.dataSource.valueAt(rowNum, colNum);
        if (null == value) {
            value = isHorizontal ? this.getFirstVisibleCellValue(rowNum, colNum - 1, true) : this.getFirstVisibleCellValue(rowNum - 1, colNum, false);
        }
        return value;
    }

    private void addOrWriteMergeData(int rowNum, int colNum, int excelRowNum, int excelColNum) {
        if (this.dataSource.isExportHeadRow(rowNum) && this.dataSource.isMergeHeadRowsExport()) {
            return;
        }
        AbstractDataWrapper.MergeBlock topMergeBlock = null;
        AbstractDataWrapper.MergeBlock lastMergeBlock = this.mutiPartMergeData.getLastBlock(excelColNum, excelColNum);
        if (null != lastMergeBlock && lastMergeBlock.contains(excelRowNum, excelColNum)) {
            return;
        }
        AbstractDataWrapper.MergeBlock merge = this.dataSource.getMergeBlock(rowNum, colNum);
        if (merge != null) {
            this.mergeBlockStart = rowNum;
            if (this.isCrossNextPage(merge = new AbstractDataWrapper.MergeBlock(merge))) {
                int row2 = excelRowNum + (merge.getRow2() - merge.getRow());
                int col2 = excelColNum + (merge.getCol2() - merge.getCol());
                merge.setRow(excelRowNum);
                merge.setRow2(row2);
                merge.setCol(excelColNum);
                merge.setCol2(col2);
                if (excelColNum == 0) {
                    topMergeBlock = this.mutiPartMergeData.getMergeBlock(excelRowNum, -1, row2, -1, this.dataSource.getCellValue(rowNum - 1, this.topGroupIndex));
                }
            } else {
                CellRangeAddress cra = new CellRangeAddress(excelRowNum, excelRowNum + (merge.getRow2() - merge.getRow()), excelColNum, excelColNum + (merge.getCol2() - merge.getCol()));
                this.currentSheet.addMergedRegion(cra);
                merge = null;
            }
        } else if (this.isCrossNextPage(rowNum, rowNum)) {
            if (rowNum == this.dataSource.getExportPageRowCount() + 1) {
                merge = this.dataSource.getMergeBlock(this.mergeBlockStart, colNum);
                if (null != merge && merge.getRow2() >= rowNum) {
                    merge = new AbstractDataWrapper.MergeBlock(merge);
                    int row2 = excelRowNum + (merge.getRow2() - rowNum);
                    int col2 = excelColNum + (merge.getCol2() - merge.getCol());
                    merge.setRow(excelRowNum);
                    merge.setRow2(row2);
                    merge.setCol(excelColNum);
                    merge.setCol2(col2);
                    if (excelColNum == 0) {
                        topMergeBlock = this.mutiPartMergeData.getMergeBlock(excelRowNum, -1, row2, -1, this.dataSource.getCellValue(rowNum - 1, this.topGroupIndex));
                    }
                } else {
                    merge = null;
                }
            }
            if (null == merge) {
                merge = this.mutiPartMergeData.getMergeBlock(excelRowNum, excelColNum, excelRowNum, excelColNum, this.dataSource.getCellValue(rowNum - 1, colNum));
                if (excelColNum == 0) {
                    topMergeBlock = this.mutiPartMergeData.getMergeBlock(excelRowNum, -1, excelRowNum, -1, this.dataSource.getCellValue(rowNum - 1, this.topGroupIndex));
                }
            }
        }
        if (null != topMergeBlock) {
            this.mutiPartMergeData.merge(topMergeBlock);
        }
        if (null != merge) {
            this.mutiPartMergeData.merge(merge);
        }
    }

    private boolean isCrossNextPage(AbstractDataWrapper.MergeBlock b) {
        return this.isCrossNextPage(b.getRow(), b.getRow2());
    }

    private boolean isCrossNextPage(int row1, int row2) {
        int pageRow = this.dataSource.getExportPageRowCount();
        if (row1 == 1 && row2 < pageRow) {
            return false;
        }
        int count = 1;
        int pageCrossLine = pageRow;
        while (row2 > pageCrossLine) {
            pageCrossLine = pageRow * ++count;
        }
        return row1 == pageCrossLine - pageRow + 1 || row2 == pageCrossLine || row1 < pageCrossLine && row2 > pageCrossLine;
    }

    private void addStyle(int rowNum, int colNum, short valueType, Cell cell, Object value) {
        boolean isDateValue;
        ShareStyleAttributes ssa = this.dataSource.SSAAt(rowNum, colNum);
        boolean bl = isDateValue = valueType == 6;
        if (ssa.isEmpty() && !isDateValue) {
            cell.setCellStyle(this.emptyStyle);
            return;
        }
        if (isDateValue && StringUtil.isEmptyString((String)ssa.getNumberFormat())) {
            Calendar cal;
            if (this.dateTimeStyle == null) {
                this.dateTimeStyle = this.workbook.createCellStyle();
                this.dateStyle = this.workbook.createCellStyle();
                Font dateFont = this.workbook.createFont();
                dateFont.setFontName(ssa.getFontName());
                dateFont.setFontHeightInPoints((short)ssa.getFontSize());
                this.dateTimeStyle.setDataFormat(this.format.getFormat("yyyy-m-d hh:mm"));
                this.dateTimeStyle.setFont(dateFont);
                this.dateStyle.setDataFormat(this.format.getFormat("yyyy-m-d"));
                this.dateStyle.setFont(dateFont);
            }
            if (value instanceof Date) {
                cal = Calendar.getInstance();
                cal.setTime((Date)value);
            } else {
                cal = (Calendar)value;
            }
            if (ssa.isEmpty()) {
                if (cal.get(12) != 0 || cal.get(11) != 0) {
                    cell.setCellStyle(this.dateTimeStyle);
                } else {
                    cell.setCellStyle(this.dateStyle);
                }
            } else {
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
                if (cal.get(12) != 0 || cal.get(11) != 0) {
                    sa.setNumberFormat("yyyy-m-d hh:mm");
                } else {
                    sa.setNumberFormat("yyyy-m-d");
                }
                ssa = Styles.getSSA((StyleAttributes)sa);
                Integer hash = ssa.hashCode();
                XSSFCellStyle style = (XSSFCellStyle)this.stylesMap.get(hash);
                if (style == null) {
                    XSSFCellStyle fullStyle = (XSSFCellStyle)this.workbook.createCellStyle();
                    this.parseStyle(ssa, fullStyle, hash, rowNum, colNum);
                    cell.setCellStyle((CellStyle)fullStyle);
                    fullStyle = null;
                } else {
                    cell.setCellStyle((CellStyle)style);
                }
            }
            return;
        }
        Integer hash = ssa.hashCode();
        XSSFCellStyle style = (XSSFCellStyle)this.stylesMap.get(hash);
        if (style == null || DigitFormatPane.DataModel.isSpecialFormat((String)ssa.getNumberFormat())) {
            XSSFCellStyle fullStyle = (XSSFCellStyle)this.workbook.createCellStyle();
            this.parseStyle(ssa, fullStyle, hash, rowNum, colNum);
            cell.setCellStyle((CellStyle)fullStyle);
            fullStyle = null;
        } else {
            cell.setCellStyle((CellStyle)style);
        }
    }

    private void parseStyle(ShareStyleAttributes ssa, XSSFCellStyle fullStyle, Integer id, int rowNum, int colNum) {
        Style stl = Styles.getStyle((ShareStyleAttributes)ssa);
        XSSFFont f = this.parseFont((ShareStyleAttributes)stl, id);
        fullStyle.setFont((Font)f);
        fullStyle.setLocked(stl.isLocked());
        FillPatternType pattern = this.parsePattern((ShareStyleAttributes)stl);
        if (pattern == FillPatternType.NO_FILL) {
            fullStyle.setFillPattern(pattern);
        } else if (pattern == FillPatternType.SOLID_FOREGROUND) {
            fullStyle.setFillForegroundColor(this.parseColor(stl.getBackground()));
            fullStyle.setFillPattern(pattern);
            fullStyle.setFillBackgroundColor(this.parseColor(stl.getBackground()));
        } else {
            fullStyle.setFillBackgroundColor(this.parseColor(stl.getBackground()));
            fullStyle.setFillForegroundColor(this.parseColor(stl.getFontColor()));
            fullStyle.setFillPattern(pattern);
        }
        Styles.Position p = Styles.Position.LEFT;
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p))) {
            fullStyle.setBorderLeft(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setLeftBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.RIGHT))) {
            fullStyle.setBorderRight(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setRightBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.TOP))) {
            fullStyle.setBorderTop(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setTopBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.BOTTOM))) {
            fullStyle.setBorderBottom(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setBottomBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        fullStyle.setAlignment((HorizontalAlignment)this.parseAlignment(true, (ShareStyleAttributes)stl));
        fullStyle.setVerticalAlignment((VerticalAlignment)this.parseAlignment(false, (ShareStyleAttributes)stl));
        fullStyle.setWrapText(stl.isWrapText());
        fullStyle.setShrinkToFit(stl.isShrinkText());
        if (stl.isShrinkText() && fullStyle.getAlignment() == HorizontalAlignment.JUSTIFY) {
            fullStyle.setAlignment(HorizontalAlignment.LEFT);
        }
        fullStyle.setRotation((short)(0 - (short)stl.getRotation()));
        fullStyle.setIndention((short)stl.getIndentation());
        if (this.dataSource.isBookProtected()) {
            fullStyle.setLocked(true);
        } else {
            fullStyle.setLocked(stl.isLocked());
        }
        fullStyle.setHidden(stl.isHided());
        String numberFormat = stl.getNumberFormat();
        if (numberFormat.length() != 0) {
            if (!"000000".equals(numberFormat) && DigitFormatPane.DataModel.isSpecialFormat((String)numberFormat)) {
                String cellText = this.dataSource.textAt(rowNum, colNum);
                if (StringUtil.isEmptyString((String)cellText)) {
                    numberFormat = "";
                } else {
                    numberFormat = cellText.replaceAll("\\.", "\\\\.");
                    numberFormat = numberFormat + ";" + numberFormat;
                    numberFormat = numberFormat.replaceAll("^-", "");
                }
            }
            if (CtrlKDFMessages.getMLS("commonFormat", "G/\u901a\u7528\u683c\u5f0f").equalsIgnoreCase(numberFormat)) {
                numberFormat = "General";
            }
            if (this.isScience(numberFormat)) {
                numberFormat = numberFormat.substring(0, numberFormat.length() - 3) + "E+0";
            }
            numberFormat = numberFormat.replace('!', '\\');
            short builtInFormat = this.format.getFormat(numberFormat);
            fullStyle.setDataFormat(builtInFormat);
        }
        this.stylesMap.put(id, fullStyle);
    }

    private boolean isScience(String numberFormat) {
        String science = "(0|0(.0){1}[0]*){1}e00";
        return numberFormat.toLowerCase(Locale.ENGLISH).matches(science);
    }

    private XSSFFont parseFont(ShareStyleAttributes ssa, Integer id) {
        XSSFFont cellFont = (XSSFFont)this.fontsMap.get(id);
        if (cellFont == null) {
            cellFont = (XSSFFont)this.workbook.createFont();
            cellFont.setFontName(ssa.getFontName());
            cellFont.setColor(this.parseColor(ssa.getFontColor()));
            cellFont.setFontHeightInPoints((short)ssa.getFontSize());
            if (ssa.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (ssa.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (ssa.isBold()) {
                cellFont.setBold(true);
            }
            if (ssa.isItalic()) {
                cellFont.setItalic(true);
            }
            this.fontsMap.put(id, cellFont);
        }
        return cellFont;
    }

    private XSSFColor parseColor(Color awtColor) {
        return new XSSFColor(awtColor, null);
    }

    private BorderStyle parseBorder(ShareStyleAttributes ssa, Styles.Position pos) {
        PenStyle ps = ssa.getBorderPenStyle(pos);
        int width = ssa.getBorderLineStyle(pos).getWidth();
        switch (width) {
            case 0: {
                return BorderStyle.NONE;
            }
            case 1: {
                if (ps == PenStyle.PS_SOLID) {
                    return BorderStyle.THIN;
                }
                if (ps == PenStyle.PS_CONTINUOUS) {
                    return BorderStyle.DOTTED;
                }
                if (ps == PenStyle.PS_DOT) {
                    return BorderStyle.DASHED;
                }
                if (ps == PenStyle.PS_DASHDOTDOT) {
                    return BorderStyle.DASH_DOT;
                }
                if (ps == PenStyle.PS_DASHDOT) {
                    return BorderStyle.DASH_DOT_DOT;
                }
                return BorderStyle.THIN;
            }
        }
        if (ps == PenStyle.PS_SOLID || ps == PenStyle.PS_CONTINUOUS) {
            if (width == 2) {
                return BorderStyle.MEDIUM;
            }
            return BorderStyle.THICK;
        }
        if (ps == PenStyle.PS_DOT) {
            return BorderStyle.MEDIUM_DASHED;
        }
        if (ps == PenStyle.PS_DASHDOTDOT) {
            return BorderStyle.MEDIUM_DASH_DOT;
        }
        if (ps == PenStyle.PS_DASHDOT) {
            return BorderStyle.MEDIUM_DASH_DOT_DOT;
        }
        if (width == 2) {
            return BorderStyle.MEDIUM;
        }
        return BorderStyle.THICK;
    }

    private Object parseAlignment(boolean horizontal, ShareStyleAttributes ssa) {
        if (horizontal) {
            Styles.HorizontalAlignment align = ssa.getHorizontalAlign();
            HorizontalAlignment horizontalAlignment = align == Styles.HorizontalAlignment.LEFT ? HorizontalAlignment.LEFT : (align == Styles.HorizontalAlignment.CENTER ? HorizontalAlignment.CENTER : (align == Styles.HorizontalAlignment.RIGHT ? HorizontalAlignment.RIGHT : HorizontalAlignment.GENERAL));
            return horizontalAlignment;
        }
        Styles.VerticalAlignment align = ssa.getVerticalAlign();
        VerticalAlignment verticalAlignment = align == Styles.VerticalAlignment.TOP ? VerticalAlignment.TOP : (align == Styles.VerticalAlignment.MIDDLE ? VerticalAlignment.CENTER : (align == Styles.VerticalAlignment.BOTTOM ? VerticalAlignment.BOTTOM : VerticalAlignment.TOP));
        return verticalAlignment;
    }

    private FillPatternType parsePattern(ShareStyleAttributes ssa) {
        FillPatternType sret = FillPatternType.NO_FILL;
        switch (ssa.getPattern().getID()) {
            case 0: {
                sret = FillPatternType.NO_FILL;
                break;
            }
            case 1: {
                sret = FillPatternType.SOLID_FOREGROUND;
                break;
            }
            case 3: {
                sret = FillPatternType.FINE_DOTS;
                break;
            }
            case 26: {
                sret = FillPatternType.ALT_BARS;
                break;
            }
            case 19: {
                sret = FillPatternType.SPARSE_DOTS;
                break;
            }
            case 45: {
                sret = FillPatternType.THICK_HORZ_BANDS;
                break;
            }
            case 37: {
                sret = FillPatternType.THICK_VERT_BANDS;
                break;
            }
            case 20: {
                sret = FillPatternType.THICK_BACKWARD_DIAG;
                break;
            }
            case 28: {
                sret = FillPatternType.THICK_FORWARD_DIAG;
                break;
            }
            case 25: {
                sret = FillPatternType.BIG_SPOTS;
                break;
            }
            case 40: {
                sret = FillPatternType.BRICKS;
                break;
            }
            case 13: {
                sret = FillPatternType.THIN_HORZ_BANDS;
                break;
            }
            case 5: {
                sret = FillPatternType.THIN_VERT_BANDS;
                break;
            }
            case 4: {
                sret = FillPatternType.THIN_BACKWARD_DIAG;
                break;
            }
            case 12: {
                sret = FillPatternType.THIN_FORWARD_DIAG;
                break;
            }
            case 9: {
                sret = FillPatternType.SQUARES;
                break;
            }
            case 34: {
                sret = FillPatternType.DIAMONDS;
                break;
            }
            case 35: {
                sret = FillPatternType.LESS_DOTS;
                break;
            }
            case 43: {
                sret = FillPatternType.LEAST_DOTS;
                break;
            }
            default: {
                sret = FillPatternType.SOLID_FOREGROUND;
            }
        }
        return sret;
    }

    @Override
    public void setQueue(EventQueue q) {
        this.queue = q;
    }

    private void printSetup(Sheet currentSheet) {
        KDSSheetPrintSetup printInfo = this.dataSource.getPrintSetUp();
        if (printInfo != null) {
            try {
                Header header = currentSheet.getHeader();
                if (printInfo.getHeaderLeft() != null) {
                    header.setLeft(printInfo.getHeaderLeft());
                }
                if (printInfo.getHeaderCenter() != null) {
                    header.setCenter(printInfo.getHeaderCenter());
                }
                if (printInfo.getHeaderRight() != null) {
                    header.setRight(printInfo.getHeaderRight());
                }
                Footer footer = currentSheet.getFooter();
                if (printInfo.getFooterLeft() != null) {
                    footer.setLeft(printInfo.getFooterLeft());
                }
                if (printInfo.getFooterCenter() != null) {
                    footer.setCenter(printInfo.getFooterCenter());
                }
                if (printInfo.getFooterRight() != null) {
                    footer.setRight(printInfo.getFooterRight());
                }
                PrintSetup printSetup = currentSheet.getPrintSetup();
                if (printInfo.isUsePage()) {
                    printSetup.setUsePage(true);
                    printSetup.setPageStart(printInfo.getStartPage());
                }
                printSetup.setScale(printInfo.getScale());
                printSetup.setCopies(printInfo.getCopies());
                printSetup.setLandscape(printInfo.isLandScape());
                printSetup.setDraft(printInfo.isDraft());
                printSetup.setLeftToRight(printInfo.isRowToCol());
                printSetup.setNoColor(printInfo.isNoColor());
                printSetup.setNotes(printInfo.isHasNotes());
                printSetup.setPaperSize(printInfo.getPageSize());
                printSetup.setFitWidth(printInfo.getWidthFit());
                printSetup.setFitHeight(printInfo.getHeightFit());
                printSetup.setFooterMargin((double)printInfo.getFootDis());
                printSetup.setHeaderMargin((double)printInfo.getHeadDis());
                currentSheet.setMargin((short)3, (double)printInfo.getBottom());
                currentSheet.setMargin((short)0, (double)printInfo.getLeft());
                currentSheet.setMargin((short)1, (double)printInfo.getRight());
                currentSheet.setMargin((short)2, (double)printInfo.getTop());
                currentSheet.setHorizontallyCenter(printInfo.isHorizontalAlign());
                currentSheet.setVerticallyCenter(printInfo.isVerticalAlign());
                currentSheet.setPrintGridlines(printInfo.isPrintGridLine());
                List l = printInfo.getPrintArea();
                if (l != null) {
                    int length = l.size();
                    for (int k = 0; k < length; ++k) {
                        ITableForPrint.IBlock block = (ITableForPrint.IBlock)l.get(k);
                        this.workbook.setPrintArea(this.workbook.getSheetIndex(currentSheet), block.getCol(), block.getCol2(), block.getRow(), block.getRow2());
                    }
                }
                List l1 = printInfo.getPrintLeftTitleArea();
                List l2 = printInfo.getPrintTopTitleArea();
                if (l1 != null || l2 != null) {
                    ITableForPrint.IBlock block;
                    int k;
                    if (l1 != null) {
                        int size = l1.size();
                        for (k = 0; k < size; ++k) {
                            ITableForPrint.IBlock iBlock = block = k >= size ? null : (ITableForPrint.IBlock)l1.get(k);
                            if (block == null) continue;
                            CellRangeAddress cols = new CellRangeAddress(-1, -1, block.getCol(), block.getCol2());
                            currentSheet.setRepeatingColumns(cols);
                        }
                    }
                    if (l2 != null) {
                        int size = l2.size();
                        for (k = 0; k < size; ++k) {
                            ITableForPrint.IBlock iBlock = block = k >= size ? null : (ITableForPrint.IBlock)l2.get(k);
                            if (block == null) continue;
                            CellRangeAddress rows = new CellRangeAddress(block.getRow(), block.getRow2(), -1, -1);
                            currentSheet.setRepeatingRows(rows);
                        }
                    }
                }
                short[] colBreaks = printInfo.getColBreaks();
                short[] rowBreaks = printInfo.getRowBreaks();
                if (printInfo.isAutoFit()) {
                    currentSheet.setAutobreaks(true);
                    if (colBreaks != null && colBreaks.length > 0) {
                        printSetup.setFitWidth((short)colBreaks.length);
                    }
                    if (rowBreaks != null && rowBreaks.length > 0) {
                        printSetup.setFitHeight((short)rowBreaks.length);
                    }
                }
                if (null != rowBreaks) {
                    int iLength = rowBreaks.length;
                    for (int i = 0; i < iLength; ++i) {
                        currentSheet.setRowBreak((int)rowBreaks[i]);
                    }
                }
                if (null != colBreaks) {
                    int iLength = colBreaks.length;
                    for (int i = 0; i < iLength; ++i) {
                        currentSheet.setColumnBreak((int)colBreaks[i]);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"err", (Throwable)ex);
            }
        }
    }

    private void addEmbed(Sheet currentSheet) {
        int eoCount = this.dataSource.getEmbedObjectsCount();
        if (eoCount <= 0) {
            return;
        }
        Drawing drawing = currentSheet.createDrawingPatriarch();
        for (int i = 0; i < eoCount; ++i) {
            AbstractDataWrapper.EmbedObject eo = this.dataSource.getEmbedObject(i);
            if (eo == null || eo.getImageDatas() == null) continue;
            int pic = this.workbook.addPicture(eo.getImageDatas(), 6);
            XSSFClientAnchor anchor = new XSSFClientAnchor(eo.getDx1(), eo.getDy1(), eo.getDx2(), eo.getDy2(), eo.getCol(), eo.getRow(), eo.getCol2(), eo.getRow2());
            drawing.createPicture((ClientAnchor)anchor, pic);
        }
    }

    public void addHyperLink(int row, int col, Cell cell) {
        HyperLink hyper = this.dataSource.hyperLinkAt(row, col);
        if (hyper != null) {
            String linkTo = hyper.getLinkTo();
            CreationHelper helper = this.workbook.getCreationHelper();
            XSSFHyperlink link = (XSSFHyperlink)helper.createHyperlink(HyperlinkType.DOCUMENT);
            link.setAddress(linkTo);
            link.setLabel(hyper.getText());
            cell.setHyperlink((Hyperlink)link);
        }
    }

    private void addProtection(Sheet currentSheet) {
        this.dataSource.addProtection(currentSheet);
    }

    private void addGridLine(Sheet currentSheet) {
        CTWorksheet ctWorkbook = AbstractDataWrapper.getCtWorksheet(currentSheet);
        if (null != ctWorkbook) {
            ctWorkbook.getSheetViews().getSheetViewArray(0).setShowGridLines(this.dataSource.isExportGridLine() && this.dataSource.isShowHoriLines() && this.dataSource.isShowVertLines());
        }
    }

    private void addGroupInfo(Sheet currentSheet) {
        this.dataSource.addGroupInfo(currentSheet);
    }
}

