/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.export.direct;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.export.AbstractExporter;
import com.kingdee.cosmic.ctrl.kdf.export.ExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.export.direct.ImageExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleUtil;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public final class ImageExporter
extends AbstractExporter {
    private static final Logger logger = LogUtil.getPackageLogger(ImageExporter.class);
    private Printable printable;
    private Dimension dim;

    @Override
    public void export() {
        OutputStream os;
        this.printable = (Printable)this.parameters.get(ExporterParameter.PRINTABLE);
        if (this.printable == null) {
            throw new RuntimeException("No printable object valid");
        }
        boolean singleMode = false;
        Boolean singleObj = (Boolean)this.parameters.get(ImageExporterParameter.SINGLE_IMAGE_OUTPUT);
        if (singleObj != null) {
            singleMode = singleObj;
        }
        this.dim = (Dimension)this.parameters.get(ImageExporterParameter.IMAGE_DIMENSION);
        if (this.dim == null) {
            this.dim = new Dimension((int)StyleUtil.lomToPixel((long)2100L), (int)StyleUtil.lomToPixel((long)2970L));
        }
        if ((os = (OutputStream)this.parameters.get(ExporterParameter.OUTPUT_STREAM)) != null) {
            this.exportToStream(os, false);
        } else {
            String fileName = null;
            File destFile = (File)this.parameters.get(ExporterParameter.OUTPUT_FILE);
            if (destFile != null) {
                fileName = destFile.getAbsolutePath();
            } else {
                fileName = (String)this.parameters.get(ExporterParameter.OUTPUT_FILE_NAME);
                if (fileName != null) {
                    destFile = new File(FilenameUtils.normalize((String)fileName));
                } else {
                    throw new RuntimeException("No output file specified for the exporter.");
                }
            }
            if (singleMode) {
                try (FileOutputStream fos = new FileOutputStream(destFile);){
                    this.exportToStream(fos, true);
                    fos.flush();
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)"err", (Throwable)e);
                }
                catch (IOException e) {
                    logger.error((Object)"err", (Throwable)e);
                }
            } else {
                this.exportToMultiFile(fileName);
            }
        }
    }

    private void exportToMultiFile(String fileName) {
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
        String pre = fileName.substring(0, fileName.lastIndexOf(46));
        String firstName = pre + "_0." + ext;
        try {
            BufferedImage bi;
            int i = 0;
            while (this.printable.print((bi = new BufferedImage(this.dim.width, this.dim.height, 2)).getGraphics(), null, i) != 1) {
                File ofile;
                String fname = pre + "_" + i + "." + ext;
                if (fname.equals(firstName)) {
                    fname = fileName;
                }
                if (!ImageIO.write((RenderedImage)bi, ext, ofile = new File(FilenameUtils.normalize((String)fname)))) {
                    throw new RuntimeException("Specified Image Format not supported");
                }
                ++i;
            }
        }
        catch (PrinterException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    private void exportToStream(OutputStream os, boolean single) {
        try {
            if (single) {
                BufferedImage pi;
                int i = 0;
                BufferedImage bi = new BufferedImage(this.dim.width, this.dim.height, 2);
                while (this.printable.print((pi = new BufferedImage(this.dim.width, this.dim.height, 2)).getGraphics(), null, i) != 1) {
                    if (i > 0) {
                        BufferedImage nbi = new BufferedImage(this.dim.width, bi.getHeight() + this.dim.height, 2);
                        nbi.getGraphics().drawImage(bi, 0, 0, null);
                        bi = nbi;
                    }
                    bi.getGraphics().drawImage(pi, 0, bi.getHeight() - this.dim.height, null);
                    ++i;
                }
                if (!ImageIO.write((RenderedImage)bi, "png", os)) {
                    throw new RuntimeException("Specified Image Format not supported");
                }
            } else {
                BufferedImage bi = new BufferedImage(this.dim.width, this.dim.height, 2);
                if (this.printable.print(bi.getGraphics(), null, 0) != 1 && !ImageIO.write((RenderedImage)bi, "png", os)) {
                    throw new RuntimeException("Specified Image Format not supported");
                }
            }
        }
        catch (PrinterException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }
}

