/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.form2.ui;

import com.kingdee.cosmic.ctrl.common.GlobalLocator;
import com.kingdee.cosmic.ctrl.common.ui.WindowUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.form2.ui.INotePageProvider;
import com.kingdee.cosmic.ctrl.kdf.form2.ui.INotePrintHelper;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.preview.PreviewToolBar;
import com.kingdee.cosmic.ctrl.print.util.KDPrintUtil;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDProgressBar;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class AbstractNotePrint
implements INotePrintHelper {
    private static final Logger log = LogUtil.getLogger(AbstractNotePrint.class);
    private static Properties noteProperties;
    private INotePrintHelper.StateListener _stateListener;
    private KDPrinter _ctrlPrint;

    private static Properties getNoteConfig() {
        if (noteProperties == null) {
            noteProperties = new Properties();
            InputStream is = GlobalLocator.getInstance().locateResourceFileStream("/client/NoteConfig.properties");
            if (is != null) {
                noteProperties.clear();
                try {
                    noteProperties.load(is);
                }
                catch (IOException e) {
                    log.error((Object)"\u8bfb\u53d6\u5957\u6253\u53c2\u6570\u8bbe\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.debug((Object)"\u5173\u95ed\u8f93\u5165\u6d41\u5931\u8d25", (Throwable)e);
                    }
                }
            }
        }
        return noteProperties;
    }

    @Override
    public void setPrinterCtrl(KDPrinter printer) {
        this._ctrlPrint = printer;
    }

    public KDPrinter getPrinterCtrl() {
        return this._ctrlPrint;
    }

    @Override
    public void setStateListener(INotePrintHelper.StateListener l) {
        this._stateListener = l;
    }

    protected void fireStateListener(int key, Object value) {
        this._stateListener.notifyState(key, value);
    }

    public static int runPrintCtrl(KDPrinter printer, boolean isPreview, boolean isShowPrinterDialog, Component owner, String title) {
        printer.setPreviewWindowType(0);
        printer.setParentWindow(owner);
        printer.getPrintConfig().setPrintJobName(title);
        if (isPreview) {
            if (StringUtil.isEmptyString((String)title)) {
                printer.printPreview();
            } else {
                printer.printPreview(title);
            }
        } else if (isShowPrinterDialog) {
            if (!KDPrintUtil.isPrintDirect((String)printer.getPrintConfig().getPrintJobName())) {
                return printer.print2();
            }
            printer.print();
        } else {
            printer.printDirect();
        }
        return -1;
    }

    public static int getMaxPagesLimit() {
        String value = AbstractNotePrint.getNoteConfig().getProperty("MaxPagesLimit");
        int result = 10000;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    protected boolean isShowMarginPanel() {
        String value = AbstractNotePrint.getNoteConfig().getProperty("ShowMarginPanel");
        return "true".equalsIgnoreCase(value);
    }

    public static boolean isExportExcel() {
        String value = AbstractNotePrint.getNoteConfig().getProperty("ExportExcel");
        return "true".equalsIgnoreCase(value);
    }

    protected void configToolbar() {
        PreviewToolBar bar = this.getPrinterCtrl().getPrintPreview().getPreviewBar();
        bar.getButtonItem(10).setVisible(this.isShowMarginPanel());
    }

    private static String getMLS(String key, String defaultValue) {
        return CtrlKDFMessages.getMLS(key, defaultValue);
    }

    protected static class PageProviderListener
    implements INotePageProvider.INotePageProviderListener {
        private WaitingDialog dlg;

        public PageProviderListener(WaitingDialog dlg) {
            this.dlg = dlg;
        }

        @Override
        public void firstPagePrepared() {
            this.dlg.waitingFinish();
        }

        @Override
        public void cancelBeforeOutput() {
            this.dlg.waitingFinish();
        }
    }

    protected static class WaitingDialog
    extends KDDialog {
        private boolean isUserCancel = false;
        private boolean isWaitingFinish = false;

        public static WaitingDialog create(Component parentCtrl) {
            Window owner;
            Window window = owner = parentCtrl instanceof Window ? (Window)parentCtrl : SwingUtilities.getWindowAncestor(parentCtrl);
            if (owner instanceof Dialog) {
                return new WaitingDialog((Dialog)owner);
            }
            if (owner instanceof Frame) {
                return new WaitingDialog((Frame)owner);
            }
            return new WaitingDialog();
        }

        public WaitingDialog() {
            this.init();
        }

        public WaitingDialog(Dialog owner) {
            super(owner);
            this.init();
        }

        public WaitingDialog(Frame owner) {
            super(owner);
            this.init();
        }

        private void init() {
            KDLabel lab = new KDLabel(AbstractNotePrint.getMLS("waiting", "\u6570\u636e\u51c6\u5907\u53ef\u80fd\u9700\u8981\u8f83\u957f\u65f6\u95f4\uff0c\u8bf7\u7b49\u5f85\u2026\u2026"));
            KDProgressBar bar = new KDProgressBar();
            bar.setIndeterminate(true);
            bar.setBorderPainted(false);
            this.getContentPane().setLayout(null);
            this.getContentPane().add((Component)lab);
            this.getContentPane().add((Component)bar);
            this.setTitle(AbstractNotePrint.getMLS("preview", "\u5957\u6253\u9884\u89c8"));
            this.setModal(true);
            this.setSize(480, 100);
            this.setResizable(false);
            this.setLocationRelativeTo(null);
            this.setDefaultCloseOperation(0);
            lab.setBounds(10, 10, 450, 30);
            bar.setBounds(10, 40, 450, 20);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    boolean result = WindowUtil.msgboxYesNo((Component)((Object)this), (Object)AbstractNotePrint.getMLS("areYouSure", "\u9000\u51fa\u5f53\u524d\u64cd\u4f5c\uff0c\u60a8\u786e\u5b9a\u5417\uff1f"), (String)AbstractNotePrint.getMLS("preview", "\u5957\u6253\u9884\u89c8"));
                    if (result) {
                        this.dispose();
                        isUserCancel = true;
                    }
                }
            });
        }

        public boolean isUserCancel() {
            return this.isUserCancel;
        }

        public void waitingFinish() {
            this.isWaitingFinish = true;
            this.dispose();
        }

        public void show() {
            if (!this.isWaitingFinish) {
                super.show();
            }
        }
    }
}

