/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.formbrowser2.commands;

import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.ContextOfBrowser;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.commands.Command;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.commands.CommandException;
import java.util.Hashtable;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class GotoPageCommand
extends AbstractUndoableEdit
implements Command {
    private static final long serialVersionUID = 88976876L;
    private transient ContextOfBrowser context;
    private int originVal = -1;
    private String cmdtext;
    private Hashtable cmdparams;
    private int cmdparamsTargePage;
    private boolean hasBeenDone = false;

    public GotoPageCommand() {
    }

    public GotoPageCommand(ContextOfBrowser context) {
        this.context = context;
    }

    public void Init() {
    }

    @Override
    public boolean canRedo() {
        return !this.hasBeenDone;
    }

    @Override
    public boolean canUndo() {
        return this.hasBeenDone;
    }

    @Override
    public void setCommandText(String cmdtext) {
        this.cmdtext = cmdtext;
    }

    @Override
    public void setParameters(Hashtable cmdparams) {
    }

    public void setParameters(Object oparam) throws CommandException {
        if (oparam == null || oparam.getClass() != Integer.class) {
            throw new CommandException(CtrlKDFMessages.getMLS("parameterError", "\u53c2\u6570\u9519\u8bef"));
        }
        this.cmdparamsTargePage = (Integer)oparam;
    }

    public boolean doGoto(int target) {
        this.saveOldIndex();
        this.cmdtext = "goto";
        return this.context.Goto(target);
    }

    public boolean doGotoPrevious() {
        this.saveOldIndex();
        this.cmdtext = "previous";
        return this.context.Goto(this.context.getCurrentPage() - 1);
    }

    public boolean doGotoNext() {
        this.saveOldIndex();
        this.cmdtext = "next";
        return this.context.Goto(this.context.getCurrentPage() + 1);
    }

    public boolean doGotoFirst() {
        this.saveOldIndex();
        this.cmdtext = "fist";
        return this.context.Goto(0);
    }

    public boolean doGotoLast() {
        this.saveOldIndex();
        this.cmdtext = "last";
        return this.context.Goto(this.context.getTotalPageCount() - 1);
    }

    private void saveOldIndex() {
        if (this.originVal == -1) {
            this.originVal = this.context.getCurrentPage();
        }
    }

    @Override
    public void execute() throws CommandException {
        if (this.cmdtext.equals("goto")) {
            this.doGoto(this.cmdparamsTargePage);
        } else if (this.cmdtext.equals("previous")) {
            this.doGotoPrevious();
        } else if (this.cmdtext.equals("next")) {
            this.doGotoNext();
        } else if (this.cmdtext.equals("first")) {
            this.doGotoFirst();
        } else if (this.cmdtext.equals("last")) {
            this.doGotoLast();
        } else {
            throw new CommandException("unknown command text ");
        }
        this.hasBeenDone = true;
    }

    @Override
    public void unexecute() {
        this.undo();
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.context.Goto(this.originVal);
        this.hasBeenDone = false;
    }

    @Override
    public void redo() throws CannotUndoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.context.Goto(this.cmdparamsTargePage);
    }

    @Override
    public Object clone() {
        GotoPageCommand obj = new GotoPageCommand(this.context);
        obj.cmdparams = new Hashtable(this.cmdparams);
        obj.cmdparamsTargePage = this.cmdparamsTargePage;
        obj.cmdtext = String.valueOf(this.cmdtext);
        return obj;
    }

    public void setCmdparamsTargePage(int i) {
        this.cmdparamsTargePage = i;
    }

    public void setCmdtext(String string) {
        this.cmdtext = string;
    }

    public void setHasBeenDone(boolean b) {
        this.hasBeenDone = b;
    }

    public void setOriginVal(int i) {
        this.originVal = i;
    }

    public void store() {
    }
}

