/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.formbrowser2.formobjects;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.kdf.form.Container;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.PhysicalPage;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.formobjects.FormContainerObject;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.util.ArrayList;

public abstract class FormObject {
    public Container contOfOutForm;
    private Container sourceContOfForm;
    private FormContainerObject parent;
    private ShareStyleAttributes _ssa;
    private Style _style;
    public int x;
    public int y;
    public int width;
    public int height;
    public float zoom_factor = 1.0f;
    PhysicalPage firstOwnerPage;
    public Color lightcolor;
    public String transparent = "";
    private String layer = "";
    private int pageIdx;
    private Page formPage;

    public void reloadStyle() {
        this._ssa = FormObject.getElementSSA(this.contOfOutForm);
        this._style = Styles.getStyle((ShareStyleAttributes)this._ssa);
    }

    public FormObject(int x, int y, int width, int height, Container cont, FormContainerObject parent) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.contOfOutForm = cont;
        this.sourceContOfForm = cont.getSource();
        this.parent = parent;
        this.layer = cont.getLayer();
        this._ssa = FormObject.getElementSSA(cont);
        this._style = Styles.getStyle((ShareStyleAttributes)this._ssa);
    }

    public int getZoomedDim(int dim) {
        if (ArrayUtil.isEqual((Float)Float.valueOf(this.zoom_factor), (Float)Float.valueOf(1.0f))) {
            return dim;
        }
        return (int)((float)dim * this.zoom_factor);
    }

    public float getZoomedDim(float dim) {
        if (ArrayUtil.isEqual((Float)Float.valueOf(this.zoom_factor), (Float)Float.valueOf(1.0f))) {
            return dim;
        }
        return dim * this.zoom_factor;
    }

    public void transform(int x, int y) {
        this.x += x;
        this.y += y;
        this.contOfOutForm.getLeft().setInteger(this.contOfOutForm.getLeft().getInteger() + x * 254 / 72);
        this.contOfOutForm.getTop().setInteger(this.contOfOutForm.getTop().getInteger() + y * 254 / 72);
        this.contOfOutForm.getRight().setInteger(this.contOfOutForm.getRight().getInteger() + x * 254 / 72);
        this.contOfOutForm.getBottom().setInteger(this.contOfOutForm.getBottom().getInteger() + y * 254 / 72);
    }

    public static ShareStyleAttributes getElementSSA(Container e) {
        ArrayList<ShareStyleAttributes> lssa = new ArrayList<ShareStyleAttributes>();
        do {
            lssa.add(e.getCustomStyles().getStyleAttributes());
            lssa.add(e.getStyles());
        } while ((e = e.getParent()) != null);
        ShareStyleAttributes[] assa = new ShareStyleAttributes[lssa.size()];
        lssa.toArray(assa);
        return Styles.mergeSSA((ShareStyleAttributes[])assa);
    }

    public Color getBgcolor() {
        return this._ssa.getBackground();
    }

    public Color getFgcolor() {
        return this._ssa.getFontColor();
    }

    public int getHeight() {
        return this.height;
    }

    public Color getLightcolor() {
        return this.lightcolor;
    }

    public Container getSourceContOfForm() {
        return this.sourceContOfForm;
    }

    public Container getContOfOutForm() {
        return this.contOfOutForm;
    }

    public Style getStyle() {
        return this._style;
    }

    public ShareStyleAttributes getSSA() {
        return this._ssa;
    }

    public String getTransparent() {
        return this.transparent;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public float getZoom_factor() {
        return this.zoom_factor;
    }

    public void setBgcolor(Color color) {
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)this._ssa);
        sa.setBackground(color);
        this._ssa = Styles.getSSA((StyleAttributes)sa);
        this._style = Styles.getStyle((ShareStyleAttributes)this._ssa);
    }

    public void setFgcolor(Color color) {
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)this._ssa);
        sa.setFontColor(color);
        this._ssa = Styles.getSSA((StyleAttributes)sa);
        this._style = Styles.getStyle((ShareStyleAttributes)this._ssa);
    }

    public void setHeight(int i) {
        this.height = i;
    }

    public void setLightcolor(Color color) {
        this.lightcolor = color;
    }

    public void setSourceContOfForm(Container container) {
        this.sourceContOfForm = container;
    }

    public void setTransparent(String string) {
        this.transparent = string;
    }

    public void setWidth(int i) {
        this.width = i;
    }

    public void setX(int i) {
        this.x = i;
    }

    public void setY(int i) {
        this.y = i;
    }

    public void setZoom_factor(float f) {
        this.zoom_factor = f;
    }

    public String getLayer() {
        return this.layer;
    }

    public void putChild(FormObject achild) {
    }

    public int getPageIdx() {
        return this.pageIdx;
    }

    public void setPageIdx(int i) {
        this.pageIdx = i;
    }

    public PhysicalPage getFirstOwnerPage() {
        return this.firstOwnerPage;
    }

    public void setFirstOwnerPage(PhysicalPage p) {
        this.firstOwnerPage = p;
    }

    public Page getFormPage() {
        return this.formPage;
    }

    public void setFormPage(Page page) {
        this.formPage = page;
    }

    public FormContainerObject getParent() {
        return this.parent;
    }
}

