/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.formbrowser2.util;

import com.kingdee.cosmic.ctrl.common.GlobalLocator;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.util.FormBrowserConfig;
import java.io.File;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class FormBrowserConfManager {
    private static final Logger logger = LogUtil.getLogger(FormBrowserConfManager.class);
    private String configfile;
    private FormBrowserConfig config = new FormBrowserConfig();
    private static FormBrowserConfManager defaultManager;

    public FormBrowserConfig getConf() {
        return this.config;
    }

    public static FormBrowserConfManager getDefaultInstance() {
        if (defaultManager == null) {
            defaultManager = new FormBrowserConfManager();
            defaultManager.LoadConfig();
        }
        return defaultManager;
    }

    private void LoadConfig() {
        logger.debug((Object)"load Form-Browser cofig...");
        File f = GlobalLocator.getInstance().locateResourceFile("/client/FormBrowser.xml");
        if (f == null) {
            return;
        }
        String path = f.getPath();
        XMLReader xmlReader = null;
        try {
            ConfSAXHandler handler = new ConfSAXHandler();
            xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xmlReader.setContentHandler(handler);
            xmlReader.setErrorHandler(handler);
            InputSource source = new InputSource(path);
            xmlReader.parse(source);
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
        }
    }

    public String getConfigfile() {
        return this.configfile;
    }

    private class ConfSAXHandler
    extends DefaultHandler
    implements ErrorHandler {
        boolean bParsing_StopRetriveAtClosing = false;

        private ConfSAXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!qName.equalsIgnoreCase("buttons")) {
                if (qName.equalsIgnoreCase("button")) {
                    String s = attributes.getValue("classname");
                    FormBrowserConfManager.this.config.addEnableAction(s);
                    logger.debug((Object)("add toolbar button =" + s));
                } else if (qName.equalsIgnoreCase("stopRetriveAtClosing")) {
                    this.bParsing_StopRetriveAtClosing = true;
                } else if (qName.equalsIgnoreCase("formServer")) {
                    String serverMode = attributes.getValue("mode");
                    if (serverMode == null) {
                        logger.error((Object)("\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1aformServer\u8282\u70b9\u6ca1\u6709mode\u5c5e\u6027" + FormBrowserConfManager.this.configfile));
                    } else if (serverMode.equalsIgnoreCase("remote")) {
                        String tcpUrl = attributes.getValue("tcpurl");
                        if (tcpUrl == null) {
                            logger.error((Object)("\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1aremote\u6a21\u5f0f\u6ca1\u6709tcpurl" + FormBrowserConfManager.this.configfile));
                        } else {
                            FormBrowserConfManager.this.config.setRemoteMode(true, tcpUrl);
                        }
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!qName.equalsIgnoreCase("buttons") && qName.equalsIgnoreCase("stopRetriveAtClosing")) {
                this.bParsing_StopRetriveAtClosing = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String strVal = new String(ch, start, length);
            if (this.bParsing_StopRetriveAtClosing) {
                if (strVal.equalsIgnoreCase("false")) {
                    FormBrowserConfManager.this.config.setStopRetriveAtClose(false);
                } else if (strVal.equalsIgnoreCase("true")) {
                    FormBrowserConfManager.this.config.setStopRetriveAtClose(true);
                }
            }
        }
    }
}

